/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_volumes")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="volume")
public class VolumeTag
extends Tag<VolumeTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Volume volume;

    protected VolumeTag() {
        super("volume", ResourceIdFunction.INSTANCE);
    }

    public VolumeTag(@Nonnull Volume volume, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("volume", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setVolume(volume);
        this.init();
    }

    public Volume getVolume() {
        return this.volume;
    }

    public void setVolume(Volume volume) {
        this.volume = volume;
    }

    @Nonnull
    public static Tag named(@Nonnull Volume volume, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return VolumeTag.namedWithValue(volume, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull Volume volume, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)volume), (Object)"volume");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new VolumeTag(volume, ownerFullName, key, value);
    }

    public static final class VolumeTagSupport
    extends TagSupport {
        public VolumeTagSupport() {
            super(Volume.class, "vol", "displayName", "volume", "InvalidVolume.NotFound", "The volume '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new VolumeTag((Volume)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return VolumeTag.namedWithValue((Volume)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new VolumeTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)Volume.named(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<VolumeTag, String>
    {
        INSTANCE{

            public String apply(VolumeTag volumeTag) {
                return volumeTag.getVolume().getDisplayName();
            }
        };

    }
}

