/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.blockstorage.Snapshots;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.blockstorage.Volumes;
import com.eucalyptus.blockstorage.msgs.DeleteStorageVolumeResponseType;
import com.eucalyptus.blockstorage.msgs.DeleteStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.DetachStorageVolumeType;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenResponseType;
import com.eucalyptus.blockstorage.msgs.GetVolumeTokenType;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.cluster.callback.VolumeAttachCallback;
import com.eucalyptus.cluster.callback.VolumeDetachCallback;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.compute.common.AttachedVolume;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.backend.AttachVolumeResponseType;
import com.eucalyptus.compute.common.backend.AttachVolumeType;
import com.eucalyptus.compute.common.backend.CreateVolumeResponseType;
import com.eucalyptus.compute.common.backend.CreateVolumeType;
import com.eucalyptus.compute.common.backend.DeleteVolumeResponseType;
import com.eucalyptus.compute.common.backend.DeleteVolumeType;
import com.eucalyptus.compute.common.backend.DescribeVolumeAttributeResponseType;
import com.eucalyptus.compute.common.backend.DescribeVolumeAttributeType;
import com.eucalyptus.compute.common.backend.DescribeVolumeStatusResponseType;
import com.eucalyptus.compute.common.backend.DescribeVolumeStatusType;
import com.eucalyptus.compute.common.backend.DescribeVolumesResponseType;
import com.eucalyptus.compute.common.backend.DescribeVolumesType;
import com.eucalyptus.compute.common.backend.DetachVolumeResponseType;
import com.eucalyptus.compute.common.backend.DetachVolumeType;
import com.eucalyptus.compute.common.backend.EnableVolumeIOResponseType;
import com.eucalyptus.compute.common.backend.EnableVolumeIOType;
import com.eucalyptus.compute.common.backend.ModifyVolumeAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifyVolumeAttributeType;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.records.EventClass;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.reporting.event.VolumeEvent;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.vm.MigrationState;
import com.eucalyptus.vm.VmEphemeralAttachment;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import edu.ucsb.eucalyptus.cloud.VolumeSizeExceededException;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterAttachVolumeType;
import edu.ucsb.eucalyptus.msgs.ClusterDetachVolumeType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;

public class VolumeManager {
    private static final int VOL_CREATE_RETRIES = 10;
    private static Logger LOG = Logger.getLogger(VolumeManager.class);

    public CreateVolumeResponseType CreateVolume(final CreateVolumeType request) throws EucalyptusCloudException, AuthException {
        Integer sizeFromRequest;
        Context ctx = Contexts.lookup();
        Long volSize = request.getSize() != null ? Long.valueOf(Long.parseLong(request.getSize())) : null;
        final String snapId = VolumeManager.normalizeOptionalSnapshotIdentifier(request.getSnapshotId());
        Integer snapSize = 0;
        String partition = request.getAvailabilityZone();
        if (request.getSnapshotId() == null && request.getSize() == null) {
            throw new EucalyptusCloudException("One of size or snapshotId is required as a parameter.");
        }
        if (snapId != null) {
            try {
                Snapshot snap = (Snapshot)((Object)Transactions.find((Object)((Object)Snapshot.named(null, VolumeManager.normalizeOptionalSnapshotIdentifier(snapId)))));
                snapSize = snap.getVolumeSize();
                if (!Predicates.and((Predicate)Snapshots.FilterPermissions.INSTANCE, (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner()).apply((Object)snap)) {
                    throw new EucalyptusCloudException("Not authorized to use snapshot " + snapId + " by " + ctx.getUser().getName());
                }
                if (volSize != null && snap != null && snap.getVolumeSize() != null && volSize < (long)snap.getVolumeSize().intValue()) {
                    throw new EucalyptusCloudException("Volume size cannot be less than snapshot size");
                }
            }
            catch (ExecutionException ex) {
                throw new EucalyptusCloudException("Failed to create volume because the referenced snapshot id is invalid: " + snapId);
            }
        }
        Integer n = sizeFromRequest = request.getSize() != null ? new Integer(request.getSize()) : null;
        if (sizeFromRequest != null && sizeFromRequest <= 0) {
            throw new EucalyptusCloudException("Failed to create volume because the parameter size (" + sizeFromRequest + ") must be greater than zero.");
        }
        Integer newSize = sizeFromRequest != null ? sizeFromRequest : (snapId != null ? snapSize : new Integer(-1));
        RuntimeException lastEx = null;
        for (int i = 0; i < 10; ++i) {
            try {
                final ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)partition)});
                final UserFullName owner = ctx.getUserFullName();
                Function<Long, Volume> allocator = new Function<Long, Volume>(){

                    public Volume apply(Long size) {
                        try {
                            return Volumes.createStorageVolume(sc, owner, snapId, Ints.checkedCast((long)size), (BaseMessage)request);
                        }
                        catch (ExecutionException ex) {
                            throw Exceptions.toUndeclared((Throwable)ex);
                        }
                    }
                };
                Volume newVol = (Volume)RestrictedTypes.allocateMeasurableResource((Long)newSize.longValue(), (Function)allocator);
                CreateVolumeResponseType reply = (CreateVolumeResponseType)request.getReply();
                reply.setVolume(newVol.morph(new com.eucalyptus.compute.common.Volume()));
                return reply;
            }
            catch (RuntimeException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                VolumeSizeExceededException volumeSizeException = (VolumeSizeExceededException)Exceptions.findCause((Throwable)ex, VolumeSizeExceededException.class);
                if (volumeSizeException != null) {
                    throw new ClientComputeException("VolumeLimitExceeded", "Failed to create volume because of: " + volumeSizeException.getMessage());
                }
                if (!(ex.getCause() instanceof ExecutionException)) {
                    throw ex;
                }
                lastEx = ex;
                continue;
            }
        }
        throw new EucalyptusCloudException("Failed to create volume after 10 because of: " + lastEx, lastEx);
    }

    public DeleteVolumeResponseType DeleteVolume(DeleteVolumeType request) throws EucalyptusCloudException {
        DeleteVolumeResponseType reply = (DeleteVolumeResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        reply.set_return(Boolean.valueOf(false));
        Function<String, Volume> deleteVolume = new Function<String, Volume>(){

            public Volume apply(String input) {
                try {
                    Volume vol = null;
                    try {
                        vol = (Volume)((Object)Entities.uniqueResult((Object)((Object)Volume.named((OwnerFullName)ctx.getUserFullName().asAccountFullName(), input))));
                    }
                    catch (NoSuchElementException e) {
                        try {
                            vol = (Volume)((Object)Entities.uniqueResult((Object)((Object)Volume.named(null, input))));
                        }
                        catch (NoSuchElementException e2) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidVolume.NotFound", "The volume '" + input + "' does not exist")));
                        }
                    }
                    if (!RestrictedTypes.filterPrivileged().apply((Object)vol)) {
                        throw Exceptions.toUndeclared((String)("Not authorized to delete volume by " + ctx.getUser().getName()), (Throwable[])new Throwable[0]);
                    }
                    try {
                        VmVolumeAttachment attachment = VmInstances.lookupVolumeAttachment(input);
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("VolumeInUse", "Volume is currently attached to: " + attachment.getVmInstance().getDisplayName())));
                    }
                    catch (NoSuchElementException attachment) {
                        if (State.FAIL.equals(vol.getState()) || State.ANNIHILATED.equals(vol.getState())) {
                            Entities.delete((Object)((Object)vol));
                            return vol;
                        }
                        try {
                            ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)vol.getPartition())});
                            DeleteStorageVolumeResponseType scReply = (DeleteStorageVolumeResponseType)AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)new DeleteStorageVolumeType(vol.getDisplayName()));
                            if (scReply.get_return().booleanValue()) {
                                Volumes.annihilateStorageVolume(vol);
                                return vol;
                            }
                            throw Exceptions.toUndeclared((String)"Storage Controller returned false:  Contact the administrator to report the problem.", (Throwable[])new Throwable[0]);
                        }
                        catch (Exception ex) {
                            throw Exceptions.toUndeclared((String)("Delete volume request failed because of: " + ex.getMessage()), (Throwable[])new Exception[]{ex});
                        }
                    }
                }
                catch (NoSuchElementException ex) {
                    throw ex;
                }
                catch (TransactionException ex) {
                    throw Exceptions.toUndeclared((String)"Deleting volume failed:  Contact the administrator to report the problem.", (Throwable[])new TransactionException[]{ex});
                }
            }
        };
        try {
            Entities.asTransaction(Volume.class, (Function)deleteVolume).apply((Object)VolumeManager.normalizeVolumeIdentifier(request.getVolumeId()));
            reply.set_return(Boolean.valueOf(true));
            return reply;
        }
        catch (NoSuchElementException ex) {
            return reply;
        }
        catch (RuntimeException ex) {
            Exceptions.rethrow((RuntimeException)ex, ComputeException.class);
            throw ex;
        }
    }

    public DescribeVolumeAttributeResponseType DescribeVolumeAttribute(DescribeVolumeAttributeType request) {
        return (DescribeVolumeAttributeResponseType)request.getReply();
    }

    public DescribeVolumeStatusResponseType DescribeVolumeStatus(DescribeVolumeStatusType request) {
        return (DescribeVolumeStatusResponseType)request.getReply();
    }

    public DescribeVolumesResponseType DescribeVolumes(DescribeVolumesType request) throws Exception {
        final DescribeVolumesResponseType reply = (DescribeVolumesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.getVolumeSet().remove("verbose");
        final AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        HashSet volumeIds = Sets.newHashSet(VolumeManager.normalizeVolumeIdentifiers(request.getVolumeSet()));
        final Filter filter = Filters.generate(request.getFilterSet(), Volume.class);
        final Predicate requestedAndAccessible = CloudMetadatas.filteringFor(Volume.class).byId((Collection)volumeIds).byPredicate(filter.asPredicate()).byPrivileges().buildPredicate();
        Function<Set<String>, Set<String>> lookupVolumeIds = new Function<Set<String>, Set<String>>(){

            public Set<String> apply(Set<String> input) {
                List volumes = Entities.query((Object)((Object)Volume.named((OwnerFullName)ownerFullName, null)), (boolean)true, (Criterion)filter.asCriterion(), filter.getAliases());
                HashSet res = Sets.newHashSet();
                for (Volume foundVol : Iterables.filter((Iterable)volumes, (Predicate)requestedAndAccessible)) {
                    res.add(foundVol.getDisplayName());
                }
                return res;
            }
        };
        Set allowedVolumeIds = (Set)Entities.asTransaction(Volume.class, (Function)lookupVolumeIds).apply((Object)volumeIds);
        EntityTransaction db = Entities.get(VmInstance.class);
        try {
            final List vms = Entities.query((Object)((Object)VmInstance.create()));
            Function<String, Volume> lookupVolume = new Function<String, Volume>(){

                public Volume apply(String input) {
                    try {
                        AttachedVolume attachedVolume;
                        Volume foundVol;
                        block7: {
                            foundVol = (Volume)((Object)Entities.uniqueResult((Object)((Object)Volume.named((OwnerFullName)ownerFullName, input))));
                            if (State.ANNIHILATED.equals(foundVol.getState())) {
                                Entities.delete((Object)((Object)foundVol));
                                reply.getVolumeSet().add(foundVol.morph(new com.eucalyptus.compute.common.Volume()));
                                return foundVol;
                            }
                            attachedVolume = null;
                            try {
                                VmVolumeAttachment attachment = VmInstances.lookupVolumeAttachment(input, vms);
                                attachedVolume = (AttachedVolume)VmVolumeAttachment.asAttachedVolume(attachment.getVmInstance()).apply((Object)attachment);
                            }
                            catch (NoSuchElementException ex) {
                                if (!State.BUSY.equals(foundVol.getState())) break block7;
                                foundVol.setState(State.EXTANT);
                            }
                        }
                        com.eucalyptus.compute.common.Volume msgTypeVolume = foundVol.morph(new com.eucalyptus.compute.common.Volume());
                        if (attachedVolume != null) {
                            msgTypeVolume.setStatus("in-use");
                            msgTypeVolume.getAttachmentSet().add(attachedVolume);
                        }
                        reply.getVolumeSet().add(msgTypeVolume);
                        return foundVol;
                    }
                    catch (NoSuchElementException ex) {
                        throw ex;
                    }
                    catch (TransactionException ex) {
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
            };
            for (String volId : allowedVolumeIds) {
                try {
                    Entities.asTransaction(Volume.class, (Function)lookupVolume).apply((Object)volId);
                }
                catch (Exception ex) {
                    Logs.extreme().debug((Object)ex, (Throwable)ex);
                }
            }
            Map<String, List<Tag>> tagsMap = TagSupport.forResourceClass(Volume.class).getResourceTagMap((OwnerFullName)AccountFullName.getInstance((Account)ctx.getAccount(), (String[])new String[0]), allowedVolumeIds);
            for (com.eucalyptus.compute.common.Volume volume : reply.getVolumeSet()) {
                Tags.addFromTags(volume.getTagSet(), ResourceTag.class, (Iterable<Tag>)tagsMap.get(volume.getVolumeId()));
            }
            db.commit();
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return reply;
    }

    public EnableVolumeIOResponseType EnableVolumeIO(EnableVolumeIOType request) {
        return (EnableVolumeIOResponseType)request.getReply();
    }

    public AttachVolumeResponseType AttachVolume(AttachVolumeType request) throws EucalyptusCloudException {
        AttachVolumeResponseType reply = (AttachVolumeResponseType)request.getReply();
        final String deviceName = request.getDevice();
        String volumeId = VolumeManager.normalizeVolumeIdentifier(request.getVolumeId());
        String instanceId = VolumeManager.normalizeInstanceIdentifier(request.getInstanceId());
        Context ctx = Contexts.lookup();
        if (deviceName == null || !this.validateDeviceName(deviceName)) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + deviceName + ") for parameter device is invalid.");
        }
        VmInstance vm = null;
        try {
            vm = (VmInstance)RestrictedTypes.doPrivileged((String)instanceId, VmInstance.class);
        }
        catch (NoSuchElementException e) {
            throw new ClientComputeException("InvalidInstanceID.NotFound", "The instance ID '" + request.getInstanceId() + "' does not exist");
        }
        catch (Exception ex) {
            LOG.debug((Object)ex, (Throwable)ex);
            throw new EucalyptusCloudException(ex.getMessage(), (Throwable)ex);
        }
        if (MigrationState.isMigrating(vm)) {
            throw Exceptions.toUndeclared((String)("Cannot attach a volume to an instance which is currently migrating: " + vm.getInstanceId() + " " + vm.getMigrationTask()), (Throwable[])new Throwable[0]);
        }
        AccountFullName ownerFullName = ctx.getUserFullName().asAccountFullName();
        Volume volume = null;
        try {
            volume = Volumes.lookup((OwnerFullName)ownerFullName, volumeId);
        }
        catch (NoSuchElementException ex2) {
            try {
                volume = Volumes.lookup(null, volumeId);
            }
            catch (NoSuchElementException e) {
                throw new ClientComputeException("InvalidVolume.NotFound", "The volume '" + request.getVolumeId() + "' does not exist");
            }
        }
        if (!RestrictedTypes.filterPrivileged().apply((Object)volume)) {
            throw new EucalyptusCloudException("Not authorized to attach volume " + volumeId + " by " + ctx.getUser().getName());
        }
        try {
            vm.lookupVolumeAttachmentByDevice(deviceName);
            throw new ClientComputeException("InvalidParameterValue", "Already have a device attached to: " + request.getDevice());
        }
        catch (NoSuchElementException ex2) {
            if (Iterables.any(VmInstances.lookupEphemeralDevices(instanceId), (Predicate)new Predicate<VmEphemeralAttachment>(){

                public boolean apply(VmEphemeralAttachment device) {
                    return deviceName.endsWith(device.getShortDeviceName());
                }
            })) {
                throw new ClientComputeException("InvalidParameterValue", "Already have an ephemeral device attached to: " + request.getDevice());
            }
            try {
                VmInstances.lookupVolumeAttachment(volumeId);
                throw new ClientComputeException("VolumeInUse", "Volume already attached: " + volumeId);
            }
            catch (NoSuchElementException ex2) {
                Partition volPartition = Partitions.lookupByName((String)volume.getPartition());
                ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{volPartition});
                ServiceConfiguration scVm = Topology.lookup(Storage.class, (Partition[])new Partition[]{vm.lookupPartition()});
                if (!sc.equals(scVm)) {
                    throw new EucalyptusCloudException("Can only attach volumes in the same zone: " + volumeId);
                }
                if (VmInstance.VmState.STOPPED.equals(vm.getState())) {
                    String rootDevice = vm.getBootRecord().getMachine().getRootDeviceName();
                    if (rootDevice.equals(deviceName)) {
                        vm.addPermanentVolume(deviceName, volume, Boolean.TRUE);
                    } else {
                        vm.addPermanentVolume(deviceName, volume, Boolean.FALSE);
                    }
                } else {
                    GetVolumeTokenResponseType scGetTokenResponse;
                    ServiceConfiguration ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{vm.lookupPartition()});
                    try {
                        GetVolumeTokenType req = new GetVolumeTokenType(volume.getDisplayName());
                        scGetTokenResponse = (GetVolumeTokenResponseType)AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)req);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to attach volume " + volume.getDisplayName()), (Throwable)e);
                        throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
                    }
                    String token = StorageProperties.formatVolumeAttachmentTokenForTransfer((String)scGetTokenResponse.getToken(), (String)volume.getDisplayName());
                    ClusterAttachVolumeType attachVolume = new ClusterAttachVolumeType();
                    attachVolume.setInstanceId(request.getInstanceId());
                    attachVolume.setVolumeId(request.getVolumeId());
                    attachVolume.setDevice(request.getDevice());
                    attachVolume.setRemoteDevice(token);
                    vm.addTransientVolume(deviceName, token, volume);
                    VolumeAttachCallback cb = new VolumeAttachCallback(attachVolume);
                    AsyncRequests.newRequest((RemoteCallback)cb).dispatch(ccConfig);
                }
                EventRecord.here(VolumeManager.class, (EventClass)EventClass.VOLUME, (EventType)EventType.VOLUME_ATTACH, (String[])new String[0]).withDetails(volume.getOwner().toString(), volume.getDisplayName(), "instance", vm.getInstanceId()).withDetails("partition", vm.getPartition().toString()).info();
                reply.setAttachedVolume(new AttachedVolume(volume.getDisplayName(), vm.getInstanceId(), request.getDevice()));
                Volumes.fireUsageEvent(volume, (EventActionInfo<VolumeEvent.VolumeAction>)VolumeEvent.forVolumeAttach((String)vm.getInstanceUuid(), (String)volume.getDisplayName()));
                return reply;
            }
        }
    }

    public DetachVolumeResponseType detach(DetachVolumeType request) throws EucalyptusCloudException {
        ServiceConfiguration scVm;
        Volume vol;
        DetachVolumeResponseType reply = (DetachVolumeResponseType)request.getReply();
        String volumeId = VolumeManager.normalizeVolumeIdentifier(request.getVolumeId());
        String instanceId = VolumeManager.normalizeOptionalInstanceIdentifier(request.getInstanceId());
        Context ctx = Contexts.lookup();
        try {
            vol = Volumes.lookup((OwnerFullName)ctx.getUserFullName().asAccountFullName(), volumeId);
        }
        catch (NoSuchElementException ex) {
            try {
                vol = Volumes.lookup(null, volumeId);
            }
            catch (NoSuchElementException e) {
                throw new ClientComputeException("InvalidVolume.NotFound", "The volume '" + request.getVolumeId() + "' does not exist");
            }
        }
        if (!RestrictedTypes.filterPrivileged().apply((Object)vol)) {
            throw new EucalyptusCloudException("Not authorized to detach volume " + volumeId + " by " + ctx.getUser().getName());
        }
        VmInstance vm = null;
        String remoteDevice = null;
        AttachedVolume volume = null;
        VmVolumeAttachment vmVolAttach = null;
        try {
            vmVolAttach = VmInstances.lookupVolumeAttachment(volumeId);
            remoteDevice = vmVolAttach.getRemoteDevice();
            volume = (AttachedVolume)VmVolumeAttachment.asAttachedVolume(vmVolAttach.getVmInstance()).apply((Object)vmVolAttach);
            vm = vmVolAttach.getVmInstance();
        }
        catch (NoSuchElementException ex) {
            throw new ClientComputeException("IncorrectState", "Volume is not attached: " + volumeId);
        }
        if (vmVolAttach.getIsRootDevice().booleanValue() && !VmInstance.VmState.STOPPED.equals(vm.getState())) {
            throw new ClientComputeException("IncorrectState", "Cannot detach root volume " + volumeId + " from EBS backed instance " + vm.getInstanceId() + " when instance state is " + ((VmInstance.VmState)vm.getState()).toString().toLowerCase());
        }
        if (vm != null && MigrationState.isMigrating(vm)) {
            throw Exceptions.toUndeclared((String)("Cannot detach a volume from an instance which is currently migrating: " + vm.getInstanceId() + " " + vm.getMigrationTask()), (Throwable[])new Throwable[0]);
        }
        if (volume == null) {
            throw new ClientComputeException("IncorrectState", "Volume is not attached: " + volumeId);
        }
        if (!RestrictedTypes.filterPrivileged().apply((Object)vm)) {
            throw new EucalyptusCloudException("Not authorized to detach volume from instance " + instanceId + " by " + ctx.getUser().getName());
        }
        if (instanceId != null && vm != null && !vm.getInstanceId().equals(instanceId)) {
            throw new ClientComputeException("InvalidAttachment.NotFound", "Volume is not attached to instance: " + instanceId);
        }
        if (request.getDevice() != null && !request.getDevice().equals("") && !volume.getDevice().equals(request.getDevice())) {
            throw new EucalyptusCloudException("Volume is not attached to device: " + request.getDevice());
        }
        try {
            scVm = Topology.lookup(Storage.class, (Partition[])new Partition[]{vm.lookupPartition()});
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new EucalyptusCloudException("Failed to lookup SC for partition: " + vm.getPartition(), (Throwable)ex);
        }
        if (VmInstance.VmState.STOPPED.equals(vm.getState())) {
            try {
                DetachStorageVolumeType detach = new DetachStorageVolumeType(volume.getVolumeId());
                AsyncRequests.sendSync((ServiceConfiguration)scVm, (BaseMessage)detach);
            }
            catch (Exception e) {
                LOG.debug((Object)e);
                Logs.extreme().debug((Object)e, (Throwable)e);
            }
            vm.removeVolumeAttachment(volume.getVolumeId());
        } else {
            Cluster cluster = null;
            ServiceConfiguration ccConfig = null;
            try {
                ccConfig = Topology.lookup(ClusterController.class, (Partition[])new Partition[]{vm.lookupPartition()});
                cluster = Clusters.lookup(ccConfig);
            }
            catch (NoSuchElementException e) {
                LOG.debug((Object)e, (Throwable)e);
                throw new EucalyptusCloudException("Cluster does not exist in partition: " + vm.getPartition());
            }
            ClusterDetachVolumeType detachVolume = new ClusterDetachVolumeType();
            detachVolume.setVolumeId(volume.getVolumeId());
            detachVolume.setRemoteDevice(remoteDevice);
            detachVolume.setDevice(volume.getDevice().replaceAll("unknown,requested:", ""));
            detachVolume.setInstanceId(vm.getInstanceId());
            detachVolume.setForce(request.getForce());
            VolumeDetachCallback ncDetach = new VolumeDetachCallback(detachVolume);
            AsyncRequests.newRequest((RemoteCallback)ncDetach).dispatch((ServiceConfiguration)cluster.getConfiguration());
            vm.updateVolumeAttachment(volumeId, VmVolumeAttachment.AttachmentState.detaching);
            volume.setStatus("detaching");
        }
        reply.setDetachedVolume(volume);
        Volumes.fireUsageEvent(vol, (EventActionInfo<VolumeEvent.VolumeAction>)VolumeEvent.forVolumeDetach((String)vm.getInstanceUuid(), (String)vm.getInstanceId()));
        return reply;
    }

    public ModifyVolumeAttributeResponseType modifyVolumeAttribute(ModifyVolumeAttributeType request) {
        return (ModifyVolumeAttributeResponseType)request.getReply();
    }

    private boolean validateDeviceName(String DeviceName) {
        return Pattern.matches("^[a-zA-Z\\d/]{3,10}$", DeviceName);
    }

    private static String normalizeIdentifier(String identifier, String prefix, boolean required, String message) throws ClientComputeException {
        try {
            return Strings.emptyToNull((String)identifier) == null && !required ? null : ResourceIdentifiers.parse(prefix, identifier).getIdentifier();
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidParameterValue", String.format(message, e.getIdentifier()));
        }
    }

    @Nullable
    private static String normalizeOptionalSnapshotIdentifier(String identifier) throws EucalyptusCloudException {
        return VolumeManager.normalizeIdentifier(identifier, "snap", false, "Value (%s) for parameter snapshotId is invalid. Expected: 'snap-...'.");
    }

    @Nullable
    private static String normalizeOptionalInstanceIdentifier(String identifier) throws EucalyptusCloudException {
        return VolumeManager.normalizeIdentifier(identifier, "i", false, "Value (%s) for parameter instanceId is invalid. Expected: 'i-...'.");
    }

    private static String normalizeInstanceIdentifier(String identifier) throws EucalyptusCloudException {
        return VolumeManager.normalizeIdentifier(identifier, "i", true, "Value (%s) for parameter instanceId is invalid. Expected: 'i-...'.");
    }

    private static String normalizeVolumeIdentifier(String identifier) throws EucalyptusCloudException {
        return VolumeManager.normalizeIdentifier(identifier, Volumes.ID_PREFIX, true, "Value (%s) for parameter volume is invalid. Expected: 'vol-...'.");
    }

    private static List<String> normalizeVolumeIdentifiers(List<String> identifiers) throws EucalyptusCloudException {
        try {
            return ResourceIdentifiers.normalize(Volumes.ID_PREFIX, identifiers);
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + e.getIdentifier() + ") for parameter volumes is invalid. Expected: 'vol-...'.");
        }
    }
}

