/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.VolumeTag;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_volumes")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Volume
extends UserMetadata<State>
implements CloudMetadata.VolumeMetadata {
    @Column(name="metadata_volume_size")
    private Integer size;
    @Deprecated
    @Column(name="metadata_volume_sc_name")
    private String scName;
    @Column(name="metadata_volume_partition")
    private String partition;
    @Column(name="metadata_volume_parentsnapshot")
    private String parentSnapshot;
    @Lob
    @Column(name="metadata_volume_remotedevice")
    @Type(type="org.hibernate.type.StringClobType")
    private String remoteDevice;
    @Column(name="metadata_volume_localdevice")
    private String localDevice;
    @Transient
    private FullName fullName;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="volume")
    private Collection<VolumeTag> tags;

    protected Volume() {
    }

    private Volume(UserFullName userFullName, String displayName, Integer size, String scName, String partitionName, String parentSnapshot) {
        super((OwnerFullName)userFullName, displayName);
        this.size = size;
        this.scName = scName;
        this.partition = partitionName;
        this.parentSnapshot = parentSnapshot;
        super.setState((Enum)State.NIHIL);
        super.setCreationTimestamp(new Date());
    }

    private Volume(OwnerFullName userFullName, String displayName) {
        super(userFullName, displayName);
    }

    public static Volume create(ServiceConfiguration sc, UserFullName owner, String snapId, Integer newSize, String newId) {
        return new Volume(owner, newId, newSize, sc.getName(), sc.getPartition(), snapId);
    }

    public static Volume named(@Nullable OwnerFullName fullName, @Nullable String volumeId) {
        return new Volume(fullName, volumeId);
    }

    public static Volume naturalId(String naturalId) {
        Volume volume = new Volume();
        volume.setNaturalId(naturalId);
        return volume;
    }

    public String mapState() {
        switch ((State)this.getState()) {
            case GENERATING: {
                return "creating";
            }
            case EXTANT: {
                return "available";
            }
            case ANNIHILATING: {
                return "deleting";
            }
            case ANNIHILATED: {
                return "deleted";
            }
            case FAIL: {
                return "failed";
            }
            case BUSY: {
                return "in-use";
            }
            case ERROR: {
                return "error";
            }
        }
        return "unavailable";
    }

    public com.eucalyptus.compute.common.Volume morph(com.eucalyptus.compute.common.Volume vol) {
        vol.setAvailabilityZone(this.getPartition());
        vol.setCreateTime(this.getCreationTimestamp());
        vol.setVolumeId(this.getDisplayName());
        vol.setSnapshotId(this.getParentSnapshot());
        vol.setStatus(this.mapState());
        vol.setSize(this.getSize() == null || this.getSize() == -1 ? null : this.getSize().toString());
        return vol;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getScName() {
        return this.scName;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    protected void setScName(String scName) {
        this.scName = scName;
    }

    public String getParentSnapshot() {
        return this.parentSnapshot;
    }

    public void setParentSnapshot(String parentSnapshot) {
        this.parentSnapshot = parentSnapshot;
    }

    public String getRemoteDevice() {
        return this.remoteDevice;
    }

    public void setRemoteDevice(String remoteDevice) {
        this.remoteDevice = remoteDevice;
    }

    public String getLocalDevice() {
        return this.localDevice;
    }

    public void setLocalDevice(String localDevice) {
        this.localDevice = localDevice;
    }

    public boolean isReady() {
        return ((State)this.getState()).equals((Object)State.EXTANT) || ((State)this.getState()).equals((Object)State.BUSY);
    }

    public String getPartition() {
        return this.partition;
    }

    protected void setPartition(String partition) {
        this.partition = partition;
    }

    public String getType() {
        return "standard";
    }

    public Integer getIops() {
        return null;
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"volume", this.getDisplayName()});
    }
}

