/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.UserMetadata;
import com.google.common.base.Objects;
import java.util.EnumSet;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StorageUtil {
    private static Logger LOG = Logger.getLogger(StorageUtil.class);

    public static long getBlockStorageTotalSize(String partition) {
        return StorageUtil.getBlockStorageTotalVolumeSize(partition) + StorageUtil.getBlockStorageTotalSnapshotSize(partition);
    }

    public static long getBlockStorageTotalVolumeSize(String partition) {
        return StorageUtil.getBlockStorageTotalSize(partition, "partition", "size", Volume.class);
    }

    public static long getBlockStorageTotalSnapshotSize(String partition) {
        return StorageUtil.getBlockStorageTotalSize(partition, "volumePartition", "volumeSize", Snapshot.class);
    }

    private static long getBlockStorageTotalSize(String partition, String partitionProperty, String sizeProperty, Class<? extends UserMetadata<State>> sizedType) {
        long size = -1L;
        EntityTransaction db = Entities.get(sizedType);
        try {
            size = ((Number)Objects.firstNonNull((Object)((Number)Entities.createCriteria(sizedType).add(Restrictions.in((String)"state", EnumSet.of(State.EXTANT, State.BUSY))).add((Criterion)(partition == null ? Restrictions.isNotNull((String)partitionProperty) : Restrictions.eq((String)partitionProperty, (Object)partition))).setProjection((Projection)Projections.sum((String)sizeProperty)).setReadOnly(true).uniqueResult()), (Object)0)).longValue();
            db.commit();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            db.rollback();
        }
        return size;
    }
}

