/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.blockstorage.SnapshotManager;
import com.eucalyptus.blockstorage.SnapshotTag;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.blockstorage.msgs.CreateStorageSnapshotResponseType;
import com.eucalyptus.blockstorage.msgs.CreateStorageSnapshotType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageSnapshotsResponseType;
import com.eucalyptus.blockstorage.msgs.DescribeStorageSnapshotsType;
import com.eucalyptus.blockstorage.msgs.StorageSnapshot;
import com.eucalyptus.cloud.util.DuplicateMetadataException;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.reporting.event.SnapShotEvent;
import com.eucalyptus.system.Threads;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;

public class Snapshots {
    private static Logger LOG = Logger.getLogger(Snapshots.class);
    private static final long SNAPSHOT_STATE_TIMEOUT = 0x6DDD00L;
    private static final Set<State> SNAPSHOT_TIMEOUT_STATES = Collections.unmodifiableSet(EnumSet.of(State.NIHIL, State.GENERATING));
    public static final String SELF = "self";

    public static Predicate<Snapshot> filterRestorableBy(final Collection<String> restorableSet, final String callerAccountNumber) {
        final boolean restorableSelf = restorableSet.remove(SELF);
        final boolean restorableAll = restorableSet.remove("all");
        return new Predicate<Snapshot>(){

            public boolean apply(Snapshot snapshot) {
                return restorableSet.isEmpty() && !restorableSelf && !restorableAll || restorableAll && snapshot.getSnapshotPublic() != false || restorableSelf && snapshot.hasPermission(callerAccountNumber) || snapshot.hasPermission(restorableSet.toArray(new String[restorableSet.size()]));
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    static Snapshot initializeSnapshot(UserFullName userFullName, Volume vol, ServiceConfiguration sc, String description) throws EucalyptusCloudException {
        db = Entities.get(Snapshot.class);
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                newId = ResourceIdentifiers.generateString(SnapshotManager.ID_PREFIX);
                try {
                    Entities.uniqueResult((Object)Snapshot.named(null, newId));
                    continue;
                }
                catch (NoSuchElementException e) {
                    snap = new Snapshot((OwnerFullName)userFullName, newId, description, vol.getDisplayName(), vol.getSize(), sc.getName(), sc.getPartition());
                    Entities.persist((Object)snap);
                    db.commit();
                    return snap;
                }
                break;
            }
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to initialize snapshot state because of: " + ex.getMessage(), (Throwable)ex);
        }
        {
            ** while (true)
        }
    }

    static Snapshot startCreateSnapshot(final Volume vol, final Snapshot snap) throws EucalyptusCloudException, DuplicateMetadataException {
        final ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)vol.getPartition())});
        try {
            Snapshot snapshot = (Snapshot)((Object)Transactions.save((Object)((Object)snap), (Callback)new Callback<Snapshot>(){

                public void fire(Snapshot s) {
                    String scSnapStatus = null;
                    try {
                        CreateStorageSnapshotType scRequest = new CreateStorageSnapshotType(vol.getDisplayName(), snap.getDisplayName());
                        CreateStorageSnapshotResponseType scReply = (CreateStorageSnapshotResponseType)AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)scRequest);
                        s.setMappedState(scReply.getStatus());
                        scSnapStatus = scReply.getStatus();
                    }
                    catch (Exception ex) {
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
            }));
        }
        catch (ConstraintViolationException ex) {
            throw new DuplicateMetadataException("Duplicate snapshot creation: " + (Object)((Object)snap) + ": " + ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            LOG.error((Object)ex.getCause(), ex.getCause());
            throw new EucalyptusCloudException((Throwable)ex);
        }
        return snap;
    }

    public static Snapshot named(String snapshotId) {
        return new Snapshot(null, snapshotId);
    }

    public static Snapshot lookup(@Nullable OwnerFullName accountFullName, String snapshotId) throws ExecutionException {
        return (Snapshot)((Object)Transactions.find((Object)((Object)Snapshot.named(accountFullName, snapshotId))));
    }

    public static List<Snapshot> list() throws TransactionException {
        return Transactions.findAll((Object)((Object)Snapshot.named(null, null)));
    }

    private static Function<String, Collection> accountAliasExploder() {
        return new Function<String, Collection>(){

            public Collection<String> apply(String accountAliasExpression) {
                try {
                    return Accounts.resolveAccountNumbersForName((String)accountAliasExpression);
                }
                catch (AuthException e) {
                    LOG.error((Object)e, (Throwable)e);
                    return Collections.emptySet();
                }
            }
        };
    }

    private static enum FilterDateFunctions implements Function<Snapshot, Date>
    {
        START_TIME{

            public Date apply(Snapshot snapshot) {
                return snapshot.getCreationTimestamp();
            }
        };

    }

    private static enum FilterFunctions implements Function<Snapshot, String>
    {
        DESCRIPTION{

            public String apply(Snapshot snapshot) {
                return snapshot.getDescription();
            }
        }
        ,
        ACCOUNT_ID{

            public String apply(Snapshot snapshot) {
                return snapshot.getOwnerAccountNumber();
            }
        }
        ,
        PROGRESS{

            public String apply(Snapshot snapshot) {
                return snapshot.getProgress();
            }
        }
        ,
        STATUS{

            public String apply(Snapshot snapshot) {
                return snapshot.mapState();
            }
        }
        ,
        VOLUME_ID{

            public String apply(Snapshot snapshot) {
                return snapshot.getParentVolume();
            }
        }
        ,
        VOLUME_SIZE{

            public String apply(Snapshot snapshot) {
                Integer size = snapshot.getVolumeSize();
                return size == null ? null : String.valueOf(size);
            }
        };

    }

    public static enum FilterPermissions implements Predicate<Snapshot>
    {
        INSTANCE;


        public boolean apply(Snapshot input) {
            try {
                Context ctx = Contexts.lookup();
                if (ctx.isAdministrator()) {
                    return true;
                }
                UserFullName luser = ctx.getUserFullName();
                if (input.getSnapshotPublic().booleanValue()) {
                    return true;
                }
                if (input.getOwnerAccountNumber().equals(luser.getAccountNumber())) {
                    return true;
                }
                return input.hasPermission(luser.getAccountNumber());
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static class SnapshotFilterSupport
    extends FilterSupport<Snapshot> {
        public SnapshotFilterSupport() {
            super(SnapshotFilterSupport.builderFor(Snapshot.class).withTagFiltering(SnapshotTag.class, "snapshot").withStringProperty("description", FilterFunctions.DESCRIPTION).withLikeExplodedProperty("owner-alias", FilterFunctions.ACCOUNT_ID, (Function<String, Collection>)Snapshots.accountAliasExploder()).withStringProperty("owner-id", FilterFunctions.ACCOUNT_ID).withStringProperty("progress", FilterFunctions.PROGRESS).withStringProperty("snapshot-id", (Function<Snapshot, String>)CloudMetadatas.toDisplayName()).withStringProperty("status", FilterFunctions.STATUS).withDateProperty("start-time", FilterDateFunctions.START_TIME).withStringProperty("volume-id", FilterFunctions.VOLUME_ID).withStringProperty("volume-size", FilterFunctions.VOLUME_SIZE).withPersistenceFilter("description").withLikeExplodingPersistenceFilter("owner-alias", "ownerAccountNumber", (Function<String, Collection>)Snapshots.accountAliasExploder()).withPersistenceFilter("owner-id", "ownerAccountNumber").withPersistenceFilter("progress").withPersistenceFilter("snapshot-id", "displayName").withPersistenceFilter("start-time", "creationTimestamp", FilterSupport.PersistenceFilter.Type.Date).withPersistenceFilter("volume-id", "parentVolume").withPersistenceFilter("volume-size", "volumeSize", FilterSupport.PersistenceFilter.Type.Integer));
        }
    }

    @RestrictedTypes.QuantityMetricFunction(value=CloudMetadata.SnapshotMetadata.class)
    public static enum CountSnapshots implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long apply(OwnerFullName input) {
            EntityTransaction db = Entities.get(Snapshot.class);
            try {
                Long l = Entities.count((Object)((Object)Snapshot.named(input, null)));
                return l;
            }
            finally {
                db.rollback();
            }
        }
    }

    public static class SnapshotUpdateEvent
    implements EventListener<ClockTick>,
    Callable<Boolean> {
        private static final AtomicBoolean ready = new AtomicBoolean(true);

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new SnapshotUpdateEvent());
        }

        public void fireEvent(ClockTick event) {
            if (Topology.isEnabledLocally(Eucalyptus.class) && ready.compareAndSet(true, false)) {
                try {
                    Threads.enqueue(Eucalyptus.class, Snapshots.class, (Callable)this);
                }
                catch (Exception ex) {
                    ready.set(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                try {
                    ArrayListMultimap snapshots = ArrayListMultimap.create();
                    for (Snapshot s : Snapshots.list()) {
                        snapshots.put((Object)s.getPartition(), (Object)s.getDisplayName());
                    }
                    for (String partition : snapshots.keySet()) {
                        try {
                            ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)partition)});
                            DescribeStorageSnapshotsType scRequest = new DescribeStorageSnapshotsType();
                            DescribeStorageSnapshotsResponseType snapshotInfo = (DescribeStorageSnapshotsResponseType)AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)scRequest);
                            HashMap storageSnapshots = Maps.newHashMap();
                            for (StorageSnapshot storageSnapshot : snapshotInfo.getSnapshotSet()) {
                                storageSnapshots.put(storageSnapshot.getSnapshotId(), storageSnapshot);
                            }
                            for (String snapshotId : snapshots.get((Object)partition)) {
                                StorageSnapshot storageSnapshot = (StorageSnapshot)storageSnapshots.remove(snapshotId);
                                this.updateSnapshot(snapshotId, storageSnapshot);
                            }
                            for (StorageSnapshot unknownSnapshot : storageSnapshots.values()) {
                                LOG.trace((Object)("SnapshotStateUpdate: found unknown snapshot: " + unknownSnapshot.getSnapshotId() + " " + unknownSnapshot.getStatus()));
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex);
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
            finally {
                ready.set(true);
            }
            return true;
        }

        public void updateSnapshot(String snapshotId, final StorageSnapshot storageSnapshot) {
            try {
                Function<String, Snapshot> updateSnapshot = new Function<String, Snapshot>(){

                    public Snapshot apply(String input) {
                        try {
                            Snapshot entity = (Snapshot)((Object)Entities.uniqueResult((Object)((Object)Snapshot.named(null, input))));
                            StringBuilder buf = new StringBuilder();
                            buf.append("SnapshotStateUpdate: ").append(entity.getPartition()).append(" ").append(input).append(" ").append(entity.getParentVolume()).append(" ").append(entity.getState()).append(" ").append(entity.getProgress()).append(" ");
                            if (storageSnapshot != null) {
                                if (storageSnapshot.getStatus() != null) {
                                    boolean wasGenerating = ((State)entity.getState()).equals((Object)State.GENERATING);
                                    entity.setMappedState(storageSnapshot.getStatus());
                                    if (wasGenerating && ((State)entity.getState()).equals((Object)State.EXTANT)) {
                                        try {
                                            Volume volume = (Volume)((Object)Transactions.find((Object)((Object)Volume.named(null, storageSnapshot.getVolumeId()))));
                                            String volumeUuid = volume.getNaturalId();
                                            ListenerRegistry.getInstance().fireEvent((Event)SnapShotEvent.with((EventActionInfo)SnapShotEvent.forSnapShotCreate((Integer)entity.getVolumeSize(), (String)volumeUuid, (String)entity.getParentVolume()), (String)entity.getNaturalId(), (String)entity.getDisplayName(), (String)entity.getOwnerUserId()));
                                        }
                                        catch (Throwable e) {
                                            LOG.error((Object)("Error inserting/creating reporting event for snapshot creation of snapshot: " + entity.getDisplayName()), e);
                                        }
                                    }
                                }
                                if (!State.EXTANT.equals(entity.getState()) && storageSnapshot.getProgress() != null) {
                                    entity.setProgress(storageSnapshot.getProgress());
                                } else if (State.EXTANT.equals(entity.getState())) {
                                    entity.setProgress("100%");
                                } else if (State.GENERATING.equals(entity.getState()) && entity.getProgress() == null) {
                                    entity.setProgress("0%");
                                }
                                buf.append(" storage-snapshot ").append(storageSnapshot.getStatus()).append("=>").append(entity.getState()).append(" ").append(storageSnapshot.getProgress()).append(" ");
                            } else if (SNAPSHOT_TIMEOUT_STATES.contains(entity.getState()) && entity.lastUpdateMillis() > 0x6DDD00L) {
                                Entities.delete((Object)((Object)entity));
                            } else if (State.EXTANT.equals(entity.getState())) {
                                entity.setProgress("100%");
                            } else if (State.GENERATING.equals(entity.getState()) && entity.getProgress() == null) {
                                entity.setProgress("0%");
                            }
                            LOG.debug((Object)buf.toString());
                            return entity;
                        }
                        catch (TransactionException ex) {
                            throw Exceptions.toUndeclared((Throwable)ex);
                        }
                    }
                };
                try {
                    Entities.asTransaction(Snapshot.class, (Function)updateSnapshot).apply((Object)snapshotId);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
    }
}

