/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_snapshots")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="snapshot")
public class SnapshotTag
extends Tag<SnapshotTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Snapshot snapshot;

    protected SnapshotTag() {
        super("snapshot", ResourceIdFunction.INSTANCE);
    }

    public SnapshotTag(@Nonnull Snapshot snapshot, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("snapshot", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setSnapshot(snapshot);
        this.init();
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Nonnull
    public static Tag named(@Nonnull Snapshot snapshot, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return SnapshotTag.namedWithValue(snapshot, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull Snapshot snapshot, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)snapshot), (Object)"snapshot");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new SnapshotTag(snapshot, ownerFullName, key, value);
    }

    public static final class SnapshotTagSupport
    extends TagSupport {
        public SnapshotTagSupport() {
            super(Snapshot.class, "snap", "displayName", "snapshot", "InvalidSnapshot.NotFound", "The snapshot '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new SnapshotTag((Snapshot)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return SnapshotTag.namedWithValue((Snapshot)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new SnapshotTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)Snapshot.named(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<SnapshotTag, String>
    {
        INSTANCE{

            public String apply(SnapshotTag snapshotTag) {
                return snapshotTag.getSnapshot().getDisplayName();
            }
        };

    }
}

