/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.blockstorage.Snapshots;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.blockstorage.Volumes;
import com.eucalyptus.blockstorage.msgs.DeleteStorageSnapshotResponseType;
import com.eucalyptus.blockstorage.msgs.DeleteStorageSnapshotType;
import com.eucalyptus.cloud.util.DuplicateMetadataException;
import com.eucalyptus.component.NoSuchComponentException;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.CreateVolumePermissionItemType;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.backend.CreateSnapshotResponseType;
import com.eucalyptus.compute.common.backend.CreateSnapshotType;
import com.eucalyptus.compute.common.backend.DeleteSnapshotResponseType;
import com.eucalyptus.compute.common.backend.DeleteSnapshotType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotAttributeResponseType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotAttributeType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotsType;
import com.eucalyptus.compute.common.backend.ModifySnapshotAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifySnapshotAttributeType;
import com.eucalyptus.compute.common.backend.ResetSnapshotAttributeResponseType;
import com.eucalyptus.compute.common.backend.ResetSnapshotAttributeType;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.images.Images;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.reporting.event.SnapShotEvent;
import com.eucalyptus.system.Threads;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;

public class SnapshotManager {
    static Logger LOG = Logger.getLogger(SnapshotManager.class);
    static String ID_PREFIX = "snap";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateSnapshotResponseType create(final CreateSnapshotType request) throws EucalyptusCloudException, NoSuchComponentException, DuplicateMetadataException, AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException, TransactionException {
        Volume vol;
        final Context ctx = Contexts.lookup();
        String volumeId = SnapshotManager.normalizeVolumeIdentifier(request.getVolumeId());
        try {
            vol = (Volume)((Object)Transactions.find((Object)((Object)Volume.named((OwnerFullName)ctx.getUserFullName().asAccountFullName(), volumeId))));
        }
        catch (NoSuchElementException e) {
            throw new ClientComputeException("InvalidVolume.NotFound", "Volume not found '" + request.getVolumeId() + "'");
        }
        final ServiceConfiguration sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)vol.getPartition())});
        final Volume volReady = Volumes.checkVolumeReady(vol);
        Supplier<Snapshot> allocator = new Supplier<Snapshot>(){

            public Snapshot get() {
                try {
                    return Snapshots.initializeSnapshot(ctx.getUserFullName(), volReady, sc, request.getDescription());
                }
                catch (EucalyptusCloudException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        Snapshot snap = (Snapshot)RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
        try {
            snap = Snapshots.startCreateSnapshot(volReady, snap);
        }
        catch (EucalyptusCloudException e) {
            EntityTransaction db = Entities.get(Snapshot.class);
            try {
                Snapshot entity = (Snapshot)((Object)Entities.uniqueResult((Object)((Object)snap)));
                Entities.delete((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
            throw e;
        }
        try {
            SnapshotManager.fireUsageEvent(snap, (EventActionInfo<SnapShotEvent.SnapShotAction>)SnapShotEvent.forSnapShotCreate((Integer)snap.getVolumeSize(), (String)volReady.getNaturalId(), (String)snap.getDisplayName()));
        }
        catch (Throwable reportEx) {
            LOG.error((Object)"Unable to fire snap shot creation reporting event", reportEx);
        }
        CreateSnapshotResponseType reply = (CreateSnapshotResponseType)request.getReply();
        com.eucalyptus.compute.common.Snapshot snapMsg = snap.morph(new com.eucalyptus.compute.common.Snapshot());
        snapMsg.setProgress("0%");
        snapMsg.setOwnerId(snap.getOwnerAccountNumber());
        snapMsg.setVolumeSize(volReady.getSize().toString());
        reply.setSnapshot(snapMsg);
        return reply;
    }

    public DeleteSnapshotResponseType delete(final DeleteSnapshotType request) throws EucalyptusCloudException {
        DeleteSnapshotResponseType reply = (DeleteSnapshotResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final String snapshotId = SnapshotManager.normalizeSnapshotIdentifier(request.getSnapshotId());
        Predicate<Snapshot> deleteSnapshot = new Predicate<Snapshot>(){

            public boolean apply(Snapshot snap) {
                if (!State.EXTANT.equals(snap.getState()) && !State.FAIL.equals(snap.getState())) {
                    return false;
                }
                if (!RestrictedTypes.filterPrivileged().apply((Object)snap)) {
                    throw Exceptions.toUndeclared((Throwable)new EucalyptusCloudException("Not authorized to delete snapshot " + request.getSnapshotId() + " by " + ctx.getUser().getName()));
                }
                if (SnapshotManager.isReservedSnapshot(snapshotId)) {
                    throw Exceptions.toUndeclared((Throwable)new EucalyptusCloudException("Snapshot " + request.getSnapshotId() + " is in use, deletion not permitted"));
                }
                SnapshotManager.fireUsageEvent(snap, (EventActionInfo<SnapShotEvent.SnapShotAction>)SnapShotEvent.forSnapShotDelete());
                final String partition = snap.getPartition();
                final String snapshotId2 = snap.getDisplayName();
                Callable<Boolean> deleteBroadcast = new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        final DeleteStorageSnapshotType deleteMsg = new DeleteStorageSnapshotType(snapshotId2);
                        return Iterables.all((Iterable)Topology.enabledServices(Storage.class), (Predicate)new Predicate<ServiceConfiguration>(){

                            public boolean apply(ServiceConfiguration arg0) {
                                if (!arg0.getPartition().equals(partition)) {
                                    try {
                                        AsyncRequests.sendSync((ServiceConfiguration)arg0, (BaseMessage)deleteMsg);
                                    }
                                    catch (Exception ex) {
                                        LOG.error((Object)ex);
                                        Logs.extreme().error((Object)ex, (Throwable)ex);
                                    }
                                }
                                return true;
                            }
                        });
                    }
                };
                ServiceConfiguration sc = null;
                try {
                    sc = Topology.lookup(Storage.class, (Partition[])new Partition[]{Partitions.lookupByName((String)snap.getPartition())});
                }
                catch (Exception ex) {
                    sc = null;
                }
                if (sc != null) {
                    try {
                        DeleteStorageSnapshotResponseType scReply = (DeleteStorageSnapshotResponseType)AsyncRequests.sendSync((ServiceConfiguration)sc, (BaseMessage)new DeleteStorageSnapshotType(snap.getDisplayName()));
                        if (!scReply.get_return().booleanValue()) {
                            throw Exceptions.toUndeclared((Throwable)new EucalyptusCloudException("Unable to delete snapshot: " + (Object)((Object)snap)));
                        }
                        Threads.enqueue(Eucalyptus.class, Snapshots.class, (Callable)deleteBroadcast);
                    }
                    catch (Exception ex1) {
                        throw Exceptions.toUndeclared((String)ex1.getMessage(), (Throwable[])new Exception[]{ex1});
                    }
                } else {
                    Threads.enqueue(Eucalyptus.class, Snapshots.class, (Callable)deleteBroadcast);
                }
                return true;
            }
        };
        boolean result = false;
        try {
            result = Transactions.delete((Object)((Object)Snapshot.named((OwnerFullName)ctx.getUserFullName().asAccountFullName(), snapshotId)), (Predicate)deleteSnapshot);
        }
        catch (NoSuchElementException ex2) {
            try {
                result = Transactions.delete((Object)((Object)Snapshot.named(null, snapshotId)), (Predicate)deleteSnapshot);
            }
            catch (ExecutionException ex3) {
                throw new EucalyptusCloudException(ex3.getCause());
            }
            catch (NoSuchElementException ex4) {
                throw new ClientComputeException("InvalidSnapshot.NotFound", "The snapshot '" + request.getSnapshotId() + "' does not exist.");
            }
        }
        catch (ExecutionException ex1) {
            throw new EucalyptusCloudException(ex1.getCause());
        }
        reply.set_return(Boolean.valueOf(result));
        return reply;
    }

    public DescribeSnapshotsResponseType describe(DescribeSnapshotsType request) throws EucalyptusCloudException {
        DescribeSnapshotsResponseType reply = (DescribeSnapshotsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        String requestAccountId = ctx.getUserFullName().getAccountNumber();
        HashSet snapshotIds = Sets.newHashSet(SnapshotManager.normalizeSnapshotIdentifiers(request.getSnapshotSet()));
        ArrayList ownersSet = request.getOwnersSet();
        if (ownersSet.remove("self")) {
            ownersSet.add(requestAccountId);
        }
        Filter filter = Filters.generate(request.getFilterSet(), Snapshot.class);
        try (TransactionResource tx = Entities.transactionFor(Snapshot.class);){
            List unfilteredSnapshots = Entities.query((Object)((Object)Snapshot.named(null, null)), (boolean)true, (Criterion)filter.asCriterion(), filter.getAliases());
            Predicate requestedAndAccessible = CloudMetadatas.filteringFor(Snapshot.class).byId((Collection)snapshotIds).byOwningAccount((Collection)request.getOwnersSet()).byPredicate(Snapshots.filterRestorableBy(request.getRestorableBySet(), requestAccountId)).byPredicate(filter.asPredicate()).byPredicate((Predicate)Snapshots.FilterPermissions.INSTANCE).byPrivilegesWithoutOwner().buildPredicate();
            Iterable snapshots = Iterables.filter((Iterable)unfilteredSnapshots, (Predicate)requestedAndAccessible);
            Map<String, List<Tag>> tagsMap = TagSupport.forResourceClass(Snapshot.class).getResourceTagMap((OwnerFullName)AccountFullName.getInstance((Account)ctx.getAccount(), (String[])new String[0]), Iterables.transform((Iterable)snapshots, (Function)CloudMetadatas.toDisplayName()));
            for (Snapshot snap : snapshots) {
                try {
                    com.eucalyptus.compute.common.Snapshot snapReply = snap.morph(new com.eucalyptus.compute.common.Snapshot());
                    Tags.addFromTags(snapReply.getTagSet(), ResourceTag.class, (Iterable<Tag>)tagsMap.get(snapReply.getSnapshotId()));
                    snapReply.setVolumeId(snap.getParentVolume());
                    snapReply.setOwnerId(snap.getOwnerAccountNumber());
                    reply.getSnapshotSet().add(snapReply);
                }
                catch (NoSuchElementException e) {
                    LOG.warn((Object)("Error getting snapshot information from the Storage Controller: " + e));
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
        }
        return reply;
    }

    public ResetSnapshotAttributeResponseType resetSnapshotAttribute(final ResetSnapshotAttributeType request) throws EucalyptusCloudException {
        ResetSnapshotAttributeResponseType reply = (ResetSnapshotAttributeResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        String snapshotId = SnapshotManager.normalizeSnapshotIdentifier(request.getSnapshotId());
        Function<String, Boolean> resetSnapshotAttribute = new Function<String, Boolean>(){

            public Boolean apply(String snapshotId) {
                try {
                    Snapshot snap = (Snapshot)((Object)Entities.uniqueResult((Object)((Object)Snapshot.named(ctx.isAdministrator() ? null : ctx.getUserFullName().asAccountFullName(), snapshotId))));
                    if (!State.EXTANT.equals(snap.getState()) && !State.GENERATING.equals(snap.getState())) {
                        return false;
                    }
                    if (!SnapshotManager.canModifySnapshot(snap)) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("AuthFailure", "Not authorized to reset attribute for snapshot " + request.getSnapshotId())));
                    }
                    if (request.getCreateVolumePermission() != null && ("".equals(request.getCreateVolumePermission()) || "createVolumePermission".equals(request.getCreateVolumePermission()))) {
                        snap.setSnapshotPublic(false);
                        snap.setPermissions(Sets.newHashSet());
                    }
                    return true;
                }
                catch (TransactionException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
        try {
            reply.set_return((Boolean)Entities.asDistinctTransaction(Snapshot.class, (Function)resetSnapshotAttribute).apply((Object)snapshotId));
        }
        catch (NoSuchElementException e) {
            throw new ClientComputeException("InvalidSnapshot.NotFound", "The snapshot '" + request.getSnapshotId() + "' does not exist.");
        }
        catch (Exception e) {
            Exceptions.findAndRethrow((Throwable)e, EucalyptusCloudException.class, EucalyptusWebServiceException.class);
            throw new EucalyptusCloudException((Throwable)Objects.firstNonNull((Object)e.getCause(), (Object)e));
        }
        return reply;
    }

    private boolean validateGroup(String groupName) {
        return "all".equals(groupName);
    }

    private static List<String> verifyAccountIds(List<String> accountIds) throws EucalyptusCloudException {
        HashSet validUserIds = Sets.newHashSet();
        for (String userId : accountIds) {
            try {
                validUserIds.add(Accounts.lookupAccountById((String)userId).getAccountNumber());
            }
            catch (Exception e) {
                throw new EucalyptusCloudException("Not a valid userId : " + userId);
            }
        }
        return Lists.newArrayList((Iterable)validUserIds);
    }

    private static boolean canModifySnapshot(Snapshot snap) {
        Context ctx = Contexts.lookup();
        String requestAccountId = ctx.getUserFullName().getAccountNumber();
        return (ctx.isAdministrator() || snap.getOwnerAccountNumber().equals(requestAccountId)) && RestrictedTypes.filterPrivileged().apply((Object)snap);
    }

    public ModifySnapshotAttributeResponseType modifySnapshotAttribute(final ModifySnapshotAttributeType request) throws EucalyptusCloudException {
        ModifySnapshotAttributeResponseType reply = (ModifySnapshotAttributeResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        String snapshotId = SnapshotManager.normalizeSnapshotIdentifier(request.getSnapshotId());
        Function modifySnapshotAttribute = Functions.forPredicate((Predicate)new Predicate<Snapshot>(){

            public boolean apply(Snapshot snap) {
                if (!State.EXTANT.equals(snap.getState()) && !State.GENERATING.equals(snap.getState())) {
                    return false;
                }
                if (!SnapshotManager.canModifySnapshot(snap)) {
                    throw Exceptions.toUndeclared((Throwable)new EucalyptusCloudException("Not authorized to modify attribute for snapshot " + request.getSnapshotId() + " by " + ctx.getUser().getName()));
                }
                switch (request.snapshotAttribute()) {
                    case CreateVolumePermission: {
                        try {
                            snap.addPermissions(SnapshotManager.verifyAccountIds(request.addUserIds()));
                        }
                        catch (EucalyptusCloudException e) {
                            LOG.warn((Object)"Failed validating accountIds", (Throwable)e);
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                        if (request.addGroupAll()) {
                            snap.setSnapshotPublic(true);
                        }
                        snap.removePermissions(request.removeUserIds());
                        if (!request.removeGroupAll()) break;
                        snap.setSnapshotPublic(false);
                        break;
                    }
                    case ProductCode: {
                        for (String productCode : request.getProductCodes()) {
                            snap.addProductCode(productCode);
                        }
                        break;
                    }
                }
                return true;
            }
        });
        boolean result = false;
        try {
            result = (Boolean)Transactions.one((Object)((Object)Snapshot.named((OwnerFullName)ctx.getUserFullName().asAccountFullName(), snapshotId)), (Function)modifySnapshotAttribute);
        }
        catch (NoSuchElementException ex2) {
            throw new ClientComputeException("InvalidSnapshot.NotFound", "The snapshot '" + request.getSnapshotId() + "' does not exist.");
        }
        catch (ExecutionException ex1) {
            throw new EucalyptusCloudException(ex1.getCause());
        }
        reply.set_return(Boolean.valueOf(result));
        return reply;
    }

    public DescribeSnapshotAttributeResponseType describeSnapshotAttribute(DescribeSnapshotAttributeType request) throws EucalyptusCloudException {
        DescribeSnapshotAttributeResponseType reply = (DescribeSnapshotAttributeResponseType)request.getReply();
        reply.setSnapshotId(request.getSnapshotId());
        Context ctx = Contexts.lookup();
        String snapshotId = SnapshotManager.normalizeSnapshotIdentifier(request.getSnapshotId());
        try (TransactionResource db = Entities.transactionFor(Snapshot.class);){
            Snapshot result = (Snapshot)((Object)Entities.uniqueResult((Object)((Object)Snapshot.named((OwnerFullName)ctx.getUserFullName().asAccountFullName(), snapshotId))));
            if (!RestrictedTypes.filterPrivileged().apply((Object)result)) {
                throw new EucalyptusCloudException("Not authorized to describe attributes for snapshot " + request.getSnapshotId());
            }
            ArrayList permissions = Lists.newArrayList();
            for (String id : result.getPermissions()) {
                permissions.add(new CreateVolumePermissionItemType(id, null));
            }
            if (result.getSnapshotPublic().booleanValue()) {
                permissions.add(new CreateVolumePermissionItemType(null, "all"));
            }
            if (result.getProductCodes() != null) {
                reply.setProductCodes(new ArrayList<String>(result.getProductCodes()));
            }
            reply.setCreateVolumePermission(permissions);
        }
        catch (NoSuchElementException ex2) {
            throw new ClientComputeException("InvalidSnapshot.NotFound", "The snapshot '" + request.getSnapshotId() + "' does not exist.");
        }
        catch (ExecutionException ex1) {
            throw new EucalyptusCloudException(ex1.getCause());
        }
        return reply;
    }

    private static boolean isReservedSnapshot(String snapshotId) {
        return Predicates.or((Predicate[])new Predicate[]{SnapshotInUseVerifier.INSTANCE}).apply((Object)snapshotId);
    }

    private static String normalizeIdentifier(String identifier, String prefix, boolean required, String message) throws ClientComputeException {
        try {
            return Strings.emptyToNull((String)identifier) == null && !required ? null : ResourceIdentifiers.parse(prefix, identifier).getIdentifier();
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidParameterValue", String.format(message, e.getIdentifier()));
        }
    }

    private static String normalizeSnapshotIdentifier(String identifier) throws EucalyptusCloudException {
        return SnapshotManager.normalizeIdentifier(identifier, ID_PREFIX, true, "Value (%s) for parameter snapshotId is invalid. Expected: 'snap-...'.");
    }

    private static String normalizeVolumeIdentifier(String identifier) throws EucalyptusCloudException {
        return SnapshotManager.normalizeIdentifier(identifier, Volumes.ID_PREFIX, true, "Value (%s) for parameter volume is invalid. Expected: 'vol-...'.");
    }

    private static List<String> normalizeSnapshotIdentifiers(List<String> identifiers) throws EucalyptusCloudException {
        try {
            return ResourceIdentifiers.normalize(ID_PREFIX, identifiers);
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + e.getIdentifier() + ") for parameter snapshots is invalid. Expected: 'snap-...'.");
        }
    }

    private static void fireUsageEvent(Snapshot snap, EventActionInfo<SnapShotEvent.SnapShotAction> actionInfo) {
        try {
            ListenerRegistry.getInstance().fireEvent((Event)SnapShotEvent.with(actionInfo, (String)snap.getNaturalId(), (String)snap.getDisplayName(), (String)snap.getOwner().getUserId()));
        }
        catch (Throwable e) {
            LOG.error((Object)e, e);
        }
    }

    private static enum SnapshotInUseVerifier implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String identifier) {
            return Iterables.any((Iterable)Entities.query((Object)((Object)Images.exampleBSDMappingWithSnapshotId(identifier)), (boolean)true), Images.imageInState(EnumSet.of(ImageMetadata.State.pending, ImageMetadata.State.available)));
        }
    }

    private static enum ImageSnapshotReservation implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String identifier) {
            return Iterables.any((Iterable)Entities.query((Object)Images.exampleBlockStorageWithSnapshotId(identifier), (boolean)true), Images.inState(EnumSet.of(ImageMetadata.State.pending, ImageMetadata.State.available)));
        }
    }
}

