/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.blockstorage.SnapshotTag;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.records.Logs;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_snapshots")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Snapshot
extends UserMetadata<State>
implements CloudMetadata.SnapshotMetadata {
    @Transient
    private static Logger LOG = Logger.getLogger(Snapshot.class);
    @Column(name="metadata_snapshot_vol_size")
    private Integer volumeSize;
    @Column(name="metadata_snapshot_parentvolume", updatable=false)
    private String parentVolume;
    @Deprecated
    @Column(name="metadata_snapshot_vol_sc", updatable=false)
    private String volumeSc;
    @Column(name="metadata_snapshot_vol_partition", updatable=false)
    private String volumePartition;
    @Column(name="metadata_snapshot_progress")
    private String progress;
    @Column(name="metadata_snapshot_description", updatable=false)
    private String description;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="snapshot")
    private Collection<SnapshotTag> tags;
    @ElementCollection
    @CollectionTable(name="metadata_snapshot_permissions")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<String> permissions = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="metadata_snapshot_pcodes")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<String> productCodes = new HashSet<String>();
    @Column(name="metadata_snapshot_is_public", columnDefinition="boolean default false")
    private Boolean snapshotPublic;

    protected Snapshot() {
    }

    Snapshot(OwnerFullName ownerFullName, String displayName) {
        super(ownerFullName, displayName);
    }

    Snapshot(OwnerFullName ownerFullName, String displayName, String description, String parentVolume, Integer volumeSize, String volumeScName, String volumePartition) {
        this(ownerFullName, displayName);
        this.description = description;
        this.parentVolume = parentVolume;
        this.volumeSc = volumeScName;
        this.volumePartition = volumePartition;
        this.volumeSize = volumeSize;
        this.progress = "0%";
        this.snapshotPublic = false;
        super.setState((Enum)State.NIHIL);
    }

    public static Snapshot named(@Nullable OwnerFullName ownerFullName, @Nullable String snapshotId) {
        return new Snapshot(ownerFullName, snapshotId);
    }

    public static Snapshot naturalId(String naturalId) {
        Snapshot snapshot = new Snapshot();
        snapshot.setNaturalId(naturalId);
        return snapshot;
    }

    public String mapState() {
        switch ((State)this.getState()) {
            case GENERATING: 
            case NIHIL: {
                return "pending";
            }
            case EXTANT: {
                return "completed";
            }
        }
        return "failed";
    }

    public void setMappedState(String state) {
        if (StorageProperties.Status.creating.toString().equals(state)) {
            this.setState(State.GENERATING);
        } else if (StorageProperties.Status.pending.toString().equals(state)) {
            this.setState(State.GENERATING);
        } else if (StorageProperties.Status.completed.toString().equals(state)) {
            this.setState(State.EXTANT);
        } else if (StorageProperties.Status.available.toString().equals(state)) {
            this.setState(State.EXTANT);
        } else if (StorageProperties.Status.failed.toString().equals(state)) {
            this.setState(State.FAIL);
        }
    }

    public com.eucalyptus.compute.common.Snapshot morph(com.eucalyptus.compute.common.Snapshot snap) {
        snap.setSnapshotId(this.getDisplayName());
        snap.setDescription(this.getDescription());
        snap.setStatus(this.mapState());
        snap.setStartTime(this.getCreationTimestamp());
        snap.setVolumeId(this.getParentVolume());
        snap.setVolumeSize(Integer.toString(this.getVolumeSize()));
        if (this.getProgress() != null) {
            snap.setProgress(this.getProgress());
        } else {
            snap.setProgress(State.EXTANT.equals(this.getState()) ? "100%" : "0%");
        }
        return snap;
    }

    public Boolean getSnapshotPublic() {
        return this.snapshotPublic;
    }

    public void setSnapshotPublic(Boolean aPublic) {
        this.snapshotPublic = aPublic;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParentVolume() {
        return this.parentVolume;
    }

    protected void setParentVolume(String parentVolume) {
        this.parentVolume = parentVolume;
    }

    public String getPartition() {
        return this.volumePartition;
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"snapshot", this.getDisplayName()});
    }

    public Integer getVolumeSize() {
        return this.volumeSize;
    }

    public void setVolumeSize(Integer integer) {
        this.volumeSize = integer;
    }

    public void setPartition(String partition) {
        this.volumePartition = partition;
    }

    public String getVolumeCluster() {
        return this.volumeSc;
    }

    public void setVolumeCluster(String volumeCluster) {
        this.volumeSc = volumeCluster;
    }

    public String getVolumePartition() {
        return this.volumePartition;
    }

    public void setVolumePartition(String volumePartition) {
        this.volumePartition = volumePartition;
    }

    public String getVolumeSc() {
        return this.volumeSc;
    }

    protected String getProgress() {
        return this.progress;
    }

    protected void setProgress(String progress) {
        this.progress = progress;
    }

    static Snapshot self(Snapshot snap) {
        return new Snapshot(snap.getOwner(), snap.getDisplayName());
    }

    public boolean addProductCode(String prodCode) {
        EntityTransaction db = Entities.get(Snapshot.class);
        try {
            Snapshot entity = (Snapshot)((Object)Entities.merge((Object)((Object)this)));
            entity.getProductCodes().add(prodCode);
            db.commit();
            return true;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
            return false;
        }
    }

    public Snapshot revokePermission(Account account) {
        EntityTransaction db = Entities.get(Snapshot.class);
        try {
            Snapshot entity = (Snapshot)((Object)Entities.merge((Object)((Object)this)));
            entity.getPermissions().remove(account.getAccountNumber());
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
        }
        return this;
    }

    public Snapshot grantPermission(Account account) {
        EntityTransaction db = Entities.get(Snapshot.class);
        try {
            Snapshot entity = (Snapshot)((Object)Entities.merge((Object)((Object)this)));
            entity.getPermissions().add(account.getAccountNumber());
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
        }
        return this;
    }

    public Snapshot resetPermission() {
        try {
            Transactions.one((Object)((Object)new Snapshot(this.getOwner(), this.displayName)), (Callback)new Callback<Snapshot>(){

                public void fire(Snapshot t) {
                    t.getPermissions().clear();
                    t.getPermissions().add(t.getOwnerAccountNumber());
                }
            });
        }
        catch (ExecutionException e) {
            LOG.debug((Object)e, (Throwable)e);
        }
        return this;
    }

    public Snapshot resetProductCodes() {
        try {
            Transactions.one((Object)((Object)Snapshot.self(this)), (Callback)new Callback<Snapshot>(){

                public void fire(Snapshot t) {
                    t.getProductCodes().clear();
                }
            });
        }
        catch (ExecutionException e) {
            LOG.debug((Object)e, (Throwable)e);
        }
        return this;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public boolean hasPermission(String ... accountIds) {
        try (TransactionResource db = Entities.transactionFor(Snapshot.class);){
            Snapshot entity = (Snapshot)((Object)Entities.merge((Object)((Object)this)));
            boolean bl = !Sets.intersection(entity.getPermissions(), (Set)Sets.newHashSet((Object[])accountIds)).isEmpty();
            return bl;
        }
    }

    public void addPermissions(List<String> accountIds) {
        try (TransactionResource db = Entities.transactionFor(Snapshot.class);){
            Snapshot entity = (Snapshot)((Object)Entities.merge((Object)((Object)this)));
            Iterables.all(accountIds, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    try {
                        Account account = Accounts.lookupAccountById((String)input);
                        Snapshot.this.getPermissions().add(input);
                    }
                    catch (Exception e) {
                        try {
                            User user = Accounts.lookupUserById((String)input);
                            Snapshot.this.getPermissions().add(user.getAccount().getAccountNumber());
                        }
                        catch (AuthException ex) {
                            try {
                                User user = Accounts.lookupUserByAccessKeyId((String)input);
                                Snapshot.this.getPermissions().add(user.getAccount().getAccountNumber());
                            }
                            catch (AuthException ex1) {
                                LOG.error((Object)ex1, (Throwable)ex1);
                            }
                        }
                    }
                    return true;
                }
            });
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
        }
    }

    public void removePermissions(List<String> accountIds) {
        try (TransactionResource db = Entities.transactionFor(Snapshot.class);){
            Snapshot entity = (Snapshot)((Object)Entities.merge((Object)((Object)this)));
            Iterables.all(accountIds, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    Snapshot.this.getPermissions().remove(input);
                    return true;
                }
            });
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
        }
    }

    @Upgrades.EntityUpgrade(entities={Snapshot.class}, since=Upgrades.Version.v3_2_0, value=Storage.class)
    public static enum SnapshotUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(Snapshot.class);
            try {
                List entities = Entities.query((Object)((Object)new Snapshot()));
                for (Snapshot entry : entities) {
                    LOG.debug((Object)("Upgrading: " + entry.getDisplayName()));
                    entry.setDescription(null);
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(SnapshotUpgrade.class);
        }
    }
}

