/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage;

import com.eucalyptus.blockstorage.StorageUtil;
import com.eucalyptus.blockstorage.entities.StorageInfo;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.reporting.event.ResourceAvailabilityEvent;
import com.eucalyptus.util.HasFullName;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BlockStorageAvailabilityEventListener
implements EventListener<ClockTick> {
    private static Logger logger = Logger.getLogger(BlockStorageAvailabilityEventListener.class);

    public static void register() {
        Listeners.register(ClockTick.class, (EventListener)new BlockStorageAvailabilityEventListener());
    }

    public void fireEvent(ClockTick event) {
        if (BootstrapArgs.isCloudController().booleanValue() && Bootstrap.isOperational().booleanValue()) {
            ArrayList resourceAvailability = Lists.newArrayList();
            HashSet partitions = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Clusters.getInstance().listValues(), (Function)HasFullName.GET_PARTITION));
            for (String partition : partitions) {
                long total = 0L;
                try {
                    total = ((StorageInfo)Transactions.find((Object)new StorageInfo(partition))).getMaxTotalVolumeSizeInGb().intValue();
                }
                catch (TransactionException e) {
                    logger.debug((Object)("Error finding capacity for " + partition), (Throwable)e);
                }
                resourceAvailability.add(new ResourceAvailabilityEvent.Availability(total, Math.max(total - StorageUtil.getBlockStorageTotalSize(partition), 0L), (Iterable)Lists.newArrayList((Object[])new ResourceAvailabilityEvent.Tag[]{new ResourceAvailabilityEvent.Dimension("availabilityZone", partition)})));
            }
            try {
                ListenerRegistry.getInstance().fireEvent((Event)new ResourceAvailabilityEvent(ResourceAvailabilityEvent.ResourceType.StorageEBS, (Collection)resourceAvailability));
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }
    }
}

