/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.address;

import com.eucalyptus.address.AbstractSystemAddressManager;
import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.address.NotEnoughAddressResourcesException;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StaticSystemAddressManager
extends AbstractSystemAddressManager {
    private static Logger LOG = Logger.getLogger(StaticSystemAddressManager.class);

    public StaticSystemAddressManager() {
        this.inheritReservedAddresses(new ArrayList<Address>());
    }

    @Override
    protected List<Address> doAllocateSystemAddresses(int count) throws NotEnoughResourcesException {
        ArrayList addressList = Lists.newArrayList();
        for (Address addr : Addresses.getInstance().listValues()) {
            if (!addr.isSystemOwned() || addr.isAssigned()) continue;
            addr.pendingAssignment();
            addressList.add(addr);
            if (addressList.size() != count) continue;
            break;
        }
        if (addressList.size() < count) {
            for (Address putBackAddr : addressList) {
                putBackAddr.clearPending();
            }
            throw new NotEnoughAddressResourcesException();
        }
        return addressList;
    }

    @Override
    public void assignSystemAddress(VmInstance vm) throws NotEnoughResourcesException {
        super.doAssignSystemAddress(vm);
    }

    @Override
    public List<Address> getReservedAddresses() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Addresses.getInstance().listValues(), (Predicate)new Predicate<Address>(){

            public boolean apply(Address arg0) {
                return arg0.isSystemOwned();
            }
        }));
    }

    @Override
    public void inheritReservedAddresses(List<Address> reservedAddresses) {
        int allocCount = Addresses.getSystemReservedAddressCount() - reservedAddresses.size();
        LOG.debug((Object)("Allocating additional " + allocCount + " addresses in static public addresing mode"));
        int n = allocCount = Addresses.getInstance().listDisabledValues().size() < allocCount ? Addresses.getInstance().listDisabledValues().size() : allocCount;
        if (allocCount > 0) {
            for (int i = 0; i < allocCount; ++i) {
                try {
                    this.allocateNext(Principals.systemFullName(), Address.Domain.standard);
                    continue;
                }
                catch (NotEnoughResourcesException e) {
                    break;
                }
            }
        } else {
            for (Address addr : Addresses.getInstance().listValues()) {
                if (!addr.getOwner().equals(Principals.systemFullName()) || addr.isAssigned() || addr.isPending()) continue;
                addr.release();
                if (allocCount++ < 0) continue;
                break;
            }
        }
    }
}

