/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.address;

import com.eucalyptus.address.AbstractSystemAddressManager;
import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.address.NotEnoughAddressResourcesException;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.vm.VmInstance;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DynamicSystemAddressManager
extends AbstractSystemAddressManager {
    private static Logger LOG = Logger.getLogger(DynamicSystemAddressManager.class);

    @Override
    protected List<Address> doAllocateSystemAddresses(int count) throws NotEnoughResourcesException {
        if (Addresses.getInstance().listDisabledValues().size() < count) {
            throw new NotEnoughAddressResourcesException();
        }
        ArrayList addressList = Lists.newArrayList();
        for (Address addr : Addresses.getInstance().listDisabledValues()) {
            try {
                if (!addressList.add(addr.pendingAssignment()) || --count != 0) continue;
                break;
            }
            catch (IllegalStateException e) {
                LOG.trace((Object)e, (Throwable)e);
            }
        }
        if (count != 0) {
            for (Address addr : addressList) {
                try {
                    addr.release();
                }
                catch (IllegalStateException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
            throw new NotEnoughAddressResourcesException();
        }
        return addressList;
    }

    @Override
    public void assignSystemAddress(VmInstance vm) throws NotEnoughResourcesException {
        super.doAssignSystemAddress(vm);
    }

    @Override
    public List<Address> getReservedAddresses() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Addresses.getInstance().listValues(), (Predicate)new Predicate<Address>(){

            public boolean apply(Address arg0) {
                return arg0.isSystemOwned();
            }
        }));
    }

    @Override
    public void inheritReservedAddresses(List<Address> previouslyReservedAddresses) {
        for (Address addr : previouslyReservedAddresses) {
            if (addr.isAssigned() || addr.isPending() || !addr.isSystemOwned() || !Address.UNASSIGNED_INSTANCEID.equals(addr.getInstanceId())) continue;
            Addresses.release(addr);
        }
    }
}

