/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.address;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyChangeListeners;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.records.Logs;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="cloud_address_configuration")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="cloud.addresses", description="Configuration options controlling the handling of public/elastic addresses.")
public class AddressingConfiguration
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    @Transient
    private static Logger LOG = Logger.getLogger(AddressingConfiguration.class);
    @ConfigurableField(displayName="dynamic_public_addressing", description="Public addresses are assigned to instances by the system as available.", changeListener=DynamicAddressingListener.class)
    @Column(name="config_addr_do_dynamic_public_addresses", nullable=false, columnDefinition="boolean default true")
    private Boolean doDynamicPublicAddresses;
    @ConfigurableField(displayName="static_address_pool", changeListener=PropertyChangeListeners.IsPositiveInteger.class, description="Public addresses are assigned to instances by the system only from a pool of reserved instances whose size is determined by this value.")
    @Column(name="config_addr_reserved_public_addresses")
    private Integer systemReservedPublicAddresses;
    @ConfigurableField(displayName="address_orphan_count", changeListener=PropertyChangeListeners.IsPositiveInteger.class, description="Number of times an orphaned address is reported by a cluster before it is reclaimed by the system.")
    @Column(name="config_addr_orphan_ticks", nullable=false)
    private Integer maxKillOrphans;
    @ConfigurableField(displayName="address_orphan_grace", changeListener=PropertyChangeListeners.IsPositiveInteger.class, description="Time after the last recorded state change where an orphaned address will not be modified by the system (minutes).")
    @Column(name="config_addr_orphan_grace", nullable=false)
    private Integer orphanGrace;

    public static AddressingConfiguration getInstance() {
        AddressingConfiguration ret = null;
        try {
            ret = (AddressingConfiguration)((Object)Transactions.find((Object)((Object)new AddressingConfiguration())));
        }
        catch (Exception ex1) {
            try {
                ret = (AddressingConfiguration)((Object)Transactions.save((Object)((Object)new AddressingConfiguration())));
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                ret = new AddressingConfiguration();
            }
        }
        return ret;
    }

    @PrePersist
    protected void initialize() {
        if (this.doDynamicPublicAddresses == null) {
            this.doDynamicPublicAddresses = Boolean.TRUE;
        }
        if (this.systemReservedPublicAddresses == null) {
            this.systemReservedPublicAddresses = 0;
        }
        if (this.maxKillOrphans == null) {
            this.maxKillOrphans = 360;
        }
        if (this.orphanGrace == null) {
            this.orphanGrace = 360;
        }
    }

    public Boolean getDoDynamicPublicAddresses() {
        return this.doDynamicPublicAddresses;
    }

    public void setDoDynamicPublicAddresses(Boolean doDynamicPublicAddresses) {
        this.doDynamicPublicAddresses = doDynamicPublicAddresses;
    }

    public Integer getSystemReservedPublicAddresses() {
        return this.systemReservedPublicAddresses;
    }

    public void setSystemReservedPublicAddresses(Integer systemReservedPublicAddresses) {
        this.systemReservedPublicAddresses = systemReservedPublicAddresses;
    }

    public Integer getMaxKillOrphans() {
        return this.maxKillOrphans;
    }

    public void setMaxKillOrphans(Integer maxKillOrphans) {
        this.maxKillOrphans = maxKillOrphans;
    }

    public Integer getOrphanGrace() {
        return this.orphanGrace;
    }

    public void setOrphanGrace(Integer orphanGrace) {
        this.orphanGrace = orphanGrace;
    }

    public static class DynamicAddressingListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            AddressingConfiguration.getInstance().doDynamicPublicAddresses = (Boolean)newValue;
        }
    }
}

