/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.address;

import com.eucalyptus.address.AbstractSystemAddressManager;
import com.eucalyptus.address.Address;
import com.eucalyptus.address.AddressingConfiguration;
import com.eucalyptus.address.AddressingDispatcher;
import com.eucalyptus.address.DynamicSystemAddressManager;
import com.eucalyptus.address.StaticSystemAddressManager;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.compute.common.AddressInfoType;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.event.AbstractNamedRegistry;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.event.SystemConfigurationEvent;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.ResourceAvailabilityEvent;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.UnconditionalCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class Addresses
extends AbstractNamedRegistry<Address>
implements EventListener {
    public static Logger LOG = Logger.getLogger(Addresses.class);
    private static Addresses singleton = Addresses.getInstance();
    private static AbstractSystemAddressManager systemAddressManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Addresses getInstance() {
        Class<Addresses> clazz = Addresses.class;
        synchronized (Addresses.class) {
            if (singleton == null) {
                singleton = new Addresses();
                ListenerRegistry.getInstance().register(SystemConfigurationEvent.class, (EventListener)singleton);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractSystemAddressManager getAddressManager() {
        Class<Addresses> clazz = Addresses.class;
        synchronized (Addresses.class) {
            if (systemAddressManager == null) {
                systemAddressManager = Addresses.getProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemAddressManager;
        }
    }

    public static Address allocateSystemAddress() throws NotEnoughResourcesException {
        return Addresses.getAddressManager().allocateSystemAddress();
    }

    private static AbstractSystemAddressManager getProvider() {
        Class newManager = AddressingConfiguration.getInstance().getDoDynamicPublicAddresses() != false ? DynamicSystemAddressManager.class : StaticSystemAddressManager.class;
        if (systemAddressManager == null) {
            systemAddressManager = (AbstractSystemAddressManager)Classes.newInstance(newManager, (Object[])new Object[0]);
        } else if (!newManager.equals(systemAddressManager.getClass())) {
            AbstractSystemAddressManager oldMgr = systemAddressManager;
            systemAddressManager = (AbstractSystemAddressManager)Classes.newInstance((Class)newManager, (Object[])new Object[0]);
            systemAddressManager.inheritReservedAddresses(oldMgr.getReservedAddresses());
        } else {
            return systemAddressManager;
        }
        LOG.info((Object)("Setting the address manager to be: " + newManager.getSimpleName()));
        return systemAddressManager;
    }

    public static int getSystemReservedAddressCount() {
        return AddressingConfiguration.getInstance().getSystemReservedPublicAddresses();
    }

    public static void updateAddressingMode() {
        Addresses.getProvider();
    }

    public List<Address> listDisabledValues() {
        List addrList = super.listDisabledValues();
        Collections.shuffle(addrList, (Random)Crypto.getSecureRandomSupplier().get());
        return addrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address enableFirst(Predicate<Address> filter) throws NoSuchElementException {
        this.canHas.writeLock().lock();
        try {
            Address first = (Address)((Object)Collections2.filter(this.listDisabledValues(), filter).iterator().next());
            if (first == null) {
                throw new NoSuchElementException("Disabled map is empty.");
            }
            this.register((HasFullName)first);
            Address address = first;
            return address;
        }
        finally {
            this.canHas.writeLock().unlock();
        }
    }

    public static Function<Address, String> allocation() {
        return FilterFunctions.ALLOCATION_ID;
    }

    public static Function<Address, String> association() {
        return FilterFunctions.ASSOCIATION_ID;
    }

    public static Allocator allocator(Address.Domain domain) {
        return new Allocator(domain);
    }

    public static void system(VmInstance vm) {
        try {
            if (!vm.isUsePrivateAddressing() && (VmInstance.VmState.PENDING.equals(vm.getState()) || VmInstance.VmState.RUNNING.equals(vm.getState()))) {
                Addresses.getAddressManager().assignSystemAddress(vm);
            }
        }
        catch (NotEnoughResourcesException e) {
            LOG.warn((Object)("No addresses are available to provide a system address for: " + LogUtil.dumpObject((Object)((Object)vm))));
            LOG.debug((Object)e, (Throwable)e);
        }
    }

    public static void release(final Address addr) {
        block11: {
            try {
                String instanceId = addr.getInstanceId();
                if (addr.isReallyAssigned()) {
                    boolean unassign = false;
                    final boolean wasSystem = addr.isSystemOwned();
                    final String wasOwnerUserId = addr.getOwnerUserId();
                    try {
                        final VmInstance vm = VmInstances.lookup(instanceId);
                        final String vmIp = (String)Objects.firstNonNull((Object)vm.getPublicAddress(), (Object)Address.UNASSIGNED_INSTANCEADDR);
                        try {
                            if (addr.isStarted()) {
                                addr.stop();
                            }
                        }
                        catch (Exception e) {
                            LOG.debug((Object)e, (Throwable)e);
                        }
                        if (VmInstance.VmStateSet.RUN.apply(vm)) {
                            AddressingDispatcher.dispatch(AsyncRequests.newRequest(addr.unassign().getCallback()).then((UnconditionalCallback)new UnconditionalCallback<BaseMessage>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void fire() {
                                    try {
                                        if (!wasSystem || vmIp.equals(addr.getName())) {
                                            Addresses.system(vm);
                                        }
                                    }
                                    finally {
                                        if (addr.isAllocated() && !addr.isAssigned() && wasOwnerUserId.equals(addr.getOwnerUserId())) {
                                            try {
                                                addr.release();
                                            }
                                            catch (Exception e) {
                                                LOG.error((Object)"Error releasing address after unassign", (Throwable)e);
                                            }
                                        }
                                    }
                                }
                            }), vm.getPartition());
                        } else {
                            unassign = true;
                        }
                    }
                    catch (NoSuchElementException e) {
                        Logs.extreme().debug((Object)e, (Throwable)e);
                        unassign = true;
                    }
                    if (unassign) {
                        addr.unassign().clearPending();
                        addr.release();
                    }
                    break block11;
                }
                addr.release();
            }
            catch (Exception e) {
                LOG.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void fireEvent(Event event) {
        if (event instanceof SystemConfigurationEvent) {
            systemAddressManager = Addresses.getProvider();
        }
    }

    public static void updatePublicIpByInstanceId(final String instanceId, String publicIp) {
        Entities.asTransaction(VmInstance.class, (Predicate)new Predicate<String>(){

            public boolean apply(String publicAddress) {
                VmInstance vm = VmInstances.lookup(instanceId);
                vm.updatePublicAddress(publicAddress);
                return true;
            }
        }).apply((Object)publicIp);
    }

    public static void updatePublicIP(String privateIp, String publicIp) {
        Addresses.updatePublicIPOnMatch(privateIp, null, publicIp);
    }

    public static void updatePublicIPOnMatch(final String privateIp, final @Nullable String expectedPublicIp, final String publicIp) {
        Entities.asTransaction(VmInstance.class, (Predicate)new Predicate<Void>(){

            public boolean apply(@Nullable Void nothing) {
                try {
                    VmInstance vm = VmInstances.lookupByPrivateIp(privateIp);
                    if (expectedPublicIp == null || expectedPublicIp.equals(vm.getPublicAddress())) {
                        vm.updatePublicAddress(publicIp);
                    }
                }
                catch (NoSuchElementException e) {
                    LOG.debug((Object)("Instance not found for private IP " + privateIp));
                }
                catch (Exception t) {
                    LOG.error((Object)t, (Throwable)t);
                }
                return true;
            }
        }).apply(null);
    }

    private static enum FilterFunctions implements Function<Address, String>
    {
        ALLOCATION_ID{

            public String apply(Address address) {
                return address.getAllocationId();
            }
        }
        ,
        ASSOCIATION_ID{

            public String apply(Address address) {
                return address.getAssociationId();
            }
        }
        ,
        DOMAIN{

            public String apply(Address address) {
                return address.getDomain() == null ? Address.Domain.standard.toString() : address.getDomain().toString();
            }
        }
        ,
        INSTANCE_ID{

            public String apply(Address address) {
                return address.getInstanceId();
            }
        }
        ,
        NETWORK_INTERFACE_ID{

            public String apply(Address address) {
                return address.getNetworkInterfaceId();
            }
        }
        ,
        NETWORK_INTERFACE_OWNER_ID{

            public String apply(Address address) {
                return address.getNetworkInterfaceOwnerId();
            }
        }
        ,
        PRIVATE_IP_ADDRESS{

            public String apply(Address address) {
                return address.getPrivateAddress();
            }
        }
        ,
        PUBLIC_IP{

            public String apply(Address address) {
                return address.getDisplayName();
            }
        };

    }

    private static enum BooleanFilterFunctions implements Function<Address, Boolean>
    {
        IS_ALLOCATED{

            @Nullable
            public Boolean apply(@Nullable Address address) {
                return address != null && address.isAllocated();
            }
        };

    }

    public static class AddressFilterSupport
    extends FilterSupport<Address> {
        public AddressFilterSupport() {
            super(AddressFilterSupport.builderFor(Address.class).withStringProperty("allocation-id", FilterFunctions.ALLOCATION_ID).withStringProperty("association-id", FilterFunctions.ASSOCIATION_ID).withStringProperty("domain", FilterFunctions.DOMAIN).withStringProperty("instance-id", FilterFunctions.INSTANCE_ID).withStringProperty("network-interface-id", FilterFunctions.NETWORK_INTERFACE_ID).withStringProperty("network-interface-owner-id", FilterFunctions.NETWORK_INTERFACE_OWNER_ID).withStringProperty("private-ip-address", FilterFunctions.PRIVATE_IP_ADDRESS).withStringProperty("public-ip", FilterFunctions.PUBLIC_IP));
        }
    }

    @TypeMapper
    public static enum AddressToAddressInfoTypeTransform implements Function<Address, AddressInfoType>
    {
        INSTANCE;


        public AddressInfoType apply(Address address) {
            AddressInfoType addressInfoType = new AddressInfoType();
            addressInfoType.setPublicIp(address.getName());
            addressInfoType.setDomain(((Address.Domain)((Object)Objects.firstNonNull((Object)((Object)address.getDomain()), (Object)((Object)Address.Domain.standard)))).toString());
            addressInfoType.setAllocationId(address.getAllocationId());
            if (Strings.startsWith((String)"i-").apply((Object)address.getInstanceId())) {
                addressInfoType.setInstanceId(address.getInstanceId());
            }
            addressInfoType.setAssociationId(address.getAssociationId());
            addressInfoType.setNetworkInterfaceId(address.getNetworkInterfaceId());
            addressInfoType.setNetworkInterfaceOwnerId(address.getNetworkInterfaceOwnerId());
            addressInfoType.setPrivateIpAddress(address.getPrivateAddress());
            return addressInfoType;
        }
    }

    public static class AddressAvailabilityEventListener
    implements EventListener<ClockTick> {
        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new AddressAvailabilityEventListener());
        }

        public void fireEvent(ClockTick event) {
            if (Bootstrap.isFinished().booleanValue() && Hosts.isCoordinator()) {
                List addresses = Addresses.getInstance().listValues();
                List<Address> disabledAddresses = Addresses.getInstance().listDisabledValues();
                long total = addresses.size() + disabledAddresses.size();
                long available = Iterators.size((Iterator)Iterators.filter((Iterator)Iterators.concat(addresses.iterator(), disabledAddresses.iterator()), (Predicate)new Predicate<Address>(){

                    public boolean apply(Address address) {
                        return !address.isAllocated();
                    }
                }));
                try {
                    ListenerRegistry.getInstance().fireEvent((Event)new ResourceAvailabilityEvent(ResourceAvailabilityEvent.ResourceType.Address, new ResourceAvailabilityEvent.Availability(total, available)));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }

    public static class Allocator
    implements Supplier<Address>,
    Predicate<Address> {
        private final Address.Domain domain;

        private Allocator(Address.Domain domain) {
            this.domain = domain;
        }

        public Address get() {
            Context ctx = Contexts.lookup();
            try {
                return Addresses.getAddressManager().allocateNext((OwnerFullName)ctx.getUserFullName(), this.domain);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        public boolean apply(Address input) {
            try {
                input.release();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            return true;
        }
    }

    @RestrictedTypes.QuantityMetricFunction(value=CloudMetadata.AddressMetadata.class)
    public static enum CountAddresses implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(OwnerFullName input) {
            return Iterables.size((Iterable)Iterables.filter((Iterable)Addresses.getInstance().listValues(), (Predicate)Predicates.and((Predicate)RestrictedTypes.filterByOwner((OwnerFullName)input), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)Boolean.TRUE), (Function)BooleanFilterFunctions.IS_ALLOCATED))));
        }
    }

    @RestrictedTypes.Resolver(value=Address.class)
    public static enum Lookup implements Function<String, Address>
    {
        INSTANCE;


        public Address apply(String input) {
            Object addressExtractor = Strings.startsWith((String)"eipalloc").apply((Object)input) ? Addresses.allocation() : (Strings.startsWith((String)"eipassoc").apply((Object)input) ? Addresses.association() : null);
            Optional addressOptional = addressExtractor != null ? Iterables.tryFind((Iterable)Addresses.getInstance().listValues(), (Predicate)CollectionUtils.propertyPredicate((Object)input, addressExtractor)) : Optional.of((Object)Addresses.getInstance().lookup(input));
            if (!addressOptional.isPresent()) {
                throw new NoSuchElementException("Address not found for " + input);
            }
            return (Address)((Object)addressOptional.get());
        }
    }
}

