/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.address;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.address.AddressingDispatcher;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.common.AddressInfoType;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.backend.AllocateAddressResponseType;
import com.eucalyptus.compute.common.backend.AllocateAddressType;
import com.eucalyptus.compute.common.backend.AssociateAddressResponseType;
import com.eucalyptus.compute.common.backend.AssociateAddressType;
import com.eucalyptus.compute.common.backend.DescribeAddressesResponseType;
import com.eucalyptus.compute.common.backend.DescribeAddressesType;
import com.eucalyptus.compute.common.backend.DisassociateAddressResponseType;
import com.eucalyptus.compute.common.backend.DisassociateAddressType;
import com.eucalyptus.compute.common.backend.ReleaseAddressResponseType;
import com.eucalyptus.compute.common.backend.ReleaseAddressType;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.InternetGateways;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NetworkInterfaceHelper;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.compute.vpc.VpcMetadataNotFoundException;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.records.Logs;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.UnconditionalCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmNetworkConfig;
import com.google.common.base.Enums;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.apache.log4j.Logger;

@ComponentNamed
public class AddressManager {
    private static final Logger LOG = Logger.getLogger(AddressManager.class);
    private final InternetGateways internetGateways;

    @Inject
    public AddressManager(InternetGateways internetGateways) {
        this.internetGateways = internetGateways;
    }

    public AllocateAddressResponseType allocateAddress(AllocateAddressType request) throws Exception {
        AllocateAddressResponseType reply = (AllocateAddressResponseType)request.getReply();
        try {
            String defaultVpcId = AddressManager.getDefaultVpcId();
            Address.Domain domain = defaultVpcId != null ? Address.Domain.vpc : (Address.Domain)((Object)Optional.fromNullable((Object)request.getDomain()).transform(Enums.valueOfFunction(Address.Domain.class)).or((Object)Address.Domain.standard));
            Addresses.Allocator allocator = Addresses.allocator(domain);
            Address address = (Address)((Object)RestrictedTypes.allocateNamedUnitlessResources((Integer)1, (Supplier)allocator, (Predicate)allocator).get(0));
            reply.setPublicIp(address.getName());
            switch (domain) {
                case vpc: {
                    reply.setAllocationId(address.getAllocationId());
                }
            }
            reply.setDomain(domain.name());
        }
        catch (RuntimeException e) {
            if (e.getCause() != null) {
                throw new EucalyptusCloudException(e.getCause());
            }
            throw new EucalyptusCloudException("couldn't allocate addresses");
        }
        return reply;
    }

    public ReleaseAddressResponseType releaseAddress(ReleaseAddressType request) throws Exception {
        Address address;
        ReleaseAddressResponseType reply = (ReleaseAddressResponseType)request.getReply().markFailed();
        if (request.getPublicIp() == null && request.getAllocationId() == null) {
            throw new ClientComputeException("MissingParameter", "PublicIp or AllocationId required");
        }
        try {
            address = (Address)RestrictedTypes.doPrivileged((String)((String)Objects.firstNonNull((Object)request.getPublicIp(), (Object)ResourceIdentifiers.tryNormalize().apply((Object)request.getAllocationId()))), Address.class);
        }
        catch (NoSuchElementException e) {
            if (request.getAllocationId() != null) {
                throw new ClientComputeException("InvalidAddressID.NotFound", "Address not found for allocation (" + request.getAllocationId() + ")");
            }
            throw e;
        }
        if (address.getDomain() == Address.Domain.vpc && address.isAssigned()) {
            throw new ClientComputeException("InvalidIPAddress.InUse", "Address (" + address.getName() + ") in use (" + address.getNetworkInterfaceId() + ")");
        }
        if (address.isPending()) {
            address.clearPending();
        }
        Addresses.release(address);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DescribeAddressesResponseType describeAddresses(DescribeAddressesType request) throws EucalyptusCloudException {
        DescribeAddressesResponseType reply = (DescribeAddressesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean isAdmin = ctx.isAdministrator();
        boolean verbose = isAdmin && request.getPublicIpsSet().remove("verbose");
        Predicate filter = CloudMetadatas.filteringFor(Address.class).byId((Collection)request.getPublicIpsSet()).byProperty((Collection)request.getAllocationIds(), Addresses.allocation()).byPredicate(Filters.generate(request.getFilterSet(), Address.class).asPredicate()).byOwningAccount(verbose ? Collections.emptyList() : Collections.singleton(ctx.getAccount().getAccountNumber())).byPrivileges().buildPredicate();
        for (Address address : Iterables.filter((Iterable)Addresses.getInstance().listValues(), (Predicate)filter)) {
            reply.getAddressesSet().add(verbose ? address.getAdminDescription() : (AddressInfoType)TypeMappers.transform((Object)((Object)address), AddressInfoType.class));
        }
        if (verbose) {
            for (Address address : Iterables.filter(Addresses.getInstance().listDisabledValues(), (Predicate)filter)) {
                reply.getAddressesSet().add(new AddressInfoType(address.getName(), Address.Domain.standard.toString(), Principals.nobodyFullName().getUserName()));
            }
        }
        return reply;
    }

    public AssociateAddressResponseType associateAddress(AssociateAddressType request) throws Exception {
        VmInstance vm;
        AssociateAddressResponseType reply = (AssociateAddressResponseType)request.getReply().markFailed();
        String instanceId = request.getInstanceId() == null ? null : AddressManager.normalizeInstanceIdentifier(request.getInstanceId());
        String networkInterfaceId = request.getNetworkInterfaceId() == null ? null : AddressManager.normalizeNetworkInterfaceIdentifier(request.getNetworkInterfaceId());
        final Address address = (Address)RestrictedTypes.doPrivileged((String)((String)Objects.firstNonNull((Object)request.getPublicIp(), (Object)ResourceIdentifiers.tryNormalize().apply((Object)request.getAllocationId()))), Address.class);
        if (!address.isAllocated()) {
            throw new EucalyptusCloudException("Cannot associate an address which is not allocated: " + request.getPublicIp());
        }
        if (!Contexts.lookup().isAdministrator() && !Contexts.lookup().getUserFullName().asAccountFullName().getAccountNumber().equals(address.getOwner().getAccountNumber())) {
            throw new EucalyptusCloudException("Cannot associate an address which is not allocated to your account: " + request.getPublicIp());
        }
        VmInstance vmInstance = vm = instanceId == null ? null : (VmInstance)RestrictedTypes.doPrivileged((String)instanceId, VmInstance.class);
        if (address.getDomain() != Address.Domain.vpc) {
            if (vm == null) {
                throw new ClientComputeException(" InvalidParameterCombination", "InstanceId must be specified when using PublicIp");
            }
            final VmInstance oldVm = AddressManager.findCurrentAssignedVm(address);
            final Address oldAddr = AddressManager.findVmExistingAddress(vm);
            reply.set_return(Boolean.valueOf(true));
            if (oldAddr != null && address.equals((Object)oldAddr)) {
                return reply;
            }
            UnconditionalCallback<BaseMessage> assignTarget = new UnconditionalCallback<BaseMessage>(){

                public void fire() {
                    AddressingDispatcher.dispatch(AsyncRequests.newRequest(address.assign(vm).getCallback()).then((Callback.Success)new Callback.Success<BaseMessage>(){

                        public void fire(BaseMessage response) {
                            Addresses.updatePublicIpByInstanceId(vm.getInstanceId(), address.getName());
                        }
                    }), vm.getPartition());
                    if (oldVm != null) {
                        Addresses.system(oldVm);
                    }
                }
            };
            UnconditionalCallback<BaseMessage> unassignBystander = new UnconditionalCallback<BaseMessage>((UnconditionalCallback)assignTarget, vm){
                final /* synthetic */ UnconditionalCallback val$assignTarget;
                final /* synthetic */ VmInstance val$vm;
                {
                    this.val$assignTarget = unconditionalCallback;
                    this.val$vm = vmInstance;
                }

                public void fire() {
                    if (oldAddr != null) {
                        AddressingDispatcher.dispatch(AsyncRequests.newRequest(oldAddr.unassign().getCallback()).then(this.val$assignTarget), this.val$vm.getPartition());
                    } else {
                        this.val$assignTarget.fire();
                    }
                }
            };
            if (address.isAssigned()) {
                AddressingDispatcher.dispatch(AsyncRequests.newRequest(address.unassign().getCallback()).then((UnconditionalCallback)unassignBystander), oldVm.getPartition());
            } else {
                unassignBystander.fire();
            }
        } else {
            NetworkInterface networkInterface;
            try (TransactionResource tx = Entities.transactionFor(VmInstance.class);){
                networkInterface = vm != null ? (NetworkInterface)((Object)Iterables.getOnlyElement(((VmInstance)((Object)Entities.merge((Object)((Object)vm)))).getNetworkInterfaces())) : (NetworkInterface)RestrictedTypes.doPrivileged((String)networkInterfaceId, NetworkInterface.class);
            }
            reply.set_return(Boolean.valueOf(true));
            if (!address.isAssigned() || !networkInterface.getDisplayName().equals(address.getNetworkInterfaceId())) {
                if (address.isAssigned() && !request.getAllowReassociation().booleanValue()) {
                    throw new ClientComputeException("Resource.AlreadyAssociated", "Address already associated");
                }
                if (address.isAssigned()) {
                    NetworkInterface oldNetworkInterface = (NetworkInterface)RestrictedTypes.doPrivileged((String)address.getNetworkInterfaceId(), NetworkInterface.class);
                    x2 = null;
                    try (TransactionResource tx = Entities.transactionFor(NetworkInterface.class);){
                        NetworkInterface eni = (NetworkInterface)((Object)Entities.merge((Object)((Object)oldNetworkInterface)));
                        address.unassign(eni);
                        eni.disassociate();
                        if (eni.isAttached()) {
                            eni.getAttachment().getInstance().updatePublicAddress(VmNetworkConfig.DEFAULT_IP);
                        }
                        tx.commit();
                    }
                    catch (Throwable throwable) {
                        x2 = throwable;
                        throw throwable;
                    }
                }
                try {
                    tx = Entities.transactionFor(NetworkInterface.class);
                    Throwable throwable = null;
                    try {
                        NetworkInterface eni = (NetworkInterface)((Object)Entities.merge((Object)((Object)networkInterface)));
                        this.internetGateways.lookupByVpc((OwnerFullName)AccountFullName.getInstance((String)address.getOwnerAccountNumber(), (String[])new String[0]), eni.getVpc().getDisplayName(), CloudMetadatas.toDisplayName());
                        if (eni.isAssociated()) {
                            NetworkInterfaceHelper.releasePublic(eni);
                            eni.disassociate();
                            if (eni.isAttached()) {
                                eni.getAttachment().getInstance().updatePublicAddress(VmNetworkConfig.DEFAULT_IP);
                            }
                        }
                        NetworkInterfaceHelper.associate(address, eni);
                        tx.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
                catch (VpcMetadataNotFoundException e) {
                    throw new ClientComputeException("Gateway.NotAttached", "Internet gateway not found for VPC");
                }
            }
            reply.setAssociationId(address.getAssociationId());
        }
        return reply;
    }

    public DisassociateAddressResponseType disassociateAddress(DisassociateAddressType request) throws Exception {
        Address address;
        DisassociateAddressResponseType reply = (DisassociateAddressResponseType)request.getReply().markFailed();
        Context ctx = Contexts.lookup();
        try {
            address = (Address)RestrictedTypes.doPrivileged((String)((String)Objects.firstNonNull((Object)request.getPublicIp(), (Object)ResourceIdentifiers.tryNormalize().apply((Object)request.getAssociationId()))), Address.class);
        }
        catch (NoSuchElementException e) {
            if (request.getAssociationId() != null) {
                throw new ClientComputeException("InvalidAssociationID.NotFound", "Association identifier (" + request.getAssociationId() + ") not found.");
            }
            throw e;
        }
        reply.set_return(Boolean.valueOf(true));
        if (address.isSystemOwned() && !ctx.isAdministrator()) {
            throw new EucalyptusCloudException("Only administrators can unassign system owned addresses: " + address.toString());
        }
        if (address.getDomain() != Address.Domain.vpc) {
            final String vmId = address.getInstanceId();
            try {
                final VmInstance vm = VmInstances.lookup(vmId);
                UnconditionalCallback<BaseMessage> systemAddressAssignmentCallback = new UnconditionalCallback<BaseMessage>(){

                    public void fire() {
                        try {
                            Addresses.system(VmInstances.lookup(vmId));
                        }
                        catch (NoSuchElementException e) {
                            LOG.debug((Object)e, (Throwable)e);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error assigning system address for instance " + vm.getInstanceId()), (Throwable)e);
                        }
                    }
                };
                AddressingDispatcher.dispatch(AsyncRequests.newRequest(address.unassign().getCallback()).then((UnconditionalCallback)systemAddressAssignmentCallback), vm.getPartition());
            }
            catch (Exception e) {
                LOG.debug((Object)e);
                Logs.extreme().debug((Object)e, (Throwable)e);
                address.unassign().clearPending();
            }
        } else {
            NetworkInterface networkInterface = (NetworkInterface)RestrictedTypes.doPrivileged((String)address.getNetworkInterfaceId(), NetworkInterface.class);
            try (TransactionResource tx = Entities.transactionFor(NetworkInterface.class);){
                NetworkInterface eni = (NetworkInterface)((Object)Entities.merge((Object)((Object)networkInterface)));
                if (address.isStarted()) {
                    address.stop();
                }
                address.unassign(eni);
                eni.disassociate();
                if (eni.isAttached()) {
                    VmInstance vm = eni.getAttachment().getInstance();
                    vm.updatePublicAddress(VmNetworkConfig.DEFAULT_IP);
                    if (!vm.isUsePrivateAddressing() && (VmInstance.VmState.PENDING.equals(vm.getState()) || VmInstance.VmState.RUNNING.equals(vm.getState()))) {
                        NetworkInterfaceHelper.associate(Addresses.allocateSystemAddress(), eni);
                    }
                }
                tx.commit();
            }
        }
        return reply;
    }

    private static Address findVmExistingAddress(VmInstance vm) {
        Address oldAddr = null;
        if (vm.hasPublicAddress()) {
            try {
                oldAddr = (Address)Addresses.getInstance().lookup(vm.getPublicAddress());
            }
            catch (Exception e) {
                LOG.debug((Object)e, (Throwable)e);
            }
        }
        return oldAddr;
    }

    private static VmInstance findCurrentAssignedVm(Address address) {
        VmInstance oldVm = null;
        if (address.isAssigned() && !address.isPending()) {
            try {
                oldVm = VmInstances.lookup(address.getInstanceId());
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return oldVm;
    }

    private static String getDefaultVpcId() {
        return AddressManager.getDefaultVpcId(Contexts.lookup().getUserFullName().asAccountFullName());
    }

    private static String getDefaultVpcId(AccountFullName accountFullName) {
        try (TransactionResource tx = Entities.transactionFor(Vpc.class);){
            String string = (String)Iterables.tryFind((Iterable)Entities.query((Object)((Object)Vpc.exampleDefault((OwnerFullName)accountFullName))), (Predicate)Predicates.alwaysTrue()).transform(CloudMetadatas.toDisplayName()).orNull();
            return string;
        }
    }

    private static String normalizeIdentifier(String identifier, String prefix, boolean required, String message) throws ClientComputeException {
        try {
            return Strings.emptyToNull((String)identifier) == null && !required ? null : ResourceIdentifiers.parse(prefix, identifier).getIdentifier();
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidParameterValue", String.format(message, e.getIdentifier()));
        }
    }

    private static String normalizeInstanceIdentifier(String identifier) throws EucalyptusCloudException {
        return AddressManager.normalizeIdentifier(identifier, "i", true, "Value (%s) for parameter instanceId is invalid. Expected: 'i-...'.");
    }

    private static String normalizeNetworkInterfaceIdentifier(String identifier) throws EucalyptusCloudException {
        return AddressManager.normalizeIdentifier(identifier, "eni", true, "Value (%s) for parameter networkInterface is invalid. Expected: 'eni-...'.");
    }
}

