/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.address;

import com.eucalyptus.address.Addresses;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cluster.callback.AssignAddressCallback;
import com.eucalyptus.cluster.callback.UnassignAddressCallback;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.common.AddressInfoType;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.entities.AccountMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.reporting.event.AddressEvent;
import com.eucalyptus.reporting.event.EventActionInfo;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.NOOP;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.lang.reflect.Constructor;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicMarkableReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_addresses")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Address
extends UserMetadata<State>
implements CloudMetadata.AddressMetadata {
    public static final String ID_PREFIX_ALLOC = "eipalloc";
    public static final String ID_PREFIX_ASSOC = "eipassoc";
    private static Logger LOG = Logger.getLogger(Address.class);
    private static final long serialVersionUID = 1L;
    @Transient
    private String instanceUuid;
    @Transient
    private String instanceId;
    @Transient
    private String instanceAddress;
    @Enumerated(value=EnumType.STRING)
    @Column(name="metadata_domain")
    private Domain domain;
    @Column(name="metadata_allocation_id")
    private String allocationId;
    @Column(name="metadata_association_id")
    private String associationId;
    @Column(name="metadata_association_eni_id")
    private String networkInterfaceId;
    @Column(name="metadata_association_eni_owner_id")
    private String networkInterfaceOwnerId;
    @Column(name="metadata_association_private_address")
    private String privateAddress;
    public static String UNASSIGNED_INSTANCEUUID = "";
    public static String UNASSIGNED_INSTANCEID = "available";
    public static String UNASSIGNED_INSTANCEADDR = "0.0.0.0";
    public static String PENDING_ASSIGNMENT = "pending";
    public static String PENDING_ASSIGNMENTUUID = "";
    public static String ASSIGNED_UNKNOWN_INSTANCEUUID = "";
    public static String ASSIGNED_UNKNOWN_INSTANCEID = "assigned";
    public static String ASSIGNED_UNKNOWN_INSTANCEADDR = "0.0.0.0";
    @Transient
    private AtomicMarkableReference<State> atomicState;
    @Transient
    private String stateUuid;
    @Transient
    private final transient SplitTransition QUIESCENT = new SplitTransition(Transition.quiescent){

        @Override
        public void bottom() {
        }

        @Override
        public void top() {
        }

        @Override
        public String toString() {
            return "";
        }
    };
    @Transient
    private volatile SplitTransition transition;

    public Address() {
    }

    public Address(String ipAddress) {
        super(Principals.nobodyFullName(), ipAddress);
        this.instanceUuid = UNASSIGNED_INSTANCEUUID;
        this.instanceId = UNASSIGNED_INSTANCEID;
        this.instanceAddress = UNASSIGNED_INSTANCEADDR;
        this.transition = this.QUIESCENT;
        this.atomicState = new AtomicMarkableReference<State>(State.unallocated, false);
        this.init();
    }

    public Address(OwnerFullName ownerFullName, String address, String instanceUuid, String instanceId, String instanceAddress) {
        this(address);
        this.setOwner(ownerFullName);
        this.instanceUuid = instanceUuid;
        this.instanceId = instanceId;
        this.instanceAddress = instanceAddress;
        this.transition = this.QUIESCENT;
        this.atomicState = new AtomicMarkableReference<State>(State.allocated, false);
        this.init();
    }

    public void init() {
        this.resetPersistence();
        this.atomicState = new AtomicMarkableReference<State>(State.unallocated, false);
        this.transition = this.QUIESCENT;
        this.getOwner();
        if (this.instanceAddress == null || this.instanceId == null) {
            this.instanceAddress = UNASSIGNED_INSTANCEADDR;
            this.instanceUuid = UNASSIGNED_INSTANCEUUID;
            this.instanceId = UNASSIGNED_INSTANCEID;
        }
        if (Principals.nobodyFullName().equals(super.getOwner())) {
            this.atomicState.set(State.unallocated, true);
            this.instanceAddress = UNASSIGNED_INSTANCEADDR;
            this.instanceUuid = UNASSIGNED_INSTANCEUUID;
            this.instanceId = UNASSIGNED_INSTANCEID;
            this.associationId = null;
            this.networkInterfaceId = null;
            this.networkInterfaceOwnerId = null;
            this.privateAddress = null;
            Addresses.getInstance().registerDisabled((HasFullName)this);
            this.atomicState.set(State.unallocated, false);
        } else if (!this.instanceId.equals(UNASSIGNED_INSTANCEID)) {
            State addressState = this.networkInterfaceId != null ? State.started : State.assigned;
            this.atomicState.set(addressState, true);
            Addresses.getInstance().register((HasFullName)this);
            this.atomicState.set(addressState, false);
        } else if (this.networkInterfaceId != null) {
            this.atomicState.set(State.assigned, true);
            Addresses.getInstance().register((HasFullName)this);
            this.atomicState.set(State.assigned, false);
        } else {
            this.atomicState.set(State.allocated, true);
            if (this.isSystemOwned()) {
                Addresses.getInstance().registerDisabled((HasFullName)this);
                this.setOwner(Principals.nobodyFullName());
                this.instanceAddress = UNASSIGNED_INSTANCEADDR;
                this.instanceUuid = UNASSIGNED_INSTANCEUUID;
                this.instanceId = UNASSIGNED_INSTANCEID;
                this.associationId = null;
                this.networkInterfaceId = null;
                this.networkInterfaceOwnerId = null;
                this.privateAddress = null;
                Address.removeAddress(this.getDisplayName());
                this.atomicState.set(State.unallocated, false);
            } else {
                Addresses.getInstance().register((HasFullName)this);
                this.atomicState.set(State.allocated, false);
            }
        }
        LOG.debug((Object)("Initialized address: " + this.toString()));
    }

    private boolean transition(State expectedState, State newState, boolean expectedMark, boolean newMark, SplitTransition transition) {
        if (!this.atomicState.compareAndSet(expectedState, newState, expectedMark, newMark)) {
            throw new IllegalStateException(String.format("Cannot mark address as %s[%s.%s->%s.%s] when it is %s.%s: %s", new Object[]{transition.getName(), expectedState, expectedMark, newState, newMark, this.atomicState.getReference(), this.atomicState.isMarked(), this.toString()}));
        }
        this.transition = transition;
        EventRecord.caller(((Object)((Object)this)).getClass(), (EventType)EventType.ADDRESS_STATE, (Object[])new Object[]{"TOP", this.toString()}).info();
        try {
            this.transition.top();
        }
        catch (RuntimeException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        return true;
    }

    public Address allocate(final OwnerFullName ownerFullName, final Domain domain) {
        this.transition(State.unallocated, State.allocated, false, true, new SplitTransition(Transition.allocating){

            @Override
            public void top() {
                Address.this.instanceUuid = UNASSIGNED_INSTANCEUUID;
                Address.this.instanceId = UNASSIGNED_INSTANCEID;
                Address.this.instanceAddress = UNASSIGNED_INSTANCEADDR;
                Address.this.associationId = null;
                Address.this.networkInterfaceId = null;
                Address.this.networkInterfaceOwnerId = null;
                Address.this.privateAddress = null;
                Address.this.allocationId = domain == Domain.vpc ? ResourceIdentifiers.generateString(Address.ID_PREFIX_ALLOC) : null;
                Address.this.domain = domain;
                Address.this.setOwner(ownerFullName);
                Address.addAddress(Address.this);
                try {
                    Addresses.getInstance().register((HasFullName)Address.this);
                }
                catch (NoSuchElementException e) {
                    LOG.debug((Object)e);
                }
                Address.this.stateUuid = UUID.randomUUID().toString();
                Address.this.atomicState.attemptMark(State.allocated, false);
            }

            @Override
            public void bottom() {
            }
        });
        this.fireUsageEvent(ownerFullName, (Supplier<EventActionInfo<AddressEvent.AddressAction>>)Suppliers.ofInstance((Object)AddressEvent.forAllocate()));
        return this;
    }

    public Address release() {
        this.fireUsageEvent((Supplier<EventActionInfo<AddressEvent.AddressAction>>)Suppliers.ofInstance((Object)AddressEvent.forRelease()));
        SplitTransition release = new SplitTransition(Transition.unallocating){

            @Override
            public void top() {
                Address.this.instanceUuid = UNASSIGNED_INSTANCEUUID;
                Address.this.instanceId = UNASSIGNED_INSTANCEID;
                Address.this.instanceAddress = UNASSIGNED_INSTANCEADDR;
                Address.this.associationId = null;
                Address.this.networkInterfaceId = null;
                Address.this.networkInterfaceOwnerId = null;
                Address.this.privateAddress = null;
                Address.this.allocationId = null;
                Address.this.domain = null;
                Address.removeAddress(Address.this.getDisplayName());
                Address.this.setOwner(Principals.nobodyFullName());
                Address.this.stateUuid = UUID.randomUUID().toString();
                Address.this.atomicState.attemptMark(State.unallocated, false);
            }

            @Override
            public void bottom() {
            }
        };
        if (State.impending.equals((Object)this.atomicState.getReference())) {
            this.transition(State.impending, State.unallocated, this.isPending(), true, release);
        } else {
            this.transition(State.allocated, State.unallocated, false, true, release);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAddress(String ipAddress) {
        try {
            Addresses.getInstance().disable(ipAddress);
        }
        catch (NoSuchElementException e1) {
            LOG.debug((Object)e1);
        }
        EntityTransaction db = Entities.get(Address.class);
        try {
            Entities.delete((Object)Entities.uniqueResult((Object)((Object)Address.forIp(ipAddress))));
            db.commit();
        }
        catch (NoSuchElementException e) {
            LOG.debug((Object)("Address not found for removal '" + ipAddress + "'"));
        }
        catch (Exception e) {
            Logs.extreme().error((Object)e, (Throwable)e);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public Address unassign() {
        this.fireUsageEvent(new Supplier<EventActionInfo<AddressEvent.AddressAction>>(){

            public EventActionInfo<AddressEvent.AddressAction> get() {
                return AddressEvent.forDisassociate((String)Address.this.instanceUuid, (String)Address.this.instanceId);
            }
        });
        SplitTransition unassign = new SplitTransition(Transition.unassigning){

            @Override
            public void top() {
                try {
                    VmInstance vmInstance = VmInstances.lookup(Address.this.getInstanceId());
                }
                catch (NoSuchElementException e) {
                    LOG.debug((Object)e);
                }
            }

            @Override
            public void bottom() {
                Address.this.stateUuid = UUID.randomUUID().toString();
                Address.this.instanceUuid = UNASSIGNED_INSTANCEUUID;
                Address.this.instanceId = UNASSIGNED_INSTANCEID;
                Address.this.instanceAddress = UNASSIGNED_INSTANCEADDR;
                Address.this.associationId = null;
                Address.this.networkInterfaceId = null;
                Address.this.networkInterfaceOwnerId = null;
                Address.this.privateAddress = null;
            }
        };
        if (State.impending.equals((Object)this.atomicState.getReference())) {
            this.transition(State.impending, State.allocated, this.isPending(), true, unassign);
        } else {
            this.transition(State.assigned, State.allocated, false, true, unassign);
        }
        return this;
    }

    public Address unassign(@Nonnull NetworkInterface networkInterface) {
        SplitTransition unassign = new SplitTransition(Transition.unassigning){

            @Override
            public void top() {
                Address.this.stateUuid = UUID.randomUUID().toString();
                Address.this.instanceUuid = UNASSIGNED_INSTANCEUUID;
                Address.this.instanceId = UNASSIGNED_INSTANCEID;
                Address.this.instanceAddress = UNASSIGNED_INSTANCEADDR;
                Address.this.associationId = null;
                Address.this.networkInterfaceId = null;
                Address.this.networkInterfaceOwnerId = null;
                Address.this.privateAddress = null;
            }

            @Override
            public void bottom() {
            }
        };
        if (State.impending.equals((Object)this.atomicState.getReference())) {
            this.transition(State.impending, State.allocated, this.isPending(), false, unassign);
        } else {
            this.transition(State.assigned, State.allocated, false, false, unassign);
        }
        return this;
    }

    public Address pendingAssignment() {
        this.transition(State.unallocated, State.impending, false, true, new SplitTransition(Transition.system){

            @Override
            public void top() {
                Address.this.instanceUuid = PENDING_ASSIGNMENTUUID;
                Address.this.instanceId = PENDING_ASSIGNMENT;
                Address.this.instanceAddress = UNASSIGNED_INSTANCEADDR;
                Address.this.setOwner(Principals.systemFullName());
                Address.this.stateUuid = UUID.randomUUID().toString();
                try {
                    Addresses.getInstance().register((HasFullName)Address.this);
                }
                catch (NoSuchElementException e) {
                    LOG.debug((Object)e);
                }
            }

            @Override
            public void bottom() {
            }
        });
        return this;
    }

    public Address assign(final VmInstance vm) {
        if (vm.getVpcId() != null) {
            throw new IllegalArgumentException("Cannot assign address to VPC instance");
        }
        SplitTransition assign = new SplitTransition(Transition.assigning){

            @Override
            public void top() {
                Address.this.setInstanceInfo(vm.getInstanceUuid(), vm.getInstanceId(), vm.getPrivateAddress());
                Address.this.stateUuid = UUID.randomUUID().toString();
            }

            @Override
            public void bottom() {
            }
        };
        if (State.impending.equals((Object)this.atomicState.getReference())) {
            this.transition(State.impending, State.assigned, true, true, assign);
        } else {
            this.transition(State.allocated, State.assigned, false, true, assign);
        }
        this.fireUsageEvent(new Supplier<EventActionInfo<AddressEvent.AddressAction>>(){

            public EventActionInfo<AddressEvent.AddressAction> get() {
                return AddressEvent.forAssociate((String)vm.getInstanceUuid(), (String)vm.getInstanceId());
            }
        });
        return this;
    }

    public Address assign(final NetworkInterface networkInterface) {
        SplitTransition assign = new SplitTransition(Transition.assigning){

            @Override
            public void top() {
                Address.this.setNetworkInterfaceInfo(networkInterface.getDisplayName(), networkInterface.getOwnerAccountNumber(), networkInterface.getPrivateIpAddress());
                Address.this.setInstanceInfo(ASSIGNED_UNKNOWN_INSTANCEUUID, ASSIGNED_UNKNOWN_INSTANCEID, ASSIGNED_UNKNOWN_INSTANCEADDR);
                Address.this.stateUuid = UUID.randomUUID().toString();
            }

            @Override
            public void bottom() {
            }
        };
        if (State.impending.equals((Object)this.atomicState.getReference())) {
            this.transition(State.impending, State.assigned, true, false, assign);
        } else {
            this.transition(State.allocated, State.assigned, false, false, assign);
        }
        return this;
    }

    public Address start(final VmInstance vm) {
        SplitTransition start = new SplitTransition(Transition.starting){

            @Override
            public void top() {
                if (Address.this.getNetworkInterfaceId() == null) {
                    throw new IllegalStateException("Network interface not set");
                }
                Address.this.setInstanceInfo(vm.getInstanceUuid(), vm.getInstanceId(), vm.getPrivateAddress());
                Address.this.stateUuid = UUID.randomUUID().toString();
            }

            @Override
            public void bottom() {
            }
        };
        this.transition(State.assigned, State.started, false, false, start);
        this.fireUsageEvent(new Supplier<EventActionInfo<AddressEvent.AddressAction>>(){

            public EventActionInfo<AddressEvent.AddressAction> get() {
                return AddressEvent.forAssociate((String)vm.getInstanceUuid(), (String)vm.getInstanceId());
            }
        });
        return this;
    }

    public Address stop() {
        this.fireUsageEvent(new Supplier<EventActionInfo<AddressEvent.AddressAction>>(){

            public EventActionInfo<AddressEvent.AddressAction> get() {
                return AddressEvent.forDisassociate((String)Address.this.instanceUuid, (String)Address.this.instanceId);
            }
        });
        SplitTransition stop = new SplitTransition(Transition.stopping){

            @Override
            public void top() {
            }

            @Override
            public void bottom() {
                Address.this.stateUuid = UUID.randomUUID().toString();
                Address.this.instanceUuid = UNASSIGNED_INSTANCEUUID;
                Address.this.instanceId = UNASSIGNED_INSTANCEID;
                Address.this.instanceAddress = UNASSIGNED_INSTANCEADDR;
            }
        };
        this.transition(State.started, State.assigned, false, false, stop);
        return this;
    }

    public Transition getTransition() {
        return this.transition.getName();
    }

    public RemoteCallback<? extends BaseMessage, ? extends BaseMessage> getCallback(BaseMessage originReq) {
        RemoteCallback<? extends BaseMessage, ? extends BaseMessage> cb = this.getCallback();
        return cb;
    }

    public RemoteCallback<? extends BaseMessage, ? extends BaseMessage> getCallback() {
        try {
            Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> cbClass = this.transition.getName().getCallback();
            Constructor<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> cbCons = cbClass.getConstructor(Address.class);
            return cbCons.newInstance(new Object[]{this});
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            try {
                this.clearPending();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new NOOP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address clearPending() {
        if (!this.atomicState.isMarked()) {
            throw new IllegalStateException("Trying to clear an address which is not currently pending.");
        }
        EventRecord.caller(((Object)((Object)this)).getClass(), (EventType)EventType.ADDRESS_STATE, (Object[])new Object[]{"BOTTOM", this.toString()}).info();
        try {
            this.transition.bottom();
        }
        catch (RuntimeException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
        finally {
            this.transition = this.QUIESCENT;
            this.atomicState.set(this.atomicState.getReference(), false);
        }
        return this;
    }

    public boolean isAllocated() {
        return this.atomicState.getReference().ordinal() > State.unallocated.ordinal();
    }

    public boolean isSystemOwned() {
        return Principals.systemFullName().equals((UserFullName)this.getOwner());
    }

    public boolean isAssigned() {
        return this.atomicState.getReference().ordinal() > State.allocated.ordinal();
    }

    public boolean isReallyAssigned() {
        return this.atomicState.getReference().ordinal() > State.impending.ordinal();
    }

    public boolean isStarted() {
        return this.atomicState.getReference().ordinal() > State.assigned.ordinal();
    }

    public boolean isPending() {
        return this.atomicState.isMarked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAddress(Address address) {
        EntityTransaction db = Entities.get(Address.class);
        String naturalId = address.getNaturalId();
        try {
            try {
                Entities.delete((Object)Entities.uniqueResult((Object)((Object)Address.forIp(address.getName()))));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            address.setNaturalId(null);
            Address persisted = (Address)((Object)Entities.mergeDirect((Object)((Object)address)));
            naturalId = persisted.getNaturalId();
            db.commit();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
            address.setNaturalId(naturalId);
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceUuid() {
        return this.instanceUuid;
    }

    public String getUserId() {
        return this.getOwner().getUserId();
    }

    public String getInstanceAddress() {
        return this.instanceAddress;
    }

    public String getStateUuid() {
        return this.stateUuid;
    }

    @Nullable
    public Domain getDomain() {
        return this.domain;
    }

    @Nullable
    public String getAllocationId() {
        return this.allocationId;
    }

    @Nullable
    public String getAssociationId() {
        return this.associationId;
    }

    @Nullable
    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    @Nullable
    public String getNetworkInterfaceOwnerId() {
        return this.networkInterfaceOwnerId;
    }

    @Nullable
    public String getPrivateAddress() {
        return this.privateAddress;
    }

    private void setInstanceInfo(String instanceUuid, String instanceId, String instanceAddress) {
        this.instanceUuid = instanceUuid;
        this.instanceId = instanceId;
        this.instanceAddress = instanceAddress;
    }

    private void setNetworkInterfaceInfo(String networkInterfaceId, String networkInterfaceOwnerId, String privateAddress) {
        this.associationId = ResourceIdentifiers.generateString(ID_PREFIX_ASSOC);
        this.networkInterfaceId = networkInterfaceId;
        this.networkInterfaceOwnerId = networkInterfaceOwnerId;
        this.privateAddress = privateAddress;
    }

    public String toString() {
        return "Address " + this.getDisplayName() + " " + (this.isAllocated() ? this.getOwner() + " " : "") + (this.isAssigned() ? this.instanceId + " " + this.instanceAddress + " " : "") + " " + this.transition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)((Object)o);
        return this.getDisplayName().equals(address.getDisplayName());
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    public AddressInfoType getAdminDescription() {
        AddressInfoType addressInfoType = (AddressInfoType)TypeMappers.transform((Object)((Object)this), AddressInfoType.class);
        String desc = String.format("%s (%s)", this.getInstanceId(), this.getOwner());
        addressInfoType.setInstanceId(desc);
        return addressInfoType;
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((ClusterController)ComponentIds.lookup(ClusterController.class)).name()).namespace(this.getPartition()).relativeId(new String[]{"public-address", this.getName()});
    }

    public int compareTo(AccountMetadata that) {
        if (that instanceof Address) {
            return this.getName().compareTo(that.getName());
        }
        return super.compareTo(that);
    }

    public String getPartition() {
        return "eucalyptus";
    }

    private static Address forIp(String ip) {
        Address example = new Address();
        example.setDisplayName(ip);
        return example;
    }

    private void fireUsageEvent(Supplier<EventActionInfo<AddressEvent.AddressAction>> actionInfoSupplier) {
        this.fireUsageEvent(this.getOwner(), actionInfoSupplier);
    }

    private void fireUsageEvent(OwnerFullName ownerFullName, Supplier<EventActionInfo<AddressEvent.AddressAction>> actionInfoSupplier) {
        if (!Principals.isFakeIdentityAccountNumber((String)ownerFullName.getAccountNumber())) {
            try {
                ListenerRegistry.getInstance().fireEvent((Event)AddressEvent.with((String)this.getDisplayName(), (OwnerFullName)ownerFullName, (String)Accounts.lookupAccountById((String)ownerFullName.getAccountNumber()).getName(), (EventActionInfo)((EventActionInfo)actionInfoSupplier.get())));
            }
            catch (Throwable e) {
                LOG.error((Object)e, e);
            }
        }
    }

    public abstract class SplitTransition {
        private Transition t;
        private State previous;

        public SplitTransition(Transition t) {
            this.t = t;
            this.previous = Address.this.atomicState != null ? (State)((Object)Address.this.atomicState.getReference()) : State.unallocated;
        }

        private Transition getName() {
            return this.t;
        }

        public abstract void top();

        public abstract void bottom();

        public String toString() {
            State curr = (State)((Object)Address.this.atomicState.getReference());
            boolean mark = Address.this.atomicState.isMarked();
            return String.format("AddressTransition %s:%s(%s)", new Object[]{this.t, this.previous != curr ? (Object)((Object)this.previous) + "->" + (Object)((Object)curr) : this.previous, mark});
        }
    }

    public static enum Transition {
        allocating{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return NOOP.class;
            }
        }
        ,
        unallocating{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return NOOP.class;
            }
        }
        ,
        assigning{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return AssignAddressCallback.class;
            }
        }
        ,
        unassigning{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return UnassignAddressCallback.class;
            }
        }
        ,
        starting{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return NOOP.class;
            }
        }
        ,
        stopping{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return NOOP.class;
            }
        }
        ,
        system{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return NOOP.class;
            }
        }
        ,
        quiescent{

            @Override
            public Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback() {
                return NOOP.class;
            }
        };


        public abstract Class<? extends RemoteCallback<? extends BaseMessage, ? extends BaseMessage>> getCallback();

        public String toString() {
            return this.name();
        }
    }

    public static enum Domain {
        standard,
        vpc;

    }

    public static enum State {
        broken,
        unallocated,
        allocated,
        impending,
        assigned,
        started;

    }
}

