/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.address;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.address.AddressingConfiguration;
import com.eucalyptus.address.AddressingDispatcher;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.cloud.util.NotEnoughResourcesException;
import com.eucalyptus.cluster.Cluster;
import com.eucalyptus.cluster.ClusterState;
import com.eucalyptus.cluster.callback.UnassignAddressCallback;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Predicate;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ClusterAddressInfo;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public abstract class AbstractSystemAddressManager {
    private static final Logger LOG = Logger.getLogger(AbstractSystemAddressManager.class);
    private static final ConcurrentNavigableMap<ClusterAddressInfo, Integer> orphans = new ConcurrentSkipListMap<ClusterAddressInfo, Integer>();
    private static final String ERR_SYS_INSUFFICIENT_ADDRESS_CAPACITY = "InsufficientAddressCapacity";

    public static void clearOrphan(ClusterAddressInfo address) {
        Integer delay = (Integer)orphans.remove(address);
        delay = delay == null ? 0 : delay;
        if (delay > 2) {
            LOG.warn((Object)("Forgetting stale orphan address mapping for " + address.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleOrphan(Cluster cluster, ClusterAddressInfo address) {
        Integer orphanCount = 1;
        orphanCount = (orphanCount = orphans.putIfAbsent(address, orphanCount)) == null ? 1 : orphanCount;
        orphans.put(address, orphanCount + 1);
        EventRecord.caller(ClusterState.class, (EventType)EventType.ADDRESS_STATE, (Object[])new Object[]{"Updated orphaned public ip address: " + LogUtil.dumpObject((Object)address) + " count=" + orphanCount}).debug();
        if (orphanCount > AddressingConfiguration.getInstance().getMaxKillOrphans()) {
            EventRecord.caller(ClusterState.class, (EventType)EventType.ADDRESS_STATE, (Object[])new Object[]{"Unassigning orphaned public ip address: " + LogUtil.dumpObject((Object)address) + " count=" + orphanCount}).warn();
            try {
                Address addr = (Address)Addresses.getInstance().lookup(address.getAddress());
                if (addr.isPending()) {
                    try {
                        addr.clearPending();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    if (addr.isAssigned() && "0.0.0.0".equals(address.getInstanceIp())) {
                        addr.unassign().clearPending();
                        if (addr.isSystemOwned()) {
                            addr.release();
                        }
                    } else if (addr.isAssigned() && !"0.0.0.0".equals(address.getInstanceIp())) {
                        AddressingDispatcher.sendSync(AsyncRequests.newRequest((RemoteCallback)new UnassignAddressCallback(address)), cluster.getConfiguration());
                        if (addr.isSystemOwned()) {
                            addr.release();
                        }
                    } else if (!addr.isAssigned() && addr.isAllocated() && addr.isSystemOwned()) {
                        addr.release();
                    }
                }
                catch (ExecutionException ex) {
                    if (!addr.isAssigned() && addr.isAllocated() && addr.isSystemOwned()) {
                        addr.release();
                    }
                }
            }
            catch (InterruptedException ex) {
                Exceptions.maybeInterrupted((Throwable)ex);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            finally {
                orphans.remove(address);
            }
        }
    }

    public Address allocateNext(OwnerFullName userId, Address.Domain domain) throws NotEnoughResourcesException {
        int numSystemReserved = 0;
        try {
            ConfigurableProperty p = PropertyDirectory.getPropertyEntry((String)"cloud.addresses.systemreservedpublicaddresses");
            if (p != null) {
                numSystemReserved = Integer.parseInt(p.getValue());
            }
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Can't find the 'systemreservedpublicaddresses' property");
            numSystemReserved = 0;
        }
        if (Addresses.getInstance().listDisabledValues().size() - numSystemReserved < 1) {
            throw new NotEnoughResourcesException(ERR_SYS_INSUFFICIENT_ADDRESS_CAPACITY);
        }
        Predicate predicate = RestrictedTypes.filterPrivileged();
        Address addr = Addresses.getInstance().enableFirst((Predicate<Address>)predicate).allocate(userId, domain);
        LOG.debug((Object)("Allocated address for public addressing: " + String.valueOf((Object)addr)));
        if (addr == null) {
            LOG.debug((Object)LogUtil.header((String)Addresses.getInstance().toString()));
            throw new NotEnoughResourcesException(ERR_SYS_INSUFFICIENT_ADDRESS_CAPACITY);
        }
        return addr;
    }

    public abstract void assignSystemAddress(VmInstance var1) throws NotEnoughResourcesException;

    public abstract List<Address> getReservedAddresses();

    public abstract void inheritReservedAddresses(List<Address> var1);

    public final List<Address> allocateSystemAddresses(int count) throws NotEnoughResourcesException {
        return this.onAllocation(this.doAllocateSystemAddresses(count));
    }

    public final Address allocateSystemAddress() throws NotEnoughResourcesException {
        return this.onAllocation(this.doAllocateSystemAddresses(1)).get(0);
    }

    protected List<Address> onAllocation(List<Address> allocated) {
        for (Address address : allocated) {
            AbstractSystemAddressManager.clearOrphan(new ClusterAddressInfo(address.getDisplayName()));
        }
        return allocated;
    }

    protected abstract List<Address> doAllocateSystemAddresses(int var1) throws NotEnoughResourcesException;

    public void update(Iterable<String> addresses) {
        Helper.loadStoredAddresses();
        for (String address : addresses) {
            Helper.lookupOrCreate(address, true);
        }
    }

    public void update(Cluster cluster, List<ClusterAddressInfo> ccList) {
        Helper.loadStoredAddresses();
        for (ClusterAddressInfo addrInfo : ccList) {
            try {
                Address address = Helper.lookupOrCreate(cluster, addrInfo);
                if (address.isAssigned() && !addrInfo.hasMapping() && !address.isPending()) {
                    if (Principals.nobodyFullName().equals(address.getOwner())) {
                        Helper.markAsAllocated(cluster, addrInfo, address);
                    }
                    try {
                        VmInstance vm = VmInstances.lookupByPrivateIp(addrInfo.getInstanceIp());
                        AbstractSystemAddressManager.clearOrphan(addrInfo);
                    }
                    catch (NoSuchElementException e) {
                        try {
                            VmInstances.lookup(address.getInstanceId());
                            AbstractSystemAddressManager.clearOrphan(addrInfo);
                        }
                        catch (NoSuchElementException ex) {
                            InetAddress addr = null;
                            try {
                                addr = Inet4Address.getByName(addrInfo.getInstanceIp());
                            }
                            catch (UnknownHostException e1) {
                                LOG.debug((Object)e1, (Throwable)e1);
                            }
                            if (addr != null && addr.isLoopbackAddress()) continue;
                            AbstractSystemAddressManager.handleOrphan(cluster, addrInfo);
                        }
                    }
                    continue;
                }
                if (!address.isAllocated() || !Principals.nobodyFullName().equals(address.getOwner()) || address.isPending()) continue;
                Helper.markAsAllocated(cluster, addrInfo, address);
            }
            catch (Exception e) {
                LOG.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void doAssignSystemAddress(VmInstance vm) throws NotEnoughResourcesException {
        final String instanceId = vm.getInstanceId();
        final Address addr = this.allocateSystemAddress();
        Callback.Success<BaseMessage> onSuccess = new Callback.Success<BaseMessage>(){

            public void fire(BaseMessage response) {
                Addresses.updatePublicIpByInstanceId(instanceId, addr.getName());
            }
        };
        AddressingDispatcher.dispatch(AsyncRequests.newRequest(addr.assign(vm).getCallback()).then((Callback.Success)onSuccess), vm.getPartition());
    }

    protected static class Helper {
        protected Helper() {
        }

        protected static Address lookupOrCreate(String address) {
            return Helper.lookupOrCreate(address, false);
        }

        protected static Address lookupOrCreate(String address, boolean assign) {
            Address addr = null;
            try {
                addr = (Address)Addresses.getInstance().lookupDisabled(address);
                LOG.trace((Object)("Found address in the inactive set cache: " + (Object)((Object)addr)));
            }
            catch (NoSuchElementException e1) {
                try {
                    addr = (Address)Addresses.getInstance().lookup(address);
                    LOG.trace((Object)("Found address in the active set cache: " + (Object)((Object)addr)));
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (addr == null) {
                VmInstance vm = !assign ? null : Helper.maybeFindVm(null, address, null);
                addr = vm != null ? new Address(Principals.systemFullName(), address, vm.getInstanceUuid(), vm.getInstanceId(), vm.getPrivateAddress()) : new Address(address);
            }
            return addr;
        }

        protected static Address lookupOrCreate(Cluster cluster, ClusterAddressInfo addrInfo) {
            Address addr = null;
            VmInstance vm = null;
            try {
                addr = (Address)Addresses.getInstance().lookupDisabled(addrInfo.getAddress());
                LOG.trace((Object)("Found address in the inactive set cache: " + (Object)((Object)addr)));
            }
            catch (NoSuchElementException e1) {
                try {
                    addr = (Address)Addresses.getInstance().lookup(addrInfo.getAddress());
                    LOG.trace((Object)("Found address in the active set cache: " + (Object)((Object)addr)));
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (addrInfo.hasMapping()) {
                vm = Helper.maybeFindVm(addr != null ? addr.getInstanceId() : null, addrInfo.getAddress(), addrInfo.getInstanceIp());
                if (addr != null && vm != null) {
                    Helper.ensureAllocated(addr, vm);
                    AbstractSystemAddressManager.clearOrphan(addrInfo);
                } else if (addr != null && !addr.isPending() && vm != null && VmInstance.VmStateSet.DONE.apply(vm)) {
                    AbstractSystemAddressManager.handleOrphan(cluster, addrInfo);
                } else if (addr != null && addr.isAssigned() && !addr.isPending() && vm == null) {
                    AbstractSystemAddressManager.handleOrphan(cluster, addrInfo);
                } else if (addr == null && vm != null) {
                    addr = new Address(Principals.systemFullName(), addrInfo.getAddress(), vm.getInstanceUuid(), vm.getInstanceId(), vm.getPrivateAddress());
                    AbstractSystemAddressManager.clearOrphan(addrInfo);
                } else if (addr == null && vm == null) {
                    addr = new Address(addrInfo.getAddress());
                    AbstractSystemAddressManager.handleOrphan(cluster, addrInfo);
                }
            } else if (addr != null && addr.isAssigned() && !addr.isPending()) {
                AbstractSystemAddressManager.handleOrphan(cluster, addrInfo);
            } else if (addr != null && !addr.isAssigned() && !addr.isPending() && addr.isSystemOwned()) {
                try {
                    addr.release();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            } else if (addr != null && Address.Transition.system.equals((Object)addr.getTransition())) {
                AbstractSystemAddressManager.handleOrphan(cluster, addrInfo);
            } else if (addr == null) {
                addr = new Address(addrInfo.getAddress());
                Helper.clearVmState(addrInfo);
            }
            return addr;
        }

        private static void markAsAllocated(Cluster cluster, ClusterAddressInfo addrInfo, Address address) {
            try {
                if (!address.isPending()) {
                    for (VmInstance vm : VmInstances.list(VmInstance.VmState.RUNNING)) {
                        if (!addrInfo.getInstanceIp().equals(vm.getPrivateAddress()) || !VmInstance.VmState.RUNNING.equals(vm.getState())) continue;
                        LOG.warn((Object)("Out of band address state change: " + LogUtil.dumpObject((Object)addrInfo) + " address=" + (Object)((Object)address) + " vm=" + (Object)((Object)vm)));
                        return;
                    }
                }
            }
            catch (IllegalStateException e) {
                LOG.error((Object)e);
            }
        }

        private static void clearAddressCachedState(Address addr) {
            try {
                if (!addr.isPending()) {
                    addr.unassign().clearPending();
                }
            }
            catch (Exception t) {
                LOG.trace((Object)t, (Throwable)t);
            }
        }

        private static void clearVmState(ClusterAddressInfo addrInfo) {
            try {
                VmInstance vm = VmInstances.lookupByPublicIp(addrInfo.getAddress());
                vm.clearPublicAddress();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        private static VmInstance maybeFindVm(String instanceId, String publicIp, String privateIp) {
            VmInstance vm = null;
            if (instanceId != null) {
                try {
                    vm = VmInstances.lookup(instanceId);
                }
                catch (NoSuchElementException ex) {
                    Logs.extreme().error((Object)ex);
                }
            }
            if (vm == null && privateIp != null) {
                try {
                    vm = VmInstances.lookupByPrivateIp(privateIp);
                }
                catch (NoSuchElementException ex) {
                    Logs.extreme().error((Object)ex);
                }
            }
            if (vm == null && publicIp != null) {
                try {
                    vm = VmInstances.lookupByPublicIp(publicIp);
                }
                catch (NoSuchElementException ex) {
                    Logs.extreme().error((Object)ex);
                }
            }
            if (vm != null && VmInstance.VmState.RUNNING.equals(vm.getState()) && publicIp.equals(vm.getPublicAddress())) {
                Logs.extreme().debug((Object)("Candidate vm which claims this address: " + vm.getInstanceId() + " " + vm.getState() + " " + publicIp));
                if (publicIp.equals(vm.getPublicAddress())) {
                    Logs.extreme().debug((Object)("Found vm which claims this address: " + vm.getInstanceId() + " " + vm.getState() + " " + publicIp));
                }
                return vm;
            }
            return null;
        }

        private static void ensureAllocated(Address addr, VmInstance vm) {
            block11: {
                long lastUpdate = addr.lastUpdateMillis();
                if (lastUpdate > 60000L * (long)AddressingConfiguration.getInstance().getOrphanGrace().intValue()) {
                    if (!addr.isAllocated() && !addr.isPending()) {
                        try {
                            if (addr.isAssigned() || addr.isPending()) break block11;
                            addr.pendingAssignment();
                            try {
                                addr.assign(vm).clearPending();
                            }
                            catch (Exception e1) {
                                LOG.debug((Object)e1, (Throwable)e1);
                            }
                        }
                        catch (Exception e1) {
                            LOG.debug((Object)e1, (Throwable)e1);
                        }
                    } else if (!addr.isAssigned() && !addr.isPending()) {
                        try {
                            addr.assign(vm).clearPending();
                        }
                        catch (Exception e1) {
                            LOG.debug((Object)e1, (Throwable)e1);
                        }
                    } else {
                        LOG.debug((Object)("Address usage checked: " + (Object)((Object)addr)));
                    }
                }
            }
        }

        protected static void loadStoredAddresses() {
            Address clusterAddr = new Address();
            EntityTransaction db = Entities.get(Address.class);
            try {
                for (Address addr : Entities.query((Object)((Object)clusterAddr))) {
                    if (Addresses.getInstance().contains(addr.getName())) continue;
                    Entities.evict((Object)((Object)addr));
                    try {
                        addr.init();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
                db.commit();
            }
            catch (Exception e) {
                LOG.debug((Object)e, (Throwable)e);
                db.rollback();
            }
        }
    }
}

