/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.common.policy;

import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.ern.AddressUtil;
import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.ServiceErnBuilder;
import com.eucalyptus.compute.common.policy.Ec2ResourceName;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONException;

public class Ec2ErnBuilder
extends ServiceErnBuilder {
    public static final Pattern RESOURCE_PATTERN = Pattern.compile("([a-z0-9_-]+)/(\\S+)");
    public static final int ARN_PATTERNGROUP_EC2_TYPE = 1;
    public static final int ARN_PATTERNGROUP_EC2_ID = 2;

    public Ec2ErnBuilder() {
        super(Collections.singleton("ec2"));
    }

    public Ern build(String ern, String service, String region, String account, String resource) throws JSONException {
        Matcher matcher = RESOURCE_PATTERN.matcher(resource);
        if (matcher.matches()) {
            String type = matcher.group(1).toLowerCase();
            if (!PolicySpec.EC2_RESOURCES.contains(type)) {
                throw new JSONException("EC2 type '" + type + "' is not supported");
            }
            String id = matcher.group(2).toLowerCase();
            if ("address".equals(type)) {
                AddressUtil.validateAddressRange((String)id);
            }
            if ("keypair".equals(type)) {
                type = "key-pair";
            } else if ("securitygroup".equals(type)) {
                type = "security-group";
            }
            return new Ec2ResourceName(type, id);
        }
        throw new JSONException("'" + ern + "' is not a valid ARN");
    }
}

