/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.common;

import com.eucalyptus.auth.policy.PolicyResourceType;
import com.eucalyptus.bootstrap.SystemIds;
import com.eucalyptus.compute.common.CloudMetadata;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

@PolicyResourceType(value="image")
public interface ImageMetadata
extends CloudMetadata {
    public static final String TYPE_MANIFEST_XPATH = "/manifest/image/type/text()";

    public String getImageName();

    public Type getImageType();

    public Platform getPlatform();

    public Architecture getArchitecture();

    public State getState();

    public static enum Platform {
        linux{

            public String toString() {
                return "";
            }
        }
        ,
        windows{

            public String toString() {
                return this.name();
            }
        };

    }

    public static enum Architecture {
        i386,
        x86_64,
        other;

    }

    public static enum DeviceMappingType {
        root,
        swap,
        suppress,
        ephemeral,
        blockstorage,
        ami;

    }

    public static enum Hypervisor {
        xen,
        kvm,
        other;

    }

    public static enum VirtualizationType {
        paravirtualized{

            public String toString() {
                return "paravirtual";
            }
        }
        ,
        hvm;


        public static Function<String, VirtualizationType> fromString() {
            return FromString.INSTANCE;
        }

        private static enum FromString implements Function<String, VirtualizationType>
        {
            INSTANCE;


            @Nullable
            public VirtualizationType apply(@Nullable String value) {
                for (VirtualizationType type : VirtualizationType.values()) {
                    if (!type.toString().equals(value) && !type.name().equals(value)) continue;
                    return type;
                }
                return null;
            }
        }
    }

    public static enum ImageFormat {
        fulldisk,
        partitioned;

    }

    public static enum State implements Predicate<ImageMetadata>
    {
        pending("pending"),
        pending_available("available"),
        pending_conversion("available"),
        available("available"),
        failed("failed"),
        deregistered(false, "deregistered"),
        deregistered_cleanup(false, "deregistered"),
        hidden(false, "hidden"),
        unavailable(false, "unavailable");

        private final boolean standardState;
        private final String externalStateName;

        private State(String externalStateName) {
            this(true, externalStateName);
        }

        private State(boolean standardState, String externalStateName) {
            this.standardState = standardState;
            this.externalStateName = externalStateName;
        }

        public boolean standardState() {
            return this.standardState;
        }

        public boolean apply(@Nullable ImageMetadata input) {
            return input != null && this == input.getState();
        }

        public String getExternalStateName() {
            return this.externalStateName;
        }
    }

    public static enum Type {
        machine{

            @Override
            public String getTypePrefix() {
                return "emi";
            }

            @Override
            public String getManifestPath() {
                return ImageMetadata.TYPE_MANIFEST_XPATH;
            }
        }
        ,
        kernel{

            @Override
            public String getTypePrefix() {
                return "eki";
            }

            @Override
            public String getNamePrefix() {
                return "vmlinuz";
            }

            @Override
            public String getManifestPath() {
                return "/manifest/machine_configuration/kernel_id/text()";
            }
        }
        ,
        ramdisk{

            @Override
            public String getTypePrefix() {
                return "eri";
            }

            @Override
            public String getNamePrefix() {
                return "initrd";
            }

            @Override
            public String getManifestPath() {
                return "/manifest/machine_configuration/ramdisk_id/text()";
            }
        };


        public abstract String getTypePrefix();

        public abstract String getManifestPath();

        public String getNamePrefix() {
            return SystemIds.cloudName();
        }
    }
}

