/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.common;

import com.eucalyptus.util.RestrictedTypes;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class CloudMetadatas
extends RestrictedTypes {
    public static final Pattern ID_IMAGE = Pattern.compile("[ae](ki-|mi-|ri-)[0-9a-fA-F]{8}");
    public static final Pattern ID_KERNEL_IMAGE = Pattern.compile("[ae]ki-[0-9a-fA-F]{8}");
    public static final Pattern ID_MACHINE_IMAGE = Pattern.compile("[ae]mi-[0-9a-fA-F]{8}");
    public static final Pattern ID_RAMDISK_IMAGE = Pattern.compile("[ae]ri-[0-9a-fA-F]{8}");

    public static boolean isImageIdentifier(@Nullable String identifier) {
        return identifier != null && ID_IMAGE.matcher(identifier).matches();
    }

    public static boolean isKernelImageIdentifier(@Nullable String identifier) {
        return identifier != null && ID_KERNEL_IMAGE.matcher(identifier).matches();
    }

    public static boolean isMachineImageIdentifier(@Nullable String identifier) {
        return identifier != null && ID_MACHINE_IMAGE.matcher(identifier).matches();
    }

    public static boolean isRamdiskImageIdentifier(@Nullable String identifier) {
        return identifier != null && ID_RAMDISK_IMAGE.matcher(identifier).matches();
    }
}

