/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.dns.resolvers;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.Subnets;
import com.eucalyptus.util.dns.DnsResolvers;
import com.eucalyptus.util.dns.DomainNameRecords;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.dns.InstanceDomainNames;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;

@ConfigurableClass(root="dns.recursive", description="Options controlling recursive DNS resolution and caching.")
public class RecursiveDnsResolver
implements DnsResolvers.DnsResolver {
    private static Logger LOG = Logger.getLogger(RecursiveDnsResolver.class);
    @ConfigurableField(description="Enable the recursive DNS resolver.  Note: dns.enable must also be 'true'")
    public static Boolean enabled = Boolean.TRUE;

    private static List<Name> subdomainsForName(Name name) {
        ArrayList names = Lists.newArrayList((Object[])new Name[]{name});
        String sub = RecursiveDnsResolver.parentDomainForName(name);
        if (sub.equals("") || sub.equals(".")) {
            names.add(Name.fromConstantString((String)"."));
        } else {
            names.addAll(RecursiveDnsResolver.subdomainsForName(Name.fromConstantString((String)sub)));
        }
        return names;
    }

    private static String parentDomainForName(Name name) {
        return name.toString().replaceAll("\\A[^\\.]+\\.", "");
    }

    private static List<Record> lookupNSRecords(Name name, Cache cache) {
        List<Name> subdomains = RecursiveDnsResolver.subdomainsForName(name);
        for (Name sub : subdomains) {
            Lookup aLookup = new Lookup(sub, 2);
            aLookup.setCache(cache);
            Record[] answers = aLookup.run();
            if (answers == null || answers.length == 0) continue;
            return Arrays.asList(answers);
        }
        return Lists.newArrayList();
    }

    public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
        Iterator rrs;
        SetResponse sr;
        Record query = request.getQuery();
        Name name = query.getName();
        int type = query.getType();
        Cache cache = new Cache();
        Lookup aLookup = new Lookup(name, type);
        aLookup.setCache(cache);
        Record[] found = aLookup.run();
        List<Record> queriedrrs = Arrays.asList(found != null ? found : new Record[]{});
        ArrayList cnames = aLookup.getAliases().length > 0 ? Arrays.asList(aLookup.getAliases()) : Lists.newArrayList();
        LinkedHashSet answer = Sets.newLinkedHashSet();
        LinkedHashSet authority = Sets.newLinkedHashSet();
        LinkedHashSet additional = Sets.newLinkedHashSet();
        boolean iamAuthority = false;
        for (Record aRec : queriedrrs) {
            List<Record> nsRecs = RecursiveDnsResolver.lookupNSRecords(aRec.getName(), cache);
            for (Record nsRec : nsRecs) {
                if (nsRec.getName().equals((Object)DomainNames.externalSubdomain())) {
                    iamAuthority = true;
                }
                authority.add(nsRec);
                Lookup nsLookup = new Lookup(((NSRecord)nsRec).getTarget(), type);
                nsLookup.setCache(cache);
                Record[] nsAnswers = nsLookup.run();
                if (nsAnswers == null) continue;
                additional.addAll(Arrays.asList(nsAnswers));
            }
        }
        for (Name cnameRec : cnames) {
            sr = cache.lookupRecords(cnameRec, 5, 1);
            if (sr == null || !sr.isSuccessful() || sr.answers() == null) continue;
            for (RRset result : sr.answers()) {
                rrs = result.rrs(false);
                if (rrs == null) continue;
                for (Object record : ImmutableSet.copyOf((Iterator)rrs)) {
                    answer.add((Record)record);
                }
            }
        }
        for (Record queriedRec : queriedrrs) {
            sr = cache.lookupRecords(queriedRec.getName(), queriedRec.getType(), 1);
            if (sr == null || !sr.isSuccessful() || sr.answers() == null) continue;
            for (RRset result : sr.answers()) {
                rrs = result.rrs(false);
                if (rrs == null) continue;
                for (Object record : ImmutableSet.copyOf((Iterator)rrs)) {
                    if (iamAuthority && DomainNames.isExternalSubdomain((Name)((Record)record).getName())) {
                        Name resolvedName = ((Record)record).getName();
                        Name instanceDomain = InstanceDomainNames.lookupInstanceDomain((Name)resolvedName);
                        InetAddress publicIp = InstanceDomainNames.toInetAddress((Name)resolvedName.relativize(instanceDomain));
                        try {
                            VmInstance vm = VmInstances.lookupByPublicIp((String)publicIp.getHostAddress());
                            InetAddress instanceAddress = InetAddresses.forString((String)vm.getPrivateAddress());
                            Record privateARecord = DomainNameRecords.addressRecord((Name)resolvedName, (InetAddress)instanceAddress);
                            answer.add(privateARecord);
                        }
                        catch (Exception ex) {
                            answer.add((Record)record);
                        }
                        continue;
                    }
                    answer.add((Record)record);
                }
            }
        }
        if ((aLookup.getResult() == 0 || aLookup.getResult() == 4) && queriedrrs.size() == 0) {
            List<Record> nsRecs = RecursiveDnsResolver.lookupNSRecords(name, cache);
            for (Record nsRec : nsRecs) {
                authority.add(nsRec);
            }
        }
        DnsResolvers.DnsResponse response = DnsResolvers.DnsResponse.forName((Name)query.getName()).recursive().withAuthority((List)Lists.newArrayList((Iterable)authority)).withAdditional((List)Lists.newArrayList((Iterable)additional)).answer((List)Lists.newArrayList((Iterable)answer));
        if (aLookup.getResult() == 3 && queriedrrs.size() == 0) {
            response = DnsResolvers.DnsResponse.forName((Name)query.getName()).recursive().withAuthority((List)Lists.newArrayList((Iterable)authority)).nxdomain();
        }
        return response;
    }

    public boolean checkAccepts(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        InetAddress source = request.getRemoteAddress();
        if (!(Bootstrap.isOperational().booleanValue() && enabled.booleanValue() && Subnets.isSystemManagedAddress((InetAddress)source))) {
            return false;
        }
        if ((DnsResolvers.RequestType.A.apply(query) || DnsResolvers.RequestType.AAAA.apply(query) || DnsResolvers.RequestType.MX.apply(query)) && query.getName().isAbsolute() && !DomainNames.isSystemSubdomain((Name)query.getName())) {
            return true;
        }
        return DnsResolvers.RequestType.PTR.apply(query) && !Subnets.isSystemManagedAddress((InetAddress)DomainNameRecords.inAddrArpaToInetAddress((Name)query.getName()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

