/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.dns;

import com.eucalyptus.dns.Zone;
import com.eucalyptus.util.Internets;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.ws.StackConfiguration;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TextParseException;

public class TransientZone
extends Zone {
    private static Logger LOG = Logger.getLogger(TransientZone.class);
    private static int ttl = 604800;
    private static Zone INSTANCE_EXTERNAL = null;
    private static Zone INSTANCE_INTERNAL = null;

    public TransientZone(Name name, Record[] records) throws IOException {
        super(name, records);
    }

    public static Zone getInstanceExternalZone() {
        try {
            Name name = TransientZone.getExternalName();
            Name host = Name.fromString((String)("root." + name.toString()));
            Name admin = Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + "." + name.toString()));
            Name target = Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + "."));
            long serial = 1L;
            long refresh = 86400L;
            long retry = ttl;
            long expires = 2419200L;
            long minimum = 600L;
            SOARecord soarec = new SOARecord(name, 1, (long)ttl, host, admin, serial, refresh, retry, expires, minimum);
            long nsTTL = 604800L;
            NSRecord nsrec = new NSRecord(name, 1, nsTTL, target);
            return new TransientZone(name, new Record[]{soarec, nsrec});
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static Name getExternalName() throws TextParseException {
        String externalNameString = VmInstances.INSTANCE_SUBDOMAIN + "." + SystemConfiguration.getSystemConfiguration().getDnsDomain() + ".";
        externalNameString = externalNameString.startsWith(".") ? externalNameString.replaceFirst("\\.", "") : externalNameString;
        Name externalName = Name.fromString((String)externalNameString);
        return externalName;
    }

    public static Zone getInstanceInternalZone() {
        try {
            Name name = TransientZone.getInternalName();
            Name host = Name.fromString((String)("root." + name.toString()));
            Name admin = Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + "." + name.toString()));
            Name target = Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + "."));
            long serial = 1L;
            long refresh = 86400L;
            long retry = ttl;
            long expires = 2419200L;
            long minimum = 600L;
            SOARecord soarec = new SOARecord(name, 1, (long)ttl, host, admin, serial, refresh, retry, expires, minimum);
            long nsTTL = 604800L;
            NSRecord nsrec = new NSRecord(name, 1, nsTTL, target);
            return new TransientZone(name, new Record[]{soarec, nsrec});
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static Name getInternalName() throws TextParseException {
        String internalNameString = VmInstances.INSTANCE_SUBDOMAIN + ".internal.";
        internalNameString = internalNameString.startsWith(".") ? internalNameString.replaceFirst("\\.", "") : internalNameString;
        Name internalName = Name.fromString((String)internalNameString);
        return internalName;
    }

    @Override
    public SetResponse findRecords(Name name, int type, InetAddress listenerAddress) {
        if (type == 28) {
            return SetResponse.ofType((int)6);
        }
        if (StackConfiguration.USE_INSTANCE_DNS.booleanValue() && name.toString().matches("euca-.+{3}-.+{3}-.+{3}-.+{3}\\..*")) {
            try {
                String ipCandidate;
                block14: {
                    String[] tryIp = name.toString().replaceAll("euca-", "").replaceAll(VmInstances.INSTANCE_SUBDOMAIN + ".*", "").split("-");
                    if (tryIp.length < 4) {
                        return super.findRecords(name, type, listenerAddress);
                    }
                    ipCandidate = new StringBuffer().append(tryIp[0]).append(".").append(tryIp[1]).append(".").append(tryIp[2]).append(".").append(tryIp[3]).toString();
                    try {
                        VmInstances.lookupByPublicIp((String)ipCandidate);
                    }
                    catch (Exception e) {
                        if (VmInstances.privateIpInUse((String)ipCandidate)) break block14;
                        return super.findRecords(name, type, listenerAddress);
                    }
                }
                InetAddress ip = InetAddress.getByName(ipCandidate);
                SetResponse resp = new SetResponse(6);
                resp.addRRset(new RRset((Record)new ARecord(name, 1, (long)ttl, ip)));
                return resp;
            }
            catch (Exception e) {
                return super.findRecords(name, type, listenerAddress);
            }
        }
        if (StackConfiguration.USE_INSTANCE_DNS.booleanValue() && name.toString().endsWith(".in-addr.arpa.")) {
            int index = name.toString().indexOf(".in-addr.arpa.");
            if (index > 0) {
                Name target;
                String ipString = name.toString().substring(0, index);
                String[] parts = ipString.split("\\.");
                if (parts.length != 4) {
                    return super.findRecords(name, type, listenerAddress);
                }
                String ipCandidate = new StringBuffer().append(parts[3]).append(".").append(parts[2]).append(".").append(parts[1]).append(".").append(parts[0]).toString();
                try {
                    VmInstance instance = VmInstances.lookupByPublicIp((String)ipCandidate);
                    target = new Name(instance.getPublicDnsName() + ".");
                }
                catch (Exception e) {
                    try {
                        VmInstance instance = VmInstances.lookupByPrivateIp((String)ipCandidate);
                        target = new Name(instance.getPrivateDnsName() + ".");
                    }
                    catch (Exception e1) {
                        return super.findRecords(name, type, listenerAddress);
                    }
                }
                SetResponse resp = new SetResponse(6);
                resp.addRRset(new RRset((Record)new PTRRecord(name, 1, (long)ttl, target)));
                return resp;
            }
            return super.findRecords(name, type, listenerAddress);
        }
        return super.findRecords(name, type, listenerAddress);
    }

    public static Zone getPtrZone(Name queryName) {
        try {
            String[] parts;
            String nameString = queryName.toString();
            int index = nameString.indexOf(".in-addr.arpa.");
            if (index > 0) {
                String ipString = nameString.substring(0, index);
                parts = ipString.split("\\.");
                if (parts.length != 4) {
                    return null;
                }
            } else {
                return null;
            }
            nameString = nameString.substring(parts[0].length() + 1);
            Name name = new Name(nameString);
            long serial = 1L;
            long refresh = 86400L;
            long retry = ttl;
            long expires = 2419200L;
            long minimum = 600L;
            SOARecord soarec = new SOARecord(name, 1, (long)ttl, name, Name.fromString((String)("root." + name.toString())), serial, refresh, retry, expires, minimum);
            long nsTTL = 604800L;
            NSRecord nsrec = new NSRecord(name, 1, nsTTL, Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + ".")));
            return new TransientZone(name, new Record[]{soarec, nsrec});
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

