/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.dns;

import com.eucalyptus.dns.Zone;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmNetworkConfig;
import com.eucalyptus.ws.StackConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;

public class TransientPtrZone
extends Zone {
    private static Logger LOG = Logger.getLogger(TransientPtrZone.class);
    private static int ttl = 604800;

    public TransientPtrZone(Name name, Record[] records) throws IOException {
        super(name, records);
    }

    @Override
    public SetResponse findRecords(Name name, int type, InetAddress listenerAddress) {
        if (StackConfiguration.USE_INSTANCE_DNS.booleanValue() && name.toString().endsWith(".in-addr.arpa.")) {
            int index = name.toString().indexOf(".in-addr.arpa.");
            if (index > 0) {
                Name target;
                String ipString = name.toString().substring(0, index);
                String[] parts = ipString.split("\\.");
                if (parts.length != 4) {
                    return super.findRecords(name, type, listenerAddress);
                }
                String ipCandidate = new StringBuffer().append(parts[3]).append(".").append(parts[2]).append(".").append(parts[1]).append(".").append(parts[0]).toString();
                try {
                    VmInstance instance = VmInstances.lookupByPublicIp((String)ipCandidate);
                    target = new Name(instance.getPublicDnsName() + ".");
                }
                catch (Exception e) {
                    if (VmInstances.privateIpInUse((String)ipCandidate)) {
                        try {
                            target = new Name(VmNetworkConfig.generateDnsName((String)ipCandidate, (Name)DomainNames.internalSubdomain()) + ".");
                        }
                        catch (Exception e1) {
                            return super.findRecords(name, type, listenerAddress);
                        }
                    }
                    return super.findRecords(name, type, listenerAddress);
                }
                SetResponse resp = new SetResponse(6);
                resp.addRRset(new RRset((Record)new PTRRecord(name, 1, (long)ttl, target)));
                return resp;
            }
            return super.findRecords(name, type, listenerAddress);
        }
        return super.findRecords(name, type, listenerAddress);
    }

    public static Zone getPtrZone(Name queryName) {
        try {
            String[] parts;
            String nameString = queryName.toString();
            int index = nameString.indexOf(".in-addr.arpa.");
            if (index > 0) {
                String ipString = nameString.substring(0, index);
                parts = ipString.split("\\.");
                if (parts.length != 4) {
                    return null;
                }
            } else {
                return null;
            }
            nameString = nameString.substring(parts[0].length() + 1);
            Name name = new Name(nameString);
            long serial = 1L;
            long refresh = 86400L;
            long retry = ttl;
            long expires = 2419200L;
            long minimum = 600L;
            SOARecord soarec = new SOARecord(name, 1, (long)ttl, name, Name.fromString((String)("root." + name.toString())), serial, refresh, retry, expires, minimum);
            long nsTTL = 604800L;
            NSRecord nsrec = new NSRecord(name, 1, nsTTL, Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + ".")));
            return new TransientPtrZone(name, new Record[]{soarec, nsrec});
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

