/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.dns;

import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.cloudwatch.common.CloudWatch;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.TopologyDnsResolver;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.component.id.Tokens;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.dns.Zone;
import com.eucalyptus.loadbalancing.common.LoadBalancing;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Internets;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TextParseException;

public class ServiceZone
extends Zone {
    private static Logger LOG = Logger.getLogger(ServiceZone.class);
    private static int ttl = 604800;

    public ServiceZone(Name name, Record[] records) throws IOException {
        super(name, records);
    }

    public static Zone getZone() {
        try {
            Name name = ServiceZone.getName();
            Name host = Name.fromString((String)("root." + name.toString()));
            Name admin = Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + "." + name.toString()));
            Name target = Name.fromString((String)(Internets.localHostInetAddress().getCanonicalHostName() + "."));
            long serial = 1L;
            long refresh = 86400L;
            long retry = ttl;
            long expires = 2419200L;
            long minimum = 600L;
            SOARecord soarec = new SOARecord(name, 1, (long)ttl, host, admin, serial, refresh, retry, expires, minimum);
            long nsTTL = 604800L;
            NSRecord nsrec = new NSRecord(name, 1, nsTTL, target);
            return new ServiceZone(name, new Record[]{soarec, nsrec});
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static Name getName() throws TextParseException {
        String nameString = SystemConfiguration.getSystemConfiguration().getDnsDomain() + ".";
        nameString = nameString.startsWith(".") ? nameString.replaceFirst("\\.", "") : nameString;
        Name name = Name.fromString((String)nameString);
        return name;
    }

    @Override
    public SetResponse findRecords(Name name, int type, InetAddress listenerAddress) {
        if (type == 28) {
            return SetResponse.ofType((int)6);
        }
        String nameString = name.toString();
        if (nameString.startsWith("autoscaling.")) {
            return this.buildResponseForComponent(name, type, listenerAddress, AutoScaling.class);
        }
        if (nameString.startsWith("cloudwatch.")) {
            return this.buildResponseForComponent(name, type, listenerAddress, CloudWatch.class);
        }
        if (nameString.startsWith("compute.") || nameString.startsWith("eucalyptus.")) {
            return this.buildResponseForComponent(name, type, listenerAddress, Compute.class);
        }
        if (nameString.startsWith("euare.")) {
            return this.buildResponseForComponent(name, type, listenerAddress, Euare.class);
        }
        if (nameString.startsWith("loadbalancing.")) {
            return this.buildResponseForComponent(name, type, listenerAddress, LoadBalancing.class);
        }
        if (nameString.startsWith("objectstorage.") || nameString.matches(".*\\.objectstorage\\..*") || nameString.startsWith("walrus.") || nameString.matches(".*\\.walrus\\..*")) {
            SetResponse resp = new SetResponse(6);
            try {
                List<InetAddress> osgIps = ObjectStorageAddresses.getObjectStorageAddress();
                for (InetAddress osgIp : osgIps) {
                    resp.addRRset(new RRset((Record)new ARecord(name, 1, 20L, TopologyDnsResolver.maphost((InetAddress)listenerAddress, (InetAddress)osgIp))));
                }
            }
            catch (EucalyptusCloudException e) {
                LOG.error((Object)e);
                return super.findRecords(name, type, listenerAddress);
            }
            return resp;
        }
        if (nameString.startsWith("tokens.")) {
            return this.buildResponseForComponent(name, type, listenerAddress, Tokens.class);
        }
        return super.findRecords(name, type, listenerAddress);
    }

    private SetResponse buildResponseForComponent(Name name, int type, InetAddress listenerAddress, Class<? extends ComponentId> componentClass) {
        try {
            SetResponse resp = new SetResponse(6);
            ArrayList configurations = Lists.newArrayList((Iterable)Topology.lookupMany(componentClass, (Partition[])new Partition[0]));
            Collections.shuffle(configurations);
            for (ServiceConfiguration configuration : configurations) {
                resp.addRRset(new RRset((Record)new ARecord(name, 1, 20L, TopologyDnsResolver.maphost((InetAddress)listenerAddress, (InetAddress)configuration.getInetAddress()))));
            }
            return resp;
        }
        catch (Exception e) {
            return super.findRecords(name, type, listenerAddress);
        }
    }

    private static class ObjectStorageAddresses {
        private static Iterator<ServiceConfiguration> rrStores;
        private static Iterable<ServiceConfiguration> currentStores;

        private ObjectStorageAddresses() {
        }

        public static List<InetAddress> getObjectStorageAddress() throws EucalyptusCloudException {
            if (Topology.isEnabled(ObjectStorage.class)) {
                Iterable newStores = Topology.lookupMany(ObjectStorage.class, (Partition[])new Partition[0]);
                ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
                if (rrStores == null || !Iterables.elementsEqual(currentStores, (Iterable)newStores)) {
                    currentStores = newStores;
                    rrStores = Iterators.cycle(currentStores);
                }
                Iterator<ServiceConfiguration> current = currentStores.iterator();
                while (current.hasNext()) {
                    current.next();
                    addresses.add(rrStores.next().getInetAddress());
                }
                return addresses;
            }
            throw new EucalyptusCloudException("ObjectStorage not ENABLED");
        }
    }
}

