/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.dns.ServiceZone;
import com.eucalyptus.dns.TransientZone;
import com.eucalyptus.dns.Zone;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.DNSProperties;
import edu.ucsb.eucalyptus.cloud.entities.ARecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.CNAMERecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.NSRecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.SOARecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.ZoneInfo;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;

public class ZoneManager {
    private static ConcurrentHashMap<Name, Zone> zones = new ConcurrentHashMap();
    private static Logger LOG = Logger.getLogger(ZoneManager.class);

    public static Zone getZone(String name) {
        try {
            return ZoneManager.getZone(new Name(name));
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    public static Zone getZone(Name name) {
        if (Bootstrap.isFinished().booleanValue()) {
            if (name.toString().endsWith("in-addr.arpa.")) {
                return TransientZone.getPtrZone(name);
            }
            try {
                if (!zones.containsKey(TransientZone.getExternalName())) {
                    ZoneManager.registerZone(TransientZone.getExternalName(), TransientZone.getInstanceExternalZone());
                } else if (!zones.containsKey(TransientZone.getInternalName())) {
                    ZoneManager.registerZone(TransientZone.getInternalName(), TransientZone.getInstanceInternalZone());
                } else if (!zones.containsKey(ServiceZone.getName())) {
                    ZoneManager.registerZone(ServiceZone.getName(), ServiceZone.getZone());
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e, (Throwable)e);
            }
            return zones.get(name);
        }
        return null;
    }

    public static void registerZone(Name name, Zone z) {
        zones.putIfAbsent(name, z);
    }

    public static void addZone(ZoneInfo zoneInfo, SOARecordInfo soaRecordInfo, NSRecordInfo nsRecordInfo) {
        try {
            String nameString = zoneInfo.getName();
            Name name = Name.fromString((String)nameString);
            long soaTTL = soaRecordInfo.getTtl();
            long serial = soaRecordInfo.getSerialNumber();
            long refresh = soaRecordInfo.getRefresh();
            long retry = soaRecordInfo.getRetry();
            long expires = soaRecordInfo.getExpires();
            long minimum = soaRecordInfo.getMinimum();
            SOARecord soarec = new SOARecord(name, 1, soaTTL, name, Name.fromString((String)("root." + name.toString())), serial, refresh, retry, expires, minimum);
            long nsTTL = nsRecordInfo.getTtl();
            NSRecord nsrec = new NSRecord(name, 1, nsTTL, Name.fromString((String)nsRecordInfo.getTarget()));
            Zone zone = new Zone(name, new Record[]{soarec, nsrec});
            zones.putIfAbsent(name, zone);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    public static void addRecord(ARecordInfo arecInfo, boolean multiRec) {
        try {
            ARecord arecord = new ARecord(Name.fromString((String)arecInfo.getName()), 1, arecInfo.getTtl().longValue(), Address.getByAddress((String)arecInfo.getAddress()));
            ZoneManager.addRecord(arecInfo.getZone(), (Record)arecord, multiRec);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    public static void addRecord(String nameString, Record record, boolean multiRec) {
        block17: {
            Zone zone = ZoneManager.getZone(nameString);
            if (zone == null) {
                try {
                    Record[] records = new Record[]{record};
                    Name name = Name.fromString((String)nameString);
                    long soaTTL = 604800L;
                    long serial = 1L;
                    long refresh = 604800L;
                    long retry = 86400L;
                    long expires = 2419200L;
                    long minimum = 604800L;
                    SOARecord soarec = new SOARecord(name, 1, soaTTL, name, Name.fromString((String)("root." + nameString)), serial, refresh, retry, expires, minimum);
                    long nsTTL = soaTTL;
                    String nsHost = DNSProperties.NS_HOST + ".";
                    Name nsName = Name.fromString((String)nsHost);
                    NSRecord nsrec = new NSRecord(name, 1, nsTTL, nsName);
                    ARecord nsARecord = new ARecord(nsName, 1, nsTTL, Address.getByAddress((String)DNSProperties.NS_IP));
                    zone = new Zone(name, new Record[]{soarec, nsrec, nsARecord, record});
                    zone = zones.putIfAbsent(name, zone);
                    if (zone != null) break block17;
                    zone = zones.get(name);
                    try (TransactionResource db = Entities.transactionFor(ZoneInfo.class);){
                        ZoneInfo zoneInfo = new ZoneInfo(nameString);
                        Entities.persist((Object)zoneInfo);
                        SOARecordInfo soaRecordInfo = new SOARecordInfo();
                        soaRecordInfo.setName(nameString);
                        soaRecordInfo.setRecordclass(Integer.valueOf(1));
                        soaRecordInfo.setNameserver(nameString);
                        soaRecordInfo.setAdmin("root." + nameString);
                        soaRecordInfo.setZone(nameString);
                        soaRecordInfo.setSerialNumber(Long.valueOf(serial));
                        soaRecordInfo.setTtl(Long.valueOf(soaTTL));
                        soaRecordInfo.setExpires(Long.valueOf(expires));
                        soaRecordInfo.setMinimum(Long.valueOf(minimum));
                        soaRecordInfo.setRefresh(Long.valueOf(refresh));
                        soaRecordInfo.setRetry(Long.valueOf(retry));
                        Entities.persist((Object)soaRecordInfo);
                        NSRecordInfo nsRecordInfo = new NSRecordInfo();
                        nsRecordInfo.setName(nameString);
                        nsRecordInfo.setZone(nameString);
                        nsRecordInfo.setRecordClass(Integer.valueOf(1));
                        nsRecordInfo.setTarget(nsHost);
                        nsRecordInfo.setTtl(Long.valueOf(nsTTL));
                        Entities.persist((Object)nsRecordInfo);
                        ARecordInfo aRecordInfo = new ARecordInfo();
                        aRecordInfo.setName(nsHost);
                        aRecordInfo.setAddress(DNSProperties.NS_IP);
                        aRecordInfo.setTtl(Long.valueOf(nsTTL));
                        aRecordInfo.setZone(nameString);
                        aRecordInfo.setRecordclass(Integer.valueOf(1));
                        Entities.persist((Object)aRecordInfo);
                        db.commit();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            } else if (multiRec || zone.findExactMatch(record.getName(), record.getType()) == null) {
                zone.addRecord(record);
            }
        }
    }

    public static void updateARecord(String zoneName, ARecord record) {
        block18: {
            try {
                Zone zone = ZoneManager.getZone(zoneName);
                if (zone == null) {
                    return;
                }
                RRset rrSet = zone.findExactMatch(record.getName(), record.getDClass());
                if (rrSet == null) break block18;
                Iterator rrIterator = rrSet.rrs();
                Record recordToRemove = null;
                while (rrIterator.hasNext()) {
                    Record rec = (Record)rrIterator.next();
                    if (!rec.getName().equals((Object)record.getName())) continue;
                    recordToRemove = rec;
                }
                if (recordToRemove != null) {
                    zone.removeRecord(recordToRemove);
                }
                zone.addRecord((Record)record);
                try (TransactionResource db = Entities.transactionFor(ARecordInfo.class);){
                    ARecordInfo arecInfo = new ARecordInfo();
                    arecInfo.setZone(zoneName);
                    arecInfo.setName(record.getName().toString());
                    ARecordInfo foundARecInfo = (ARecordInfo)Entities.uniqueResult((Object)arecInfo);
                    foundARecInfo.setName(record.getName().toString());
                    InetAddress address = record.getAddress();
                    if (address != null) {
                        foundARecInfo.setAddress(address.toString());
                    }
                    foundARecInfo.setRecordclass(Integer.valueOf(record.getDClass()));
                    foundARecInfo.setTtl(Long.valueOf(record.getTTL()));
                    db.commit();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
    }

    public static void updateCNAMERecord(String zoneName, CNAMERecord record) {
        block17: {
            try {
                Zone zone = ZoneManager.getZone(zoneName);
                if (zone == null) {
                    return;
                }
                RRset rrSet = zone.findExactMatch(record.getName(), record.getDClass());
                if (rrSet == null) break block17;
                Iterator rrIterator = rrSet.rrs();
                Record recordToRemove = null;
                while (rrIterator.hasNext()) {
                    Record rec = (Record)rrIterator.next();
                    if (!rec.getName().equals((Object)record.getName())) continue;
                    recordToRemove = rec;
                }
                if (recordToRemove != null) {
                    zone.removeRecord(recordToRemove);
                }
                zone.addRecord((Record)record);
                try (TransactionResource db = Entities.transactionFor(CNAMERecordInfo.class);){
                    CNAMERecordInfo cnameRecordInfo = new CNAMERecordInfo();
                    cnameRecordInfo.setZone(zoneName);
                    cnameRecordInfo.setName(record.getName().toString());
                    CNAMERecordInfo foundCNAMERecInfo = (CNAMERecordInfo)Entities.uniqueResult((Object)cnameRecordInfo);
                    foundCNAMERecInfo.setName(record.getName().toString());
                    foundCNAMERecInfo.setAlias(record.getAlias().toString());
                    foundCNAMERecInfo.setRecordclass(Integer.valueOf(record.getDClass()));
                    foundCNAMERecInfo.setTtl(Long.valueOf(record.getTTL()));
                    db.commit();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
    }

    public static void deleteARecord(String zoneName, ARecord record) {
        try {
            Zone zone = ZoneManager.getZone(zoneName);
            if (zone == null) {
                return;
            }
            RRset rrSet = zone.findExactMatch(record.getName(), record.getDClass());
            if (rrSet != null) {
                Iterator rrIterator = rrSet.rrs();
                Record recordToRemove = null;
                while (rrIterator.hasNext()) {
                    ARecord aRec;
                    Record rec = (Record)rrIterator.next();
                    if (!(rec instanceof ARecord) || !(aRec = (ARecord)rec).getName().equals((Object)record.getName()) || !aRec.getAddress().equals(record.getAddress())) continue;
                    recordToRemove = rec;
                }
                if (recordToRemove != null) {
                    zone.removeRecord(recordToRemove);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    public static void deleteRecord(String zoneName, Record record) {
        try {
            Zone zone = ZoneManager.getZone(zoneName);
            if (zone == null) {
                return;
            }
            RRset rrSet = zone.findExactMatch(record.getName(), record.getDClass());
            if (rrSet != null) {
                Iterator rrIterator = rrSet.rrs();
                Record recordToRemove = null;
                while (rrIterator.hasNext()) {
                    Record rec = (Record)rrIterator.next();
                    if (!rec.getName().equals((Object)record.getName())) continue;
                    recordToRemove = rec;
                }
                if (recordToRemove != null) {
                    zone.removeRecord(recordToRemove);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    public static void deleteZone(String zoneName) {
        try {
            zones.remove(new Name(zoneName));
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }
}

