/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.cloud.ws.ConnectionHandlerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.log4j.Logger;

public class UDPListener
extends Thread
implements Closeable {
    private static Logger LOG = Logger.getLogger(UDPListener.class);
    InetAddress address;
    int port;
    DatagramSocket socket;

    public UDPListener(InetAddress address, int port) throws IOException {
        this.address = address;
        this.port = port;
        try {
            this.socket = new DatagramSocket(port, address);
            this.socket.setSoTimeout(10000);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw ex;
        }
    }

    @Override
    public void run() {
        if (this.socket != null) {
            ConnectionHandlerFactory.handle(this.socket);
        } else {
            LOG.error((Object)"Cannot start service. Invalid socket.");
        }
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }
}

