/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cloud.ws.ConnectionHandler;
import com.eucalyptus.component.id.Dns;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.system.Threads;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.xbill.DNS.Message;

@ConfigurableClass(root="dns.udp", description="Handles udp listeners.")
public class UDPHandler
extends Thread {
    @ConfigurableField(description="Parameter controlling the number of UDP worker threads.")
    public static Integer num_worker_threads = 128;
    private static Logger LOG = Logger.getLogger(UDPHandler.class);
    DatagramSocket socket;

    UDPHandler(DatagramSocket s) {
        this.socket = s;
    }

    @Override
    public void run() {
        int udpLength = 512;
        while (Bootstrap.isOperational().booleanValue()) {
            if (this.socket.isClosed()) {
                LOG.info((Object)"Exiting due to closed socket");
                return;
            }
            try {
                byte[] in = new byte[512];
                DatagramPacket indp = new DatagramPacket(in, in.length);
                indp.setLength(in.length);
                try {
                    this.socket.receive(indp);
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                try {
                    Threads.enqueue(Dns.class, UDPHandler.class, (Integer)num_worker_threads, (Callable)new UDPWorker(this.socket, indp, in));
                }
                catch (Exception ex) {
                    LOG.error((Object)"failed to run dns UDP worker");
                }
            }
            catch (IOException e) {
                LOG.trace((Object)e);
            }
        }
    }

    private static class UDPWorker
    extends ConnectionHandler
    implements Callable<Boolean> {
        private DatagramSocket socket = null;
        private DatagramPacket packet = null;
        private byte[] data = null;

        private UDPWorker(DatagramSocket socket, DatagramPacket dpin, byte[] data) {
            this.socket = socket;
            this.packet = dpin;
            this.data = data;
        }

        @Override
        public Boolean call() throws Exception {
            byte[] in = this.data;
            byte[] response = null;
            try {
                Message query = new Message(in);
                ConnectionHandler.setLocalAndRemoteInetAddresses(this.socket.getLocalAddress(), this.packet.getAddress());
                try {
                    response = this.generateReply(query, in, this.packet.getLength(), null);
                }
                catch (RuntimeException ex) {
                    response = this.errorMessage(query, 2);
                    throw ex;
                }
                finally {
                    ConnectionHandler.clearInetAddresses();
                }
                if (response == null) {
                    return false;
                }
            }
            catch (Exception e) {
                if (response != null) {
                    response = this.formerrMessage(in);
                }
                LOG.trace((Object)e);
                return false;
            }
            try {
                DatagramPacket outdp = new DatagramPacket(response, response.length, this.packet.getAddress(), this.packet.getPort());
                this.socket.send(outdp);
            }
            catch (Exception e) {
                LOG.trace((Object)e);
            }
            return true;
        }
    }
}

