/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.cloud.ws.TCPHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.log4j.Logger;

public class TCPListener
extends Thread
implements Closeable {
    private static Logger LOG = Logger.getLogger(TCPListener.class);
    InetAddress address;
    int port;
    ServerSocket socket;

    public TCPListener(InetAddress address, int port) throws IOException {
        this.address = address;
        this.port = port;
        try {
            this.socket = new ServerSocket(port, 128, address);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw ex;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (this.socket != null) {
                    LOG.trace((Object)("Listening on port: " + this.port));
                    TCPHandler handler = new TCPHandler(this.socket.accept());
                    handler.start();
                }
                LOG.error((Object)"Cannot start service. Invalid socket.");
                return;
            }
            catch (IOException e) {
                LOG.error((Object)e);
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
    }
}

