/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.cloud.ws.ConnectionHandler;
import com.eucalyptus.component.id.Dns;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.system.Threads;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.xbill.DNS.Message;

@ConfigurableClass(root="dns.tcp", description="Handles dns TCP requests.")
public class TCPHandler
extends ConnectionHandler {
    @ConfigurableField(description="Parameter controlling tcp handler timeout in seconds.")
    public static Integer timeout_seconds = 30;
    private static Logger LOG = Logger.getLogger(TCPHandler.class);
    private final Socket socket;

    public TCPHandler(Socket s) {
        this.socket = s;
    }

    @Override
    public void run() {
        try (final Socket socket = this.socket;){
            socket.setSoTimeout(timeout_seconds * 1000);
            SimpleTimeLimiter limiter = new SimpleTimeLimiter((ExecutorService)Threads.lookup(Dns.class, TCPHandler.class));
            byte[] inBytes = (byte[])limiter.callWithTimeout((Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    DataInputStream inStream = new DataInputStream(socket.getInputStream());
                    int inputLength = inStream.readUnsignedShort();
                    byte[] inBytes = new byte[inputLength];
                    inStream.readFully(inBytes);
                    return inBytes;
                }
            }, (long)timeout_seconds.intValue(), TimeUnit.SECONDS, false);
            byte[] response = null;
            try {
                Message query = new Message(inBytes);
                ConnectionHandler.setLocalAndRemoteInetAddresses(socket.getLocalAddress(), socket.getInetAddress());
                try {
                    response = this.generateReply(query, inBytes, inBytes.length, socket);
                }
                catch (RuntimeException ex) {
                    response = this.errorMessage(query, 2);
                    throw ex;
                }
                finally {
                    ConnectionHandler.clearInetAddresses();
                }
                if (response == null) {
                    return;
                }
            }
            catch (IOException exception) {
                LOG.error((Object)exception);
            }
            DataOutputStream outStream = new DataOutputStream(socket.getOutputStream());
            outStream.writeShort(response.length);
            outStream.write(response);
            outStream.flush();
        }
        catch (UncheckedTimeoutException e) {
            LOG.debug((Object)"Timeout reading request.");
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }
}

