/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cloud.ws.TCPListener;
import com.eucalyptus.cloud.ws.UDPListener;
import com.eucalyptus.cloud.ws.ZoneManager;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Dns;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.objectstorage.exceptions.s3.AccessDeniedException;
import com.eucalyptus.system.Capabilities;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.DNSProperties;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.IO;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.LockResource;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.cloud.entities.ARecordAddressInfo;
import edu.ucsb.eucalyptus.cloud.entities.ARecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.ARecordNameInfo;
import edu.ucsb.eucalyptus.cloud.entities.CNAMERecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.NSRecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.SOARecordInfo;
import edu.ucsb.eucalyptus.cloud.entities.ZoneInfo;
import edu.ucsb.eucalyptus.msgs.AddMultiARecordResponseType;
import edu.ucsb.eucalyptus.msgs.AddMultiARecordType;
import edu.ucsb.eucalyptus.msgs.AddZoneResponseType;
import edu.ucsb.eucalyptus.msgs.AddZoneType;
import edu.ucsb.eucalyptus.msgs.CreateMultiARecordResponseType;
import edu.ucsb.eucalyptus.msgs.CreateMultiARecordType;
import edu.ucsb.eucalyptus.msgs.DeleteZoneResponseType;
import edu.ucsb.eucalyptus.msgs.DeleteZoneType;
import edu.ucsb.eucalyptus.msgs.RemoveARecordResponseType;
import edu.ucsb.eucalyptus.msgs.RemoveARecordType;
import edu.ucsb.eucalyptus.msgs.RemoveCNAMERecordResponseType;
import edu.ucsb.eucalyptus.msgs.RemoveCNAMERecordType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiANameResponseType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiANameType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiARecordResponseType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiARecordType;
import edu.ucsb.eucalyptus.msgs.UpdateARecordResponseType;
import edu.ucsb.eucalyptus.msgs.UpdateARecordType;
import edu.ucsb.eucalyptus.msgs.UpdateCNAMERecordResponseType;
import edu.ucsb.eucalyptus.msgs.UpdateCNAMERecordType;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;

@ConfigurableClass(root="dns", description="Controls dns listeners.")
public class DNSControl {
    private static Logger LOG = Logger.getLogger(DNSControl.class);
    private static final AtomicReference<Collection<Cidr>> addressMatchers = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Collection<UDPListener>> udpListenerRef = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Collection<TCPListener>> tcpListenerRef = new AtomicReference(Collections.emptySet());
    private static final Lock listenerLock = new ReentrantLock();
    @ConfigurableField(displayName="dns_listener_address_match", description="Additional address patterns to listen on for DNS requests.", initial="", readonly=false, changeListener=DnsAddressChangeListener.class)
    public static volatile String dns_listener_address_match = "";
    @ConfigurableField(displayName="server", description="Comma separated list of nameservers, OS settings used if none specified (change requires restart)", initial="", readonly=false, changeListener=DnsServerChangeListener.class)
    public static volatile String server = "";
    @ConfigurableField(displayName="search", description="Comma separated list of domains to search, OS settings used if none specified (change requires restart)", initial="", readonly=false, changeListener=DnsSearchChangeListener.class)
    public static volatile String search = "";

    private static void updateAddressMatchers(String addressCidrs) throws ConfigurablePropertyException {
        try {
            addressMatchers.set((Collection<Cidr>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)", ;:")).trimResults().omitEmptyStrings().split((CharSequence)addressCidrs), (Function)Cidr.parseUnsafe())));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurablePropertyException(e.getMessage());
        }
    }

    private static void initializeUDP() {
        DNSControl.initializeListeners(udpListenerRef, "UDP", new ListenerBuilder<UDPListener>(){

            @Override
            public UDPListener build(InetAddress address, int port) throws IOException {
                return new UDPListener(address, port);
            }
        });
    }

    private static void initializeTCP() {
        DNSControl.initializeListeners(tcpListenerRef, "TCP", new ListenerBuilder<TCPListener>(){

            @Override
            public TCPListener build(InetAddress address, int port) throws IOException {
                return new TCPListener(address, port);
            }
        });
    }

    private static <T extends Thread> void initializeListeners(AtomicReference<Collection<T>> listenerRef, String description, final ListenerBuilder<T> builder) {
        try (LockResource lock = LockResource.lock((Lock)listenerLock);){
            if (listenerRef.get().isEmpty()) {
                final int listenPort = DNSProperties.PORT;
                LinkedHashSet listenAddresses = Sets.newLinkedHashSet();
                listenAddresses.add(Internets.localHostInetAddress());
                Iterables.addAll((Collection)listenAddresses, (Iterable)Iterables.filter((Iterable)Internets.getAllInetAddresses(), (Predicate)Predicates.or((Iterable)addressMatchers.get())));
                LOG.info((Object)("Starting DNS " + description + " listeners on " + listenAddresses + ":" + listenPort));
                ArrayList listeners = Lists.newArrayList();
                for (final InetAddress listenAddress : listenAddresses) {
                    try {
                        Thread listener = (Thread)Capabilities.runWithCapabilities((Callable)new Callable<T>(){

                            @Override
                            public T call() throws Exception {
                                Thread listener = (Thread)builder.build(listenAddress, listenPort);
                                listener.start();
                                return listener;
                            }
                        });
                        listeners.add(listener);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Error starting DNS " + description + " listener on " + listenAddress + ":" + listenPort), (Throwable)ex);
                    }
                }
                listenerRef.set((Collection<T>)ImmutableList.copyOf((Collection)listeners));
            }
        }
    }

    public static void populateRecords() {
        DNSProperties.update();
        try (TransactionResource db = Entities.transactionFor(ZoneInfo.class);){
            List zoneInfos = Entities.query((Object)new ZoneInfo());
            for (ZoneInfo zoneInfo : zoneInfos) {
                String name = zoneInfo.getName();
                SOARecordInfo searchSOARecordInfo = new SOARecordInfo();
                searchSOARecordInfo.setName(name);
                SOARecordInfo soaRecordInfo = (SOARecordInfo)Entities.uniqueResult((Object)searchSOARecordInfo);
                NSRecordInfo searchNSRecordInfo = new NSRecordInfo();
                searchNSRecordInfo.setName(name);
                NSRecordInfo nsRecordInfo = (NSRecordInfo)Entities.uniqueResult((Object)searchNSRecordInfo);
                ZoneManager.addZone(zoneInfo, soaRecordInfo, nsRecordInfo);
            }
            ARecordInfo searchARecInfo = new ARecordInfo();
            List aRecInfos = Entities.query((Object)searchARecInfo);
            for (ARecordInfo aRecInfo : aRecInfos) {
                ZoneManager.addRecord(aRecInfo, false);
            }
            db.commit();
        }
        catch (TransactionException | NoSuchElementException ex) {
            LOG.error((Object)ex);
        }
        EntityTransaction db2 = Entities.get(ARecordNameInfo.class);
        try {
            int count = 0;
            List multiARec = Entities.query((Object)new ARecordNameInfo(), (boolean)true);
            if (multiARec != null && multiARec.size() > 0) {
                for (ARecordNameInfo nameRec : multiARec) {
                    Collection addresses = nameRec.getAddresses();
                    if (addresses == null || addresses.size() <= 0) continue;
                    for (ARecordAddressInfo addrRec : addresses) {
                        ARecord record = new ARecord(new Name(nameRec.getName()), 1, nameRec.getTtl().longValue(), Address.getByAddress((String)addrRec.getAddress()));
                        ZoneManager.addRecord(nameRec.getZone(), (Record)record, true);
                        ++count;
                    }
                }
            }
            LOG.debug((Object)String.format("%d DNS records populated from database", count));
            db2.commit();
        }
        catch (Exception ex) {
            db2.rollback();
            LOG.error((Object)"Failed to populate the existing DNS records", (Throwable)ex);
        }
    }

    public static void initialize() throws Exception {
        try {
            DNSControl.initializeUDP();
            DNSControl.initializeTCP();
            DNSControl.populateRecords();
        }
        catch (Exception ex) {
            LOG.error((Object)"DNS could not be initialized. Is some other service running on port 53?");
            throw ex;
        }
    }

    public static void stop() throws Exception {
        try (LockResource lock = LockResource.lock((Lock)listenerLock);){
            IO.close((Iterable)udpListenerRef.getAndSet(Collections.emptySet()));
            IO.close((Iterable)tcpListenerRef.getAndSet(Collections.emptySet()));
        }
    }

    public static void restart() throws Exception {
        DNSControl.stop();
        DNSControl.initialize();
    }

    public CreateMultiARecordResponseType CreateMultiARecord(CreateMultiARecordType request) throws EucalyptusCloudException {
        CreateMultiARecordResponseType reply = (CreateMultiARecordResponseType)request.getReply();
        String zone = request.getZone();
        zone = zone.endsWith(".") ? zone + DNSProperties.DOMAIN + "." : zone + "." + DNSProperties.DOMAIN + ".";
        String name = request.getName();
        name = name.endsWith(".") ? name + DNSProperties.DOMAIN + "." : name + "." + DNSProperties.DOMAIN + ".";
        long ttl = request.getTtl();
        EntityTransaction db = Entities.get(ARecordNameInfo.class);
        try {
            Entities.uniqueResult((Object)ARecordNameInfo.named((String)name, (String)zone));
            db.commit();
            throw new EucalyptusCloudException("A record with the same name is found");
        }
        catch (NoSuchElementException ex) {
            ARecordNameInfo newInfo = ARecordNameInfo.newInstance((String)name, (String)zone, (Integer)1, (Long)ttl);
            Entities.persist((Object)newInfo);
            db.commit();
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed due to database error");
        }
        return reply;
    }

    public AddMultiARecordResponseType AddMultiARecord(AddMultiARecordType request) throws EucalyptusCloudException {
        AddMultiARecordResponseType reply = (AddMultiARecordResponseType)request.getReply();
        String zone = request.getZone();
        zone = zone.endsWith(".") ? zone + DNSProperties.DOMAIN + "." : zone + "." + DNSProperties.DOMAIN + ".";
        String name = request.getName();
        name = name.endsWith(".") ? name + DNSProperties.DOMAIN + "." : name + "." + DNSProperties.DOMAIN + ".";
        long ttl = request.getTtl();
        String address = request.getAddress();
        EntityTransaction db = Entities.get(ARecordNameInfo.class);
        ARecordNameInfo nameInfo = null;
        try {
            nameInfo = (ARecordNameInfo)Entities.uniqueResult((Object)ARecordNameInfo.named((String)name, (String)zone));
            db.commit();
        }
        catch (NoSuchElementException ex) {
            db.rollback();
            throw new EucalyptusCloudException("No dns record with name=" + name + " is found");
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to query dns name record", (Throwable)ex);
        }
        db = Entities.get(ARecordAddressInfo.class);
        try {
            List exist = Entities.query((Object)ARecordAddressInfo.named((ARecordNameInfo)nameInfo, (String)address));
            if (exist == null || exist.size() <= 0) {
                ARecord record = new ARecord(new Name(name), 1, ttl, Address.getByAddress((String)address));
                ZoneManager.addRecord(zone, (Record)record, true);
                ARecordAddressInfo addrInfo = ARecordAddressInfo.newInstance((ARecordNameInfo)nameInfo, (String)address);
                Entities.persist((Object)addrInfo);
            }
            db.commit();
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to add the record", (Throwable)ex);
        }
        return reply;
    }

    public RemoveMultiARecordResponseType RemoveMultiARecord(RemoveMultiARecordType request) throws EucalyptusCloudException {
        RemoveMultiARecordResponseType reply = (RemoveMultiARecordResponseType)request.getReply();
        String zone = request.getZone();
        zone = zone.endsWith(".") ? zone + DNSProperties.DOMAIN + "." : zone + "." + DNSProperties.DOMAIN + ".";
        String name = request.getName();
        name = name.endsWith(".") ? name + DNSProperties.DOMAIN + "." : name + "." + DNSProperties.DOMAIN + ".";
        String address = request.getAddress();
        EntityTransaction db = Entities.get(ARecordNameInfo.class);
        ARecordNameInfo nameInfo = null;
        try {
            nameInfo = (ARecordNameInfo)Entities.uniqueResult((Object)ARecordNameInfo.named((String)name, (String)zone));
            db.commit();
        }
        catch (NoSuchElementException ex) {
            db.rollback();
            return reply;
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to query dns name record", (Throwable)ex);
        }
        db = Entities.get(ARecordAddressInfo.class);
        ARecordAddressInfo addrInfo = null;
        try {
            addrInfo = (ARecordAddressInfo)Entities.uniqueResult((Object)ARecordAddressInfo.named((ARecordNameInfo)nameInfo, (String)address));
            ARecord arecord = new ARecord(Name.fromString((String)name), 1, nameInfo.getTtl().longValue(), Address.getByAddress((String)addrInfo.getAddress()));
            ZoneManager.deleteARecord(zone, arecord);
            Entities.delete((Object)addrInfo);
            db.commit();
        }
        catch (NoSuchElementException ex) {
            db.rollback();
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to delete the record");
        }
        return reply;
    }

    public RemoveMultiANameResponseType RemoveMultiAName(RemoveMultiANameType request) throws EucalyptusCloudException {
        RemoveMultiANameResponseType reply = (RemoveMultiANameResponseType)request.getReply();
        String zone = request.getZone();
        zone = zone.endsWith(".") ? zone + DNSProperties.DOMAIN + "." : zone + "." + DNSProperties.DOMAIN + ".";
        String name = request.getName();
        name = name.endsWith(".") ? name + DNSProperties.DOMAIN + "." : name + "." + DNSProperties.DOMAIN + ".";
        EntityTransaction db = Entities.get(ARecordNameInfo.class);
        ARecordNameInfo nameInfo = null;
        ArrayList addresses = null;
        try {
            nameInfo = (ARecordNameInfo)Entities.uniqueResult((Object)ARecordNameInfo.named((String)name, (String)zone));
            addresses = Lists.newArrayList((Iterable)nameInfo.getAddresses());
            db.commit();
        }
        catch (NoSuchElementException ex) {
            db.rollback();
            return reply;
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to query dns name record", (Throwable)ex);
        }
        for (ARecordAddressInfo addr : addresses) {
            try {
                ARecord arecord = new ARecord(Name.fromString((String)name), 1, nameInfo.getTtl().longValue(), Address.getByAddress((String)addr.getAddress()));
                ZoneManager.deleteARecord(zone, arecord);
            }
            catch (Exception ex) {
                throw new EucalyptusCloudException("Failed to delete the record from zone", (Throwable)ex);
            }
        }
        db = Entities.get(ARecordNameInfo.class);
        try {
            nameInfo = (ARecordNameInfo)Entities.uniqueResult((Object)ARecordNameInfo.named((String)name, (String)zone));
            Entities.delete((Object)nameInfo);
            db.commit();
        }
        catch (NoSuchElementException ex) {
            db.rollback();
        }
        catch (Exception ex) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to query dns name record", (Throwable)ex);
        }
        return reply;
    }

    public UpdateARecordResponseType UpdateARecord(UpdateARecordType request) throws EucalyptusCloudException {
        UpdateARecordResponseType reply = (UpdateARecordResponseType)request.getReply();
        String zone = request.getZone();
        zone = zone.endsWith(".") ? zone + DNSProperties.DOMAIN + "." : zone + "." + DNSProperties.DOMAIN + ".";
        String name = request.getName();
        name = name.endsWith(".") ? name + DNSProperties.DOMAIN + "." : name + "." + DNSProperties.DOMAIN + ".";
        String address = request.getAddress();
        long ttl = request.getTtl();
        try (TransactionResource db = Entities.transactionFor(ARecordInfo.class);){
            ARecordInfo aRecordInfo = new ARecordInfo();
            aRecordInfo.setName(name);
            aRecordInfo.setAddress(address);
            aRecordInfo.setZone(zone);
            List arecords = Entities.query((Object)aRecordInfo);
            if (arecords.size() > 0) {
                aRecordInfo = (ARecordInfo)arecords.get(0);
                if (!zone.equals(aRecordInfo.getZone())) {
                    db.rollback();
                    throw new EucalyptusCloudException("Sorry, record already associated with a zone. Remove the record and try again.");
                }
                aRecordInfo.setAddress(address);
                aRecordInfo.setTtl(Long.valueOf(ttl));
                try {
                    ARecord arecord = new ARecord(Name.fromString((String)name), 1, ttl, Address.getByAddress((String)address));
                    ZoneManager.updateARecord(zone, arecord);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            } else {
                try {
                    ARecordInfo searchARecInfo = new ARecordInfo();
                    searchARecInfo.setZone(zone);
                    ARecord record = new ARecord(new Name(name), 1, ttl, Address.getByAddress((String)address));
                    ZoneManager.addRecord(zone, (Record)record, false);
                    aRecordInfo = new ARecordInfo();
                    aRecordInfo.setName(name);
                    aRecordInfo.setAddress(address);
                    aRecordInfo.setTtl(Long.valueOf(ttl));
                    aRecordInfo.setZone(zone);
                    aRecordInfo.setRecordclass(Integer.valueOf(1));
                    Entities.persist((Object)aRecordInfo);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
            db.commit();
        }
        return reply;
    }

    public RemoveARecordResponseType RemoveARecord(RemoveARecordType request) throws EucalyptusCloudException {
        RemoveARecordResponseType reply = (RemoveARecordResponseType)request.getReply();
        String zone = request.getZone();
        zone = zone.endsWith(".") ? zone + DNSProperties.DOMAIN + "." : zone + "." + DNSProperties.DOMAIN + ".";
        String name = request.getName();
        name = name.endsWith(".") ? name + DNSProperties.DOMAIN + "." : name + "." + DNSProperties.DOMAIN + ".";
        String address = request.getAddress();
        ARecordInfo aRecordInfo = new ARecordInfo();
        aRecordInfo.setName(name);
        aRecordInfo.setZone(zone);
        aRecordInfo.setAddress(address);
        try (TransactionResource db = Entities.transactionFor(ARecordInfo.class);){
            ARecordInfo foundARecordInfo = (ARecordInfo)Entities.uniqueResult((Object)aRecordInfo);
            ARecord arecord = new ARecord(Name.fromString((String)name), 1, foundARecordInfo.getTtl().longValue(), Address.getByAddress((String)foundARecordInfo.getAddress()));
            ZoneManager.deleteRecord(zone, (Record)arecord);
            Entities.delete((Object)foundARecordInfo);
            db.commit();
        }
        catch (NoSuchElementException e) {
            LOG.error((Object)e);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return reply;
    }

    public AddZoneResponseType AddZone(AddZoneType request) throws EucalyptusCloudException {
        AddZoneResponseType reply = (AddZoneResponseType)request.getReply();
        String name = request.getName();
        if (!Contexts.lookup().hasAdministrativePrivileges()) {
            throw new EucalyptusCloudException("Access Denied. Only administrator can add zone.");
        }
        return reply;
    }

    public UpdateCNAMERecordResponseType UpdateCNAMERecord(UpdateCNAMERecordType request) throws EucalyptusCloudException {
        UpdateCNAMERecordResponseType reply = (UpdateCNAMERecordResponseType)request.getReply();
        String zone = request.getZone() + DNSProperties.DOMAIN + ".";
        String name = request.getName() + DNSProperties.DOMAIN + ".";
        String alias = request.getAlias() + DNSProperties.DOMAIN + ".";
        long ttl = request.getTtl();
        CNAMERecordInfo cnameRecordInfo = new CNAMERecordInfo();
        cnameRecordInfo.setName(name);
        cnameRecordInfo.setAlias(alias);
        cnameRecordInfo.setZone(zone);
        try (TransactionResource db = Entities.transactionFor(CNAMERecordInfo.class);){
            List cnamerecords = Entities.query((Object)cnameRecordInfo);
            if (cnamerecords.size() > 0) {
                cnameRecordInfo = (CNAMERecordInfo)cnamerecords.get(0);
                if (!zone.equals(cnameRecordInfo.getZone())) {
                    db.rollback();
                    throw new EucalyptusCloudException("Sorry, record already associated with a zone. Remove the record and try again.");
                }
                cnameRecordInfo.setAlias(alias);
                cnameRecordInfo.setTtl(Long.valueOf(ttl));
                try {
                    CNAMERecord cnameRecord = new CNAMERecord(Name.fromString((String)name), 1, ttl, Name.fromString((String)alias));
                    ZoneManager.updateCNAMERecord(zone, cnameRecord);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            } else {
                try {
                    CNAMERecordInfo searchCNAMERecInfo = new CNAMERecordInfo();
                    searchCNAMERecInfo.setZone(zone);
                    CNAMERecord record = new CNAMERecord(new Name(name), 1, ttl, Name.fromString((String)alias));
                    ZoneManager.addRecord(zone, (Record)record, false);
                    cnameRecordInfo = new CNAMERecordInfo();
                    cnameRecordInfo.setName(name);
                    cnameRecordInfo.setAlias(alias);
                    cnameRecordInfo.setTtl(Long.valueOf(ttl));
                    cnameRecordInfo.setZone(zone);
                    cnameRecordInfo.setRecordclass(Integer.valueOf(1));
                    Entities.persist((Object)cnameRecordInfo);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
            db.commit();
        }
        return reply;
    }

    public RemoveCNAMERecordResponseType RemoveCNAMERecord(RemoveCNAMERecordType request) throws EucalyptusCloudException {
        RemoveCNAMERecordResponseType reply = (RemoveCNAMERecordResponseType)request.getReply();
        String zone = request.getZone() + DNSProperties.DOMAIN + ".";
        String name = request.getName() + DNSProperties.DOMAIN + ".";
        String alias = request.getAlias() + DNSProperties.DOMAIN + ".";
        CNAMERecordInfo cnameRecordInfo = new CNAMERecordInfo();
        cnameRecordInfo.setName(name);
        cnameRecordInfo.setZone(zone);
        cnameRecordInfo.setAlias(alias);
        try (TransactionResource db = Entities.transactionFor(CNAMERecordInfo.class);){
            CNAMERecordInfo foundCNAMERecordInfo = (CNAMERecordInfo)Entities.uniqueResult((Object)cnameRecordInfo);
            CNAMERecord cnameRecord = new CNAMERecord(Name.fromString((String)name), 1, foundCNAMERecordInfo.getTtl().longValue(), Name.fromString((String)foundCNAMERecordInfo.getAlias()));
            ZoneManager.deleteRecord(zone, (Record)cnameRecord);
            Entities.delete((Object)foundCNAMERecordInfo);
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        return reply;
    }

    public DeleteZoneResponseType DeleteZone(DeleteZoneType request) throws EucalyptusCloudException {
        DeleteZoneResponseType reply = (DeleteZoneResponseType)request.getReply();
        String name = request.getName();
        if (!Contexts.lookup().hasAdministrativePrivileges()) {
            throw new AccessDeniedException(name);
        }
        ZoneInfo zoneInfo = new ZoneInfo(name);
        try (TransactionResource db = Entities.transactionFor(ZoneInfo.class);){
            ZoneInfo foundZoneInfo = (ZoneInfo)Entities.uniqueResult((Object)zoneInfo);
            Entities.delete((Object)foundZoneInfo);
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        ZoneManager.deleteZone(name);
        return reply;
    }

    public static class DnsPopulateTimer
    implements EventListener<ClockTick> {
        private static int EventCounter = 0;

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new DnsPopulateTimer());
        }

        public void fireEvent(ClockTick event) {
            if (!(Bootstrap.isFinished().booleanValue() && Topology.isEnabledLocally(Eucalyptus.class) && Topology.isEnabled(Dns.class))) {
                return;
            }
            if (EventCounter++ >= 3) {
                try {
                    DNSControl.populateRecords();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Failed to populate DNS records");
                }
                EventCounter = 0;
            }
        }
    }

    private static interface ListenerBuilder<T> {
        public T build(InetAddress var1, int var2) throws IOException;
    }

    public static class DnsAddressChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue instanceof String) {
                DNSControl.updateAddressMatchers((String)newValue);
                try {
                    DNSControl.restart();
                }
                catch (Exception e) {
                    throw new ConfigurablePropertyException(e.getMessage());
                }
            }
        }
    }

    public static class DnsSearchChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue == null || newValue instanceof String) {
                try {
                    String newValueStr = (String)newValue;
                    if (Strings.isNullOrEmpty((String)newValueStr)) {
                        LOG.debug((Object)"Setting dns.search property to null (by clearing it)");
                        System.clearProperty("dns.search");
                    } else {
                        LOG.debug((Object)("Setting dns.search property to " + newValueStr));
                        System.setProperty("dns.search", newValueStr);
                    }
                    ResolverConfig.refresh();
                }
                catch (Exception e) {
                    throw new ConfigurablePropertyException(e.getMessage());
                }
            }
        }
    }

    public static class DnsServerChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue == null || newValue instanceof String) {
                try {
                    String newValueStr = (String)newValue;
                    if (Strings.isNullOrEmpty((String)newValueStr)) {
                        LOG.debug((Object)"Setting dns.server property to null (by clearing it)");
                        System.clearProperty("dns.server");
                    } else {
                        LOG.debug((Object)("Setting dns.server property to " + newValueStr));
                        System.setProperty("dns.server", newValueStr);
                    }
                    ResolverConfig.refresh();
                }
                catch (Exception e) {
                    throw new ConfigurablePropertyException(e.getMessage());
                }
            }
        }
    }
}

