/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.cloud.ws;

import com.eucalyptus.cloud.ws.ZoneManager;
import com.eucalyptus.dns.Cache;
import com.eucalyptus.dns.Zone;
import com.eucalyptus.util.Pair;
import com.eucalyptus.util.dns.DnsResolvers;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;

public class ConnectionHandler
extends Thread {
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    Map caches = new ConcurrentHashMap();
    private static final ThreadLocal<Pair<InetAddress, InetAddress>> localAndRemoteInetAddresses = new ThreadLocal();

    byte[] generateReply(Message query, byte[] in, int length, Socket s) throws IOException {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getRcode() != 0) {
            return this.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, 4);
        }
        Record queryRecord = query.getQuestion();
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        OPTRecord queryOPT = query.getOPT();
        if (queryOPT != null && queryOPT.getVersion() > 0) {
            boolean bl = true;
        }
        int maxLength = s != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        if (queryRecord != null) {
            response.addRecord(queryRecord, 0);
            Name name = queryRecord.getName();
            int type = queryRecord.getType();
            int dclass = queryRecord.getDClass();
            if (!Type.isRR((int)type) && type != 255) {
                return this.errorMessage(query, 4);
            }
            byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
            if (rcode != 0 && rcode != 3) {
                return this.errorMessage(query, 2);
            }
            this.addAdditional(response, type, flags);
            if (queryOPT != null) {
                int optflags = flags == 1 ? 32768 : 0;
                OPTRecord opt = new OPTRecord(4096, (int)rcode, 0, optflags);
                response.addRecord((Record)opt, 3);
            }
        }
        response.setTSIG(tsig, 0, queryTSIG);
        return response.toWire(maxLength);
    }

    public Zone findBestZone(Name name) {
        Zone foundzone = null;
        int labels = name.labels();
        for (int i = 1; i < labels; ++i) {
            Name tname = new Name(name, i);
            foundzone = ZoneManager.getZone(tname);
            if (foundzone == null) continue;
            return foundzone;
        }
        return null;
    }

    public RRset findExactMatch(Name name, int type, int dclass, boolean glue) {
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            return zone.findExactMatch(name, type);
        }
        Cache cache = this.getCache(dclass);
        RRset[] rrsets = glue ? cache.findAnyRecords(name, type) : cache.findRecords(name, type);
        if (rrsets == null) {
            return null;
        }
        return rrsets[0];
    }

    private void addGlue(Message response, Name name, int type, int flags) {
        RRset a = this.findExactMatch(name, type, 1, true);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    private void addAdditional2(Message response, int section, int type, int flags) {
        Record[] records = response.getSectionArray(section);
        for (int i = 0; i < records.length; ++i) {
            Record r = records[i];
            Name glueName = r.getAdditionalName();
            if (glueName == null) continue;
            this.addGlue(response, glueName, type, flags);
        }
    }

    private final void addAdditional(Message response, int type, int flags) {
        this.addAdditional2(response, 1, type, flags);
        this.addAdditional2(response, 2, type, flags);
    }

    byte addAnswer(final Message response, Name name, int type, int dclass, int iterations, int flags) {
        SetResponse sr;
        int rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        try {
            sr = DnsResolvers.findRecords((Message)response, (DnsResolvers.DnsRequest)new DnsResolvers.DnsRequest(){

                public Record getQuery() {
                    return response.getQuestion();
                }

                public InetAddress getLocalAddress() {
                    return ConnectionHandler.getLocalInetAddress();
                }

                public InetAddress getRemoteAddress() {
                    return ConnectionHandler.getRemoteInetAddress();
                }
            });
            if (sr != null) {
                if (sr.isSuccessful()) {
                    return 0;
                }
                if (sr.isNXDOMAIN()) {
                    return 3;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(DnsResolvers.class).error((Object)ex);
        }
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            if (type == 28) {
                response.getHeader().setFlag(5);
                return 0;
            }
            sr = zone.findRecords(name, type, ConnectionHandler.getLocalInetAddress());
        } else {
            Cache cache = this.getCache(dclass);
            sr = cache.lookupRecords(name, type, 3);
        }
        if (sr.isUnknown()) {
            return 2;
        }
        if (sr.isNXDOMAIN()) {
            response.getHeader().setRcode(3);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = 3;
        } else if (sr.isNXRRSET()) {
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
        } else if (sr.isDelegation()) {
            RRset nsRecords = sr.getNS();
            this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
        } else if (sr.isCNAME()) {
            CNAMERecord cname = sr.getCNAME();
            RRset rrset = new RRset((Record)cname);
            this.addRRset(name, response, rrset, 1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
        } else if (sr.isDNAME()) {
            Name newname;
            DNAMERecord dname = sr.getDNAME();
            RRset rrset = new RRset((Record)dname);
            this.addRRset(name, response, rrset, 1, flags);
            try {
                newname = name.fromDNAME(dname);
            }
            catch (NameTooLongException e) {
                return 6;
            }
            if (newname != null) {
                rrset = new RRset((Record)new CNAMERecord(name, dclass, 0L, newname));
                this.addRRset(name, response, rrset, 1, flags);
                if (zone != null && iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
            }
        } else if (sr.isSuccessful()) {
            RRset[] rrsets = sr.answers();
            if (rrsets != null) {
                for (int i = 0; i < rrsets.length; ++i) {
                    this.addRRset(name, response, rrsets[i], 1, flags);
                }
            }
            if (zone != null) {
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            } else {
                this.addCacheNS(response, this.getCache(dclass), name);
            }
        }
        return (byte)rcode;
    }

    private final void addSOA(Message response, Zone zone) {
        response.addRecord((Record)zone.getSOA(), 2);
    }

    private final void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
    }

    private final void addCacheNS(Message response, Cache cache, Name name) {
        SetResponse sr = cache.lookupRecords(name, 2, 0);
        if (!sr.isDelegation()) {
            return;
        }
        RRset nsRecords = sr.getNS();
        Iterator it = nsRecords.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            response.addRecord(r, 2);
        }
    }

    byte[] doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket s) {
        Zone zone = ZoneManager.getZone(name);
        boolean first = true;
        if (zone == null) {
            return this.errorMessage(query, 5);
        }
        Iterator it = zone.AXFR();
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            int id = query.getHeader().getID();
            while (it.hasNext()) {
                RRset rrset = (RRset)it.next();
                Message response = new Message(id);
                Header header = response.getHeader();
                header.setFlag(0);
                header.setFlag(5);
                this.addRRset(rrset.getName(), response, rrset, 1, 1);
                if (tsig != null) {
                    tsig.applyStream(response, qtsig, first);
                    qtsig = response.getTSIG();
                }
                first = false;
                byte[] out = response.toWire();
                dataOut.writeShort(out.length);
                dataOut.write(out);
            }
        }
        catch (IOException ex) {
            System.out.println("AXFR failed");
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        Record r;
        for (int s = 1; s <= section; ++s) {
            if (!response.findRRset(name, rrset.getType(), s)) continue;
            return;
        }
        if ((flags & 2) == 0) {
            Iterator it = rrset.rrs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            Iterator it = rrset.sigs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    byte[] buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        for (int i = 0; i < 4; ++i) {
            response.removeAllRecords(i);
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response.toWire();
    }

    public byte[] errorMessage(Message query, int rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    public byte[] formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildErrorMessage(header, 1, null);
    }

    public Cache getCache(int dclass) {
        Cache c = (Cache)this.caches.get(new Integer(dclass));
        if (c == null) {
            c = new Cache(dclass);
            this.caches.put(new Integer(dclass), c);
        }
        return c;
    }

    private static InetAddress getInetAddress(Function<Pair<InetAddress, InetAddress>, InetAddress> extractor) {
        return (InetAddress)Optional.fromNullable(localAndRemoteInetAddresses.get()).transform(extractor).orNull();
    }

    static InetAddress getLocalInetAddress() {
        return ConnectionHandler.getInetAddress((Function<Pair<InetAddress, InetAddress>, InetAddress>)Pair.left());
    }

    static InetAddress getRemoteInetAddress() {
        return ConnectionHandler.getInetAddress((Function<Pair<InetAddress, InetAddress>, InetAddress>)Pair.right());
    }

    static void setLocalAndRemoteInetAddresses(InetAddress local, InetAddress remote) {
        localAndRemoteInetAddresses.set((Pair<InetAddress, InetAddress>)Pair.pair((Object)local, (Object)remote));
    }

    static void clearInetAddresses() {
        localAndRemoteInetAddresses.remove();
    }
}

