/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.util;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Topology;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.WalrusBackend;
import java.net.InetAddress;
import org.apache.log4j.Logger;

public class WalrusProperties {
    private static Logger LOG = Logger.getLogger(WalrusProperties.class);
    public static String NAME = "Walrus";
    public static final long G = 0x40000000L;
    public static final long M = 0x100000L;
    public static final long K = 1024L;
    public static final String bucketRootDirectory = BaseDirectory.VAR.toString() + "/bukkits";
    public static int MAX_BUCKETS_PER_ACCOUNT = 100;
    public static long MAX_BUCKET_SIZE = 0x140000000L;
    public static long IMAGE_CACHE_SIZE = 0x780000000L;
    public static int MAX_TOTAL_SNAPSHOT_SIZE = 50;
    public static final boolean BUCKET_NAMES_REQUIRE_DNS_COMPLIANCE = false;
    public static int MAX_KEYS = 1000;
    public static int IO_CHUNK_SIZE = 102400;
    public static boolean shouldEnforceUsageLimits = true;
    public static boolean enableTorrents = false;
    public static boolean enableVirtualHosting = true;
    public static long MAX_INLINE_DATA_SIZE = 0xA00000L;
    public static final String NAMESPACE_VERSION = "2006-03-01";
    public static final String CONTENT_LEN = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String MULTIFORM_DATA_TYPE = "multipart/form-data";
    public static final String USAGE_LIMITS_PROPERTY = "euca.walrus.usageLimits";
    public static final String AMZ_META_HEADER_PREFIX = "x-amz-meta-";
    public static final String AMZ_ACL = "x-amz-acl";
    public static final String AMZ_REQUEST_ID = "x-amz-request-id";
    public static final String ALL_USERS_GROUP = "http://acs.amazonaws.com/groups/global/AllUsers";
    public static final String AUTHENTICATED_USERS_GROUP = "http://acs.amazonaws.com/groups/global/AuthenticatedUsers";
    public static final String LOGGING_GROUP = "http://acs.amazonaws.com/groups/s3/LogDelivery";
    public static final String IGNORE_PREFIX = "x-ignore-";
    public static final String COPY_SOURCE = "x-amz-copy-source";
    public static final String METADATA_DIRECTIVE = "x-amz-metadata-directive";
    public static final String X_AMZ_VERSION_ID = "x-amz-version-id";
    public static final String NULL_VERSION_ID = "null";
    public static final String X_AMZ_SECURITY_TOKEN = "x-amz-security-token";
    public static final String TRACKER_BINARY = "bttrack";
    public static final String TORRENT_CREATOR_BINARY = "btmakemetafile";
    public static final String TORRENT_CLIENT_BINARY = "btdownloadheadless";
    public static String TRACKER_DIR = BaseDirectory.VAR.toString() + "/bt";
    public static String TRACKER_URL = "http://localhost:6969/announce";
    public static String TRACKER_PORT = "6969";
    public static final String EUCA_ROOT_WRAPPER = BaseDirectory.LIBEXEC.toString() + "/euca_rootwrap";
    public static final Integer DEFAULT_INITIAL_CAPACITY = 10;
    public static final long EXPIRATION_LIMIT = 900000L;

    public static boolean isUserMember(String userId, String groupId) {
        if (groupId == null) {
            return false;
        }
        if (groupId.equals(ALL_USERS_GROUP)) {
            return true;
        }
        return groupId.equals(AUTHENTICATED_USERS_GROUP) && userId != null && !"".equals(userId) && !userId.equals(Principals.nobodyUser().getUserId());
    }

    public static String getTrackerUrl() {
        try {
            TRACKER_URL = "http://" + Topology.lookup(WalrusBackend.class, (Partition[])new Partition[0]).getUri().getHost() + ":" + TRACKER_PORT + "/announce";
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return TRACKER_URL;
    }

    public static InetAddress getWalrusAddress() throws EucalyptusCloudException {
        if (Topology.isEnabled(WalrusBackend.class)) {
            return Topology.lookup(WalrusBackend.class, (Partition[])new Partition[0]).getInetAddress();
        }
        throw new EucalyptusCloudException("WalrusBackend not ENABLED");
    }

    public static enum RequiredSOAPTags {
        AWSAccessKeyId,
        Timestamp,
        Signature;

    }

    public static enum RequiredQueryParams {
        Date;

    }

    public static enum ObjectParameter {
        acl,
        torrent,
        versionId,
        uploads,
        partNumber,
        uploadId;

    }

    public static enum BucketParameter {
        acl,
        location,
        prefix,
        maxkeys,
        delimiter,
        marker,
        torrent,
        logging,
        versioning,
        versions,
        versionidmarker,
        keymarker,
        cors,
        lifecycle,
        policy,
        notification,
        tagging,
        requestPayment,
        website,
        uploads;

    }

    public static enum ServiceParameter {

    }

    public static enum HTTPVerb {
        GET,
        PUT,
        DELETE,
        POST,
        HEAD;

    }

    public static enum SubResource {
        acl,
        lifecycle,
        location,
        logging,
        notification,
        partNumber,
        policy,
        requestPayment,
        torrent,
        uploadId,
        uploads,
        versionId,
        versioning,
        versions,
        website,
        cors,
        tagging;

    }

    public static enum CopyHeaders {
        CopySourceIfMatch,
        CopySourceIfNoneMatch,
        CopySourceIfUnmodifiedSince,
        CopySourceIfModifiedSince;

    }

    public static enum PolicyHeaders {
        expiration,
        conditions;

    }

    public static enum IgnoredFields {
        AWSAccessKeyId,
        signature,
        file,
        policy,
        submit;

    }

    public static enum FormField {
        FormUploadPolicyData,
        AWSAccessKeyId,
        key,
        bucket,
        acl,
        policy,
        redirect,
        success_action_redirect,
        success_action_status,
        signature,
        file;

    }

    public static enum GetOptionalParameters {
        IsCompressed;

    }

    public static enum ExtendedHeaderRangeTypes {
        ByteRangeStart,
        ByteRangeEnd;

    }

    public static enum ExtendedHeaderDateTypes {
        IfModifiedSince,
        IfUnmodifiedSince,
        CopySourceIfModifiedSince,
        CopySourceIfUnmodifiedSince;


        public static boolean contains(String value) {
            for (ExtendedHeaderDateTypes type : ExtendedHeaderDateTypes.values()) {
                if (!type.toString().equals(value)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum ExtendedGetHeaders {
        IfModifiedSince,
        IfUnmodifiedSince,
        IfMatch,
        IfNoneMatch,
        Range;

    }

    public static enum Headers {
        Bucket,
        Key,
        RandomKey,
        VolumeId,
        S3UploadPolicy,
        S3UploadPolicySignature;

    }

    public static enum VersioningStatus {
        Enabled,
        Disabled,
        Suspended;

    }

    public static enum Permission {
        READ,
        WRITE,
        READ_ACP,
        WRITE_ACP,
        FULL_CONTROL;

    }

    public static enum CannedACL {
        private_only{

            public String toString() {
                return "private";
            }
        }
        ,
        public_read{

            public String toString() {
                return "public-read";
            }
        }
        ,
        public_read_write{

            public String toString() {
                return "public-read-write";
            }
        }
        ,
        authenticated_read{

            public String toString() {
                return "authenticated-read";
            }
        }
        ,
        bucket_owner_read{

            public String toString() {
                return "bucket-owner-read";
            }
        }
        ,
        bucket_owner_full_control{

            public String toString() {
                return "bucket-owner-full-control";
            }
        }
        ,
        log_delivery_write{

            public String toString() {
                return "log-delivery-write";
            }
        }
        ,
        aws_exec_read{

            public String toString() {
                return "aws-exec-read";
            }
        };

    }
}

