/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.msgs;

import com.eucalyptus.walrus.msgs.WalrusDataMessage;
import com.eucalyptus.walrus.msgs.WalrusDataQueue;
import com.eucalyptus.walrus.msgs.WalrusMonitor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class WalrusDataMessenger {
    private static Logger LOG = Logger.getLogger(WalrusDataMessenger.class);
    private static final int DATA_QUEUE_SIZE = 3;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, WalrusDataQueue<WalrusDataMessage>>> queueMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, WalrusMonitor> monitorMap = new ConcurrentHashMap();

    public synchronized WalrusDataQueue<WalrusDataMessage> getQueue(String key1, String key2) {
        WalrusDataQueue queue;
        ConcurrentHashMap<Object, Object> queues = this.queueMap.putIfAbsent(key1, new ConcurrentHashMap());
        if (queues == null) {
            queues = this.queueMap.get(key1);
        }
        if ((queue = queues.putIfAbsent(key2, new WalrusDataQueue(3))) == null) {
            queue = (WalrusDataQueue)queues.get(key2);
        }
        return queue;
    }

    public synchronized WalrusDataQueue<WalrusDataMessage> interruptAllAndGetQueue(String key1, String key2) {
        ConcurrentHashMap<String, WalrusDataQueue<WalrusDataMessage>> queues = this.queueMap.get(key1);
        if (queues != null) {
            for (WalrusDataQueue<WalrusDataMessage> queue : queues.values()) {
                queue.setInterrupted(true);
            }
        }
        return this.getQueue(key1, key2);
    }

    public void clearQueues(String key1) {
        ConcurrentHashMap<String, WalrusDataQueue<WalrusDataMessage>> queues = this.queueMap.get(key1);
        if (queues != null) {
            for (WalrusDataQueue<WalrusDataMessage> queue : queues.values()) {
                queue.setInterrupted(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueue(String key1, String key2) {
        ConcurrentHashMap<String, WalrusDataQueue<WalrusDataMessage>> queues;
        if (this.queueMap.containsKey(key1) && (queues = this.queueMap.get(key1)).containsKey(key2)) {
            WalrusDataQueue<WalrusDataMessage> q = queues.get(key2);
            if (q != null) {
                try {
                    q.offer(WalrusDataMessage.InterruptTransaction(), 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                }
                queues.remove(key2);
            }
            ConcurrentHashMap<String, WalrusDataQueue<WalrusDataMessage>> concurrentHashMap = queues;
            synchronized (concurrentHashMap) {
                if (queues.size() == 0) {
                    this.queueMap.remove(key1);
                }
            }
        }
    }

    public synchronized WalrusMonitor getMonitor(String key) {
        WalrusMonitor monitor = this.monitorMap.putIfAbsent(key, new WalrusMonitor());
        if (monitor == null) {
            monitor = this.monitorMap.get(key);
        }
        return monitor;
    }

    public void removeMonitor(String key) {
        if (this.monitorMap.containsKey(key)) {
            this.monitorMap.remove(key);
        }
    }
}

