/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.msgs;

import java.nio.ByteBuffer;

public class WalrusDataMessage {
    private Header header;
    private byte[] payload;
    private static final String DELIMITER = "/";

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public WalrusDataMessage(Header header, byte[] payload) {
        this.header = header;
        this.payload = payload;
    }

    public WalrusDataMessage() {
    }

    public static WalrusDataMessage EOF() {
        return new WalrusDataMessage(Header.EOF, String.valueOf(System.currentTimeMillis()).getBytes());
    }

    public static WalrusDataMessage InterruptTransaction() {
        return new WalrusDataMessage(Header.INTERRUPT, new byte[0]);
    }

    public static WalrusDataMessage StartOfData(long size) {
        return new WalrusDataMessage(Header.START, String.valueOf(size).getBytes());
    }

    public static WalrusDataMessage DataMessage(byte[] data) {
        return new WalrusDataMessage(Header.DATA, data);
    }

    public static WalrusDataMessage DataMessage(byte[] data, int length) {
        byte[] bytes = new byte[length];
        WalrusDataMessage.copyBytes(data, bytes, 0, length);
        return new WalrusDataMessage(Header.DATA, bytes);
    }

    public static WalrusDataMessage DataMessage(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes, 0, length);
        return new WalrusDataMessage(Header.DATA, bytes);
    }

    public static boolean isStart(WalrusDataMessage message) {
        return Header.START.equals((Object)message.header);
    }

    public static boolean isEOF(WalrusDataMessage message) {
        return Header.EOF.equals((Object)message.header);
    }

    public static boolean isInterrupted(WalrusDataMessage message) {
        return Header.INTERRUPT.equals((Object)message.header);
    }

    public static boolean isData(WalrusDataMessage message) {
        return Header.DATA.equals((Object)message.header);
    }

    public static void copyBytes(byte[] sourceBytes, byte[] destBytes, int offset, int length) {
        System.arraycopy(sourceBytes, 0, destBytes, offset, length);
    }

    public static enum Header {
        START,
        DATA,
        INTERRUPT,
        EOF;

    }
}

