/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.entities;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.walrus.util.WalrusProperties;
import java.io.File;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_walrus")
@Table(name="walrus_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="walrusbackend", description="WalrusBackend backend configuration.", deferred=true)
public class WalrusInfo
extends AbstractPersistent {
    @Column(name="walrus_name", unique=true)
    private String name;
    @ConfigurableField(description="Path to buckets storage", displayName="Buckets Path")
    @Column(name="storage_dir")
    private String storageDir;
    @Column(name="storage_max_buckets_per_user")
    private Integer storageMaxBucketsPerAccount;
    @Column(name="storage_max_bucket_size_mb")
    private Integer storageMaxBucketSizeInMB;
    @Column(name="storage_snapshot_size_gb")
    private Integer storageMaxTotalSnapshotSizeInGb;
    @ConfigurableField(description="Total WalrusBackend storage capacity for Objects", displayName="WalrusBackend object capacity (GB)")
    @Column(name="storage_walrus_total_capacity")
    private Integer storageMaxTotalCapacity;
    @Column(name="storage_walrus_bucket_names_require_compliance")
    private Boolean bucketNamesRequireDnsCompliance;
    private static final Logger LOG = Logger.getLogger(WalrusInfo.class);

    public WalrusInfo() {
    }

    public WalrusInfo(String name, String storageDir, Integer storageMaxBucketsPerAccount, Integer storageMaxBucketSizeInMB, Integer storageMaxTotalSnapshotSizeInGb, Integer storageMaxObjectCapacity, Boolean bucketNamesRequireDnsCompliance) {
        this.name = name;
        this.storageDir = storageDir;
        this.storageMaxBucketsPerAccount = storageMaxBucketsPerAccount;
        this.storageMaxBucketSizeInMB = storageMaxBucketSizeInMB;
        this.storageMaxTotalSnapshotSizeInGb = storageMaxTotalSnapshotSizeInGb;
        this.storageMaxTotalCapacity = storageMaxObjectCapacity;
        this.bucketNamesRequireDnsCompliance = bucketNamesRequireDnsCompliance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public void setStorageDir(String storageDir) {
        this.storageDir = storageDir;
    }

    public Integer getStorageMaxBucketsPerAccount() {
        return this.storageMaxBucketsPerAccount;
    }

    public void setStorageMaxBucketsPerAccount(Integer storageMaxBucketsPerAccount) {
        this.storageMaxBucketsPerAccount = storageMaxBucketsPerAccount;
    }

    public Integer getStorageMaxBucketSizeInMB() {
        return this.storageMaxBucketSizeInMB;
    }

    public void setStorageMaxBucketSizeInMB(Integer storageMaxBucketSizeInMB) {
        this.storageMaxBucketSizeInMB = storageMaxBucketSizeInMB;
    }

    public Integer getStorageMaxTotalSnapshotSizeInGb() {
        return this.storageMaxTotalSnapshotSizeInGb;
    }

    public void setStorageMaxTotalSnapshotSizeInGb(Integer storageMaxTotalSnapshotSizeInGb) {
        this.storageMaxTotalSnapshotSizeInGb = storageMaxTotalSnapshotSizeInGb;
    }

    public Integer getStorageMaxTotalCapacity() {
        return this.storageMaxTotalCapacity;
    }

    public void setStorageMaxTotalCapacity(Integer storageMaxTotalCapacity) {
        this.storageMaxTotalCapacity = storageMaxTotalCapacity;
    }

    public Boolean getBucketNamesRequireDnsCompliance() {
        return this.bucketNamesRequireDnsCompliance;
    }

    public void setBucketNamesRequireDnsCompliance(Boolean bucketNamesRequireDnsCompliance) {
        this.bucketNamesRequireDnsCompliance = bucketNamesRequireDnsCompliance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WalrusInfo other = (WalrusInfo)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private static int estimateWalrusCapacity() {
        int capacity = WalrusProperties.DEFAULT_INITIAL_CAPACITY;
        try {
            long bytesAvailable = new File(WalrusProperties.bucketRootDirectory).getUsableSpace();
            capacity = (int)(bytesAvailable / 0x40000000L);
            capacity = capacity > 1 ? capacity - 1 : capacity;
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to detect usable space in the directory:" + WalrusProperties.bucketRootDirectory + " because of exception: " + e.getMessage() + ". Using WalrusBackend default: " + WalrusProperties.DEFAULT_INITIAL_CAPACITY + "GB"));
        }
        return capacity;
    }

    @PreUpdate
    public void preUpdateChecks() {
        if (this.getStorageMaxTotalCapacity() == null) {
            this.setStorageMaxTotalCapacity(WalrusInfo.estimateWalrusCapacity());
        }
        if (this.getBucketNamesRequireDnsCompliance() == null) {
            this.setBucketNamesRequireDnsCompliance(new Boolean(false));
        }
    }

    private static WalrusInfo generateDefault() {
        return new WalrusInfo(WalrusProperties.NAME, WalrusProperties.bucketRootDirectory, WalrusProperties.MAX_BUCKETS_PER_ACCOUNT, (int)(WalrusProperties.MAX_BUCKET_SIZE / 0x100000L), WalrusProperties.MAX_TOTAL_SNAPSHOT_SIZE, WalrusInfo.estimateWalrusCapacity(), new Boolean(false));
    }

    public static WalrusInfo getWalrusInfo() {
        WalrusInfo walrusInfo = null;
        try {
            walrusInfo = (WalrusInfo)((Object)Transactions.find((Object)((Object)new WalrusInfo())));
        }
        catch (Exception e) {
            LOG.warn((Object)"Walrus configuration not found. Loading defaults.");
            try {
                walrusInfo = (WalrusInfo)((Object)Transactions.saveDirect((Object)((Object)WalrusInfo.generateDefault())));
            }
            catch (Exception e1) {
                try {
                    walrusInfo = (WalrusInfo)((Object)Transactions.find((Object)((Object)new WalrusInfo())));
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Failed to persist and retrieve WalrusInfo entity");
                }
            }
        }
        if (walrusInfo == null) {
            walrusInfo = WalrusInfo.generateDefault();
        }
        return walrusInfo;
    }
}

