/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.entities;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.walrus.entities.GrantInfo;
import com.eucalyptus.walrus.entities.MetaDataInfo;
import com.eucalyptus.walrus.util.WalrusProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;

@Entity
@OptimisticLocking(type=OptimisticLockType.NONE)
@PersistenceContext(name="eucalyptus_walrus")
@Table(name="Objects")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ObjectInfo
extends AbstractPersistent {
    @Column(name="owner_id")
    private String ownerId;
    @Column(name="object_key")
    private String objectKey;
    @Column(name="bucket_name")
    private String bucketName;
    @Column(name="object_name")
    private String objectName;
    @Column(name="global_read")
    private Boolean globalRead;
    @Column(name="global_write")
    private Boolean globalWrite;
    @Column(name="global_read_acp")
    private Boolean globalReadACP;
    @Column(name="global_write_acp")
    private Boolean globalWriteACP;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="object_has_grants", joinColumns={@JoinColumn(name="object_id")}, inverseJoinColumns={@JoinColumn(name="grant_id")})
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<GrantInfo> grants = new ArrayList<GrantInfo>();
    @Column(name="etag")
    private String etag;
    @Column(name="last_modified")
    private Date lastModified;
    @Column(name="size")
    private Long size;
    @Column(name="storage_class")
    private String storageClass;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="object_has_metadata", joinColumns={@JoinColumn(name="object_id")}, inverseJoinColumns={@JoinColumn(name="metadata_id")})
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    @Column(name="metadata")
    private List<MetaDataInfo> metaData = new ArrayList<MetaDataInfo>();
    @Column(name="content_type")
    private String contentType;
    @Column(name="content_disposition")
    private String contentDisposition;
    @Column(name="is_deleted")
    private Boolean deleted;
    @Column(name="version_id")
    private String versionId;
    @Column(name="is_last")
    private Boolean last;
    @Column(name="upload_id")
    private String uploadId;
    @Column(name="part_number")
    private Integer partNumber;
    @Column(name="manifest")
    private Boolean manifest;
    @Column(name="upload_complete")
    private Boolean uploadComplete;
    @Column(name="cleanup")
    private Boolean cleanup;
    @Column(name="is_snapshot")
    private Boolean isSnapshot;

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public boolean isGlobalRead() {
        return this.globalRead;
    }

    public void setGlobalRead(Boolean globalRead) {
        this.globalRead = globalRead;
    }

    public boolean isGlobalWrite() {
        return this.globalWrite;
    }

    public void setGlobalWrite(Boolean globalWrite) {
        this.globalWrite = globalWrite;
    }

    public boolean isGlobalReadACP() {
        return this.globalReadACP;
    }

    public void setGlobalReadACP(Boolean globalReadACP) {
        this.globalReadACP = globalReadACP;
    }

    public boolean isGlobalWriteACP() {
        return this.globalWriteACP;
    }

    public void setGlobalWriteACP(Boolean globalWriteACP) {
        this.globalWriteACP = globalWriteACP;
    }

    public List<GrantInfo> getGrants() {
        return this.grants;
    }

    public void setGrants(List<GrantInfo> grants) {
        this.grants = grants;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public List<MetaDataInfo> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(List<MetaDataInfo> metaData) {
        this.metaData = metaData;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Boolean getLast() {
        return this.last;
    }

    public void setLast(Boolean last) {
        this.last = last;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public Integer getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(Integer partNumber) {
        this.partNumber = partNumber;
    }

    public Boolean getManifest() {
        return this.manifest;
    }

    public void setManifest(Boolean manifest) {
        this.manifest = manifest;
    }

    public Boolean getUploadComplete() {
        return this.uploadComplete;
    }

    public void setUploadComplete(Boolean uploadComplete) {
        this.uploadComplete = uploadComplete;
    }

    public Boolean getCleanup() {
        return this.cleanup;
    }

    public void setCleanup(Boolean cleanup) {
        this.cleanup = cleanup;
    }

    public Boolean getIsSnapshot() {
        return this.isSnapshot;
    }

    public void setIsSnapshot(Boolean isSnapshot) {
        this.isSnapshot = isSnapshot;
    }

    public ObjectInfo() {
    }

    public ObjectInfo(String bucketName, String objectKey) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
    }

    public void resetGlobalGrants() {
        this.globalReadACP = this.globalWriteACP = Boolean.valueOf(false);
        this.globalWrite = this.globalWriteACP;
        this.globalRead = this.globalWriteACP;
    }

    public void readPermissions(List<Grant> grants) {
        if (this.globalRead.booleanValue() && this.globalReadACP.booleanValue() && this.globalWrite.booleanValue() && this.globalWriteACP.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.FULL_CONTROL.toString()));
            return;
        }
        if (this.globalRead.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.READ.toString()));
        }
        if (this.globalReadACP.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.READ_ACP.toString()));
        }
        if (this.globalWrite.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.WRITE.toString()));
        }
        if (this.globalWriteACP.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.WRITE_ACP.toString()));
        }
    }

    public void replaceMetaData(List<MetaDataEntry> metaDataEntries) {
        this.metaData = new ArrayList<MetaDataInfo>();
        if (metaDataEntries != null) {
            for (MetaDataEntry metaDataEntry : metaDataEntries) {
                MetaDataInfo metaDataInfo = new MetaDataInfo();
                metaDataInfo.setObjectName(this.objectName);
                metaDataInfo.setName(metaDataEntry.getName());
                metaDataInfo.setValue(metaDataEntry.getValue());
                this.metaData.add(metaDataInfo);
            }
        }
    }

    public List<MetaDataInfo> cloneMetaData() {
        ArrayList<MetaDataInfo> metaDataInfos = new ArrayList<MetaDataInfo>();
        if (this.metaData != null) {
            for (MetaDataInfo metaDataInfo : this.metaData) {
                metaDataInfos.add(new MetaDataInfo(metaDataInfo));
            }
        }
        return metaDataInfos;
    }

    public boolean isMultipart() {
        return StringUtils.isNotBlank((String)this.uploadId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
        result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        result = 31 * result + (this.partNumber == null ? 0 : this.partNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObjectInfo other = (ObjectInfo)((Object)obj);
        if (this.bucketName == null ? other.bucketName != null : !this.bucketName.equals(other.bucketName)) {
            return false;
        }
        if (this.objectKey == null ? other.objectKey != null : !this.objectKey.equals(other.objectKey)) {
            return false;
        }
        if (this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId)) {
            return false;
        }
        return !(this.partNumber == null ? other.partNumber != null : !this.partNumber.equals(other.partNumber));
    }
}

