/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.entities;

import com.eucalyptus.entities.AbstractPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_walrus")
@Table(name="ImageCache")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ImageCacheInfo
extends AbstractPersistent
implements Comparable<ImageCacheInfo> {
    @Column(name="bucket_name")
    private String bucketName;
    @Column(name="manifest_name")
    private String manifestName;
    @Column(name="image_name")
    private String imageName;
    @Column(name="in_cache")
    private Boolean inCache;
    @Column(name="size")
    private Long size;
    @Column(name="use_count")
    private Integer useCount;

    public ImageCacheInfo() {
    }

    public ImageCacheInfo(String bucketName, String manifestName) {
        this.bucketName = bucketName;
        this.manifestName = manifestName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public void setManifestName(String manifestName) {
        this.manifestName = manifestName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public Boolean getInCache() {
        return this.inCache;
    }

    public void setInCache(Boolean inCache) {
        this.inCache = inCache;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Integer getUseCount() {
        return this.useCount;
    }

    public void setUseCount(Integer useCount) {
        this.useCount = useCount;
    }

    @Override
    public int compareTo(ImageCacheInfo info) {
        if (info.getUseCount().equals(this.useCount)) {
            return 0;
        }
        if (info.getUseCount() < this.useCount) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
        result = 31 * result + (this.manifestName == null ? 0 : this.manifestName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageCacheInfo other = (ImageCacheInfo)obj;
        if (this.bucketName == null ? other.bucketName != null : !this.bucketName.equals(other.bucketName)) {
            return false;
        }
        return !(this.manifestName == null ? other.manifestName != null : !this.manifestName.equals(other.manifestName));
    }
}

