/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.entities;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.walrus.util.WalrusProperties;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_walrus")
@Table(name="drbd_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="walrusbackend", alias="drbd", description="DRBD configuration.", deferred=true)
public class DRBDInfo
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(DRBDInfo.class);
    @Column(name="walrus_name", unique=true)
    private String name;
    @ConfigurableField(description="DRBD block device", displayName="Block Device")
    @Column(name="block_device")
    private String blockDevice;
    @ConfigurableField(description="DRBD resource name", displayName="DRBD Resource")
    @Column(name="resource_name")
    private String resource;

    public DRBDInfo() {
    }

    public DRBDInfo(String name, String blockDevice) {
        this.name = name;
        this.blockDevice = blockDevice;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBlockDevice() {
        return this.blockDevice;
    }

    public void setBlockDevice(String blockDevice) {
        this.blockDevice = blockDevice;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public static DRBDInfo getDRBDInfo() {
        DRBDInfo drbdInfo = null;
        try {
            drbdInfo = (DRBDInfo)((Object)Transactions.find((Object)((Object)new DRBDInfo())));
        }
        catch (Exception e) {
            LOG.warn((Object)"DRBD information not found. Loading defaults.");
            try {
                drbdInfo = (DRBDInfo)((Object)Transactions.saveDirect((Object)((Object)new DRBDInfo(WalrusProperties.NAME, "/dev/unknown"))));
            }
            catch (Exception e1) {
                try {
                    drbdInfo = (DRBDInfo)((Object)Transactions.find((Object)((Object)new DRBDInfo())));
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Failed to persist and retrieve DRBDInfo entity");
                }
            }
        }
        if (drbdInfo == null) {
            drbdInfo = new DRBDInfo(WalrusProperties.NAME, "/dev/unknown");
        }
        return drbdInfo;
    }
}

