/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.entities;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.eucalyptus.walrus.entities.GrantInfo;
import com.eucalyptus.walrus.util.WalrusProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;

@Entity
@OptimisticLocking(type=OptimisticLockType.NONE)
@PersistenceContext(name="eucalyptus_walrus")
@Table(name="Buckets")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class BucketInfo
extends AbstractPersistent {
    @Column(name="owner_id")
    private String ownerId;
    @Column(name="user_id")
    private String userId;
    @Column(name="bucket_name", unique=true)
    private String bucketName;
    @Column(name="bucket_creation_date")
    private Date creationDate;
    @Column(name="global_read")
    private Boolean globalRead;
    @Column(name="global_write")
    private Boolean globalWrite;
    @Column(name="global_read_acp")
    private Boolean globalReadACP;
    @Column(name="global_write_acp")
    private Boolean globalWriteACP;
    @Column(name="bucket_size")
    private Long bucketSize;
    @Column(name="bucket_location")
    private String location;
    @Column(name="hidden")
    private Boolean hidden;
    @Column(name="logging_enabled")
    private Boolean loggingEnabled;
    @Column(name="target_bucket")
    private String targetBucket;
    @Column(name="target_prefix")
    private String targetPrefix;
    @Column(name="versioning")
    private String versioning;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="bucket_has_grants", joinColumns={@JoinColumn(name="bucket_id")}, inverseJoinColumns={@JoinColumn(name="grant_id")})
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<GrantInfo> grants = new ArrayList<GrantInfo>();

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public boolean isGlobalRead() {
        return this.globalRead;
    }

    public void setGlobalRead(Boolean globalRead) {
        this.globalRead = globalRead;
    }

    public boolean isGlobalWrite() {
        return this.globalWrite;
    }

    public void setGlobalWrite(Boolean globalWrite) {
        this.globalWrite = globalWrite;
    }

    public boolean isGlobalReadACP() {
        return this.globalReadACP;
    }

    public void setGlobalReadACP(Boolean globalReadACP) {
        this.globalReadACP = globalReadACP;
    }

    public boolean isGlobalWriteACP() {
        return this.globalWriteACP;
    }

    public void setGlobalWriteACP(Boolean globalWriteACP) {
        this.globalWriteACP = globalWriteACP;
    }

    public Long getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(Long bucketSize) {
        this.bucketSize = bucketSize;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(Boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public String getTargetBucket() {
        return this.targetBucket;
    }

    public void setTargetBucket(String targetBucket) {
        this.targetBucket = targetBucket;
    }

    public String getTargetPrefix() {
        return this.targetPrefix;
    }

    public void setTargetPrefix(String targetPrefix) {
        this.targetPrefix = targetPrefix;
    }

    public String getVersioning() {
        return this.versioning;
    }

    public void setVersioning(String versioning) {
        this.versioning = versioning;
    }

    public List<GrantInfo> getGrants() {
        return this.grants;
    }

    public void setGrants(List<GrantInfo> grants) {
        this.grants = grants;
    }

    public BucketInfo() {
    }

    public BucketInfo(String bucketName) {
        this.bucketName = bucketName;
    }

    public BucketInfo(String ownerId, String userId, String bucketName, Date creationDate) {
        this.ownerId = ownerId;
        this.userId = userId;
        this.bucketName = bucketName;
        this.creationDate = creationDate;
    }

    public BucketInfo(String bucketName, Date creationDate) {
        this.bucketName = bucketName;
        this.creationDate = creationDate;
    }

    public void resetGlobalGrants() {
        this.globalReadACP = this.globalWriteACP = Boolean.valueOf(false);
        this.globalWrite = this.globalWriteACP;
        this.globalRead = this.globalWriteACP;
    }

    public void readPermissions(List<Grant> grants) {
        if (this.globalRead.booleanValue() && this.globalReadACP.booleanValue() && this.globalWrite.booleanValue() && this.globalWriteACP.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.FULL_CONTROL.toString()));
            return;
        }
        if (this.globalRead.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.READ.toString()));
        }
        if (this.globalReadACP.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.READ_ACP.toString()));
        }
        if (this.globalWrite.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.WRITE.toString()));
        }
        if (this.globalWriteACP.booleanValue()) {
            grants.add(new Grant(new Grantee(new Group("http://acs.amazonaws.com/groups/global/AllUsers")), WalrusProperties.Permission.WRITE_ACP.toString()));
        }
    }

    public boolean isVersioningEnabled() {
        return WalrusProperties.VersioningStatus.Enabled.toString().equals(this.versioning);
    }

    public boolean isVersioningDisabled() {
        return WalrusProperties.VersioningStatus.Disabled.toString().equals(this.versioning);
    }

    public boolean isVersioningSuspended() {
        return WalrusProperties.VersioningStatus.Suspended.toString().equals(this.versioning);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BucketInfo other = (BucketInfo)((Object)obj);
        return !(this.bucketName == null ? other.bucketName != null : !this.bucketName.equals(other.bucketName));
    }
}

