/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.tags;

import com.eucalyptus.autoscaling.common.backend.msgs.TagDescription;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataNotFoundException;
import com.eucalyptus.autoscaling.tags.Tag;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityTransaction;
import org.hibernate.criterion.Criterion;

public class Tags {
    public static List<Tag> list(OwnerFullName ownerFullName) throws AutoScalingMetadataNotFoundException {
        try {
            return Transactions.findAll((Object)((Object)Tag.withOwner(ownerFullName)));
        }
        catch (Exception e) {
            throw new AutoScalingMetadataNotFoundException("Failed to find tags for " + ownerFullName, e);
        }
    }

    public static List<Tag> list(OwnerFullName ownerFullName, Predicate<? super Tag> filter, Criterion criterion, Map<String, String> aliases) throws AutoScalingMetadataNotFoundException {
        return Tags.list(Tag.withOwner(ownerFullName), filter, criterion, aliases);
    }

    public static List<Tag> list(Tag example, Predicate<? super Tag> filter, Criterion criterion, Map<String, String> aliases) throws AutoScalingMetadataNotFoundException {
        try {
            return Transactions.filter((Object)((Object)example), filter, (Criterion)criterion, aliases);
        }
        catch (Exception e) {
            throw new AutoScalingMetadataNotFoundException("Failed to find tags for " + LogUtil.dumpObject((Object)((Object)example)), e);
        }
    }

    public static Function<Tag, String> resourceId() {
        return TagFunctions.RESOURCE_ID;
    }

    public static Function<Tag, String> key() {
        return TagFunctions.KEY;
    }

    public static Function<Tag, String> value() {
        return TagFunctions.VALUE;
    }

    public static Function<Tag, String> propagateAtLaunch() {
        return TagFunctions.PROPAGATE_AT_LAUNCH;
    }

    public static void delete(Tag example) throws AutoScalingMetadataNotFoundException {
        EntityTransaction db = Entities.get(Tag.class);
        try {
            Tag entity = (Tag)((Object)Entities.uniqueResult((Object)((Object)example)));
            Entities.delete((Object)((Object)entity));
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
            throw new AutoScalingMetadataNotFoundException("Failed to find tag: " + example.getKey() + " for " + example.getOwner(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag createOrUpdate(Tag tag) {
        Tag result;
        String originalValue = tag.getValue();
        Boolean originalPropagate = tag.getPropagateAtLaunch();
        String originalUserId = tag.getOwnerUserId();
        String originalUserName = tag.getOwnerUserName();
        try {
            tag.setValue(null);
            tag.setOwnerUserId(null);
            tag.setOwnerUserName(null);
            tag.setPropagateAtLaunch(null);
            Tag existing = Tags.lookup(tag);
            existing.setValue(originalValue);
            existing.setPropagateAtLaunch(originalPropagate);
            result = existing;
        }
        catch (AutoScalingMetadataNotFoundException e) {
            tag.setValue(originalValue);
            tag.setPropagateAtLaunch(originalPropagate);
            tag.setOwnerUserId(originalUserId);
            tag.setOwnerUserName(originalUserName);
            Entities.persist((Object)((Object)tag));
            result = tag;
        }
        finally {
            tag.setValue(originalValue);
            tag.setOwnerUserId(originalUserId);
            tag.setOwnerUserName(originalUserName);
            tag.setPropagateAtLaunch(originalPropagate);
        }
        return result;
    }

    public static <T> void addFromTags(Collection<? super T> target, Class<T> targetItemType, Iterable<Tag> tags) {
        Iterables.addAll(target, (Iterable)Iterables.transform(tags, (Function)TypeMappers.lookup(Tag.class, targetItemType)));
    }

    private static Tag lookup(Tag example) throws AutoScalingMetadataNotFoundException {
        try {
            List result = Transactions.filter((Object)((Object)example), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)example.getResourceId()), Tags.resourceId()));
            if (result.size() == 1) {
                return (Tag)((Object)result.get(0));
            }
        }
        catch (Exception e) {
            throw new AutoScalingMetadataNotFoundException("Failed to find tag: " + example.getKey() + " for " + example.getOwner(), e);
        }
        throw new AutoScalingMetadataNotFoundException("Failed to find unique tag: " + example.getKey() + " for " + example.getOwner());
    }

    @TypeMapper
    public static enum TagToTagDescription implements Function<Tag, TagDescription>
    {
        INSTANCE;


        public TagDescription apply(Tag tag) {
            TagDescription tagDescription = new TagDescription();
            tagDescription.setResourceType(tag.getResourceType());
            tagDescription.setResourceId(tag.getResourceId());
            tagDescription.setKey(tag.getKey());
            tagDescription.setValue(tag.getValue());
            tagDescription.setPropagateAtLaunch(tag.getPropagateAtLaunch());
            return tagDescription;
        }
    }

    private static enum TagFunctions implements Function<Tag, String>
    {
        KEY{

            public String apply(Tag tag) {
                return tag.getKey();
            }
        }
        ,
        PROPAGATE_AT_LAUNCH{

            public String apply(Tag tag) {
                return Strings.toString((Object)tag.getPropagateAtLaunch());
            }
        }
        ,
        RESOURCE_TYPE{

            public String apply(Tag tag) {
                return tag.getResourceType();
            }
        }
        ,
        RESOURCE_ID{

            public String apply(Tag tag) {
                return tag.getResourceId();
            }
        }
        ,
        VALUE{

            public String apply(Tag tag) {
                return tag.getValue();
            }
        };

    }
}

