/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.tags;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataNotFoundException;
import com.eucalyptus.autoscaling.tags.Tag;
import com.eucalyptus.autoscaling.tags.Tags;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public abstract class TagSupport {
    private static final Logger log = Logger.getLogger(TagSupport.class);
    private static final ConcurrentMap<String, TagSupport> supportByResourceType = Maps.newConcurrentMap();
    private static final ConcurrentMap<Class<? extends AutoScalingMetadata>, TagSupport> supportByClass = Maps.newConcurrentMap();
    private static final LoadingCache<Class, Class> metadataClassMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, Class>(){

        public Class load(Class instanceClass) {
            ArrayList interfaces = Lists.newArrayList();
            for (Class clazz : (List)Classes.interfaceAncestors().apply((Object)instanceClass)) {
                interfaces.add(clazz);
            }
            Collections.reverse(interfaces);
            return (Class)Iterables.find((Iterable)interfaces, (Predicate)Predicates.and((Predicate)Predicates.not((Predicate)Predicates.equalTo(AutoScalingMetadata.class)), (Predicate)Classes.subclassOf(AutoScalingMetadata.class)));
        }
    });
    private final Class<? extends AbstractOwnedPersistent> resourceClass;
    private final Class<? extends AutoScalingMetadata> cloudMetadataClass;
    private final String resourceType;
    private final String resourceClassIdField;
    private final String tagClassResourceField;

    protected <T extends AbstractOwnedPersistent> TagSupport(@Nonnull Class<T> resourceClass, @Nonnull String resourceType, @Nonnull String resourceClassIdField, @Nonnull String tagClassResourceField) {
        this.resourceClass = resourceClass;
        this.cloudMetadataClass = TagSupport.subclassFor(resourceClass);
        this.resourceType = resourceType;
        this.resourceClassIdField = resourceClassIdField;
        this.tagClassResourceField = tagClassResourceField;
    }

    public abstract Tag createOrUpdate(AutoScalingMetadata var1, OwnerFullName var2, String var3, String var4, Boolean var5);

    public abstract Tag example(@Nonnull AutoScalingMetadata var1, @Nonnull OwnerFullName var2, @Nullable String var3, @Nullable String var4);

    public abstract Tag example(@Nonnull OwnerFullName var1);

    protected <T extends Tag> T example(@Nonnull T tag, @Nonnull OwnerFullName ownerFullName) {
        tag.setOwner(ownerFullName);
        return tag;
    }

    public abstract AutoScalingMetadata lookup(OwnerFullName var1, String var2) throws TransactionException;

    public Map<String, List<Tag>> getResourceTagMap(OwnerFullName owner, Iterable<String> identifiers, Predicate<? super Tag> tagPredicate) {
        HashMap tagMap = Maps.newHashMap();
        for (String id : identifiers) {
            tagMap.put(id, Lists.newArrayList());
        }
        if (!tagMap.isEmpty()) {
            Tag example = this.example(owner);
            DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.resourceClass).add(Restrictions.in((String)this.resourceClassIdField, (Collection)Lists.newArrayList(identifiers))).setProjection((Projection)Projections.id());
            Criterion idRestriction = Property.forName((String)this.tagClassResourceField).in(detachedCriteria);
            try {
                List<Tag> tags = Tags.list(example, tagPredicate, idRestriction, Collections.emptyMap());
                for (Tag tag : tags) {
                    ((List)tagMap.get(tag.getResourceId())).add(tag);
                }
            }
            catch (AutoScalingMetadataNotFoundException e) {
                log.error((Object)e, (Throwable)e);
            }
            Ordering order = Ordering.natural().onResultOf(Tags.key());
            for (String id : identifiers) {
                Collections.sort((List)tagMap.get(id), order);
            }
        }
        return tagMap;
    }

    public List<Tag> getResourceTags(OwnerFullName owner, String identifier, Predicate<? super Tag> tagPredicate) {
        return this.getResourceTagMap(owner, Collections.singleton(identifier), tagPredicate).get(identifier);
    }

    @Nonnull
    public Class<? extends AutoScalingMetadata> getCloudMetadataClass() {
        return this.cloudMetadataClass;
    }

    @Nonnull
    public String getResourceType() {
        return this.resourceType;
    }

    public static TagSupport forResourceClass(@Nonnull Class<? extends AutoScalingMetadata> metadataClass) {
        return (TagSupport)supportByClass.get(TagSupport.subclassFor(metadataClass));
    }

    public static TagSupport fromResource(@Nonnull AutoScalingMetadata metadata) {
        return (TagSupport)supportByClass.get(TagSupport.subclassFor(metadata.getClass()));
    }

    public static TagSupport fromResourceType(@Nonnull String resourceType) {
        return (TagSupport)supportByResourceType.get(resourceType);
    }

    static void registerTagSupport(@Nonnull TagSupport tagSupport) {
        supportByClass.put(tagSupport.getCloudMetadataClass(), tagSupport);
        supportByResourceType.put(tagSupport.getResourceType(), tagSupport);
    }

    private static Class<? extends AutoScalingMetadata> subclassFor(Class<? extends AutoScalingMetadata> metadataInstance) {
        return (Class)metadataClassMap.getUnchecked(metadataInstance);
    }

    Class<? extends AbstractOwnedPersistent> getResourceClass() {
        return this.resourceClass;
    }

    String getResourceClassIdField() {
        return this.resourceClassIdField;
    }

    String getTagClassResourceField() {
        return this.tagClassResourceField;
    }
}

