/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.tags;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_autoscaling")
@Table(name="metadata_tags")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="metadata_tag_resource_type", discriminatorType=DiscriminatorType.STRING, length=32)
@AttributeOverride(name="displayName", column=@Column(name="metadata_display_name", updatable=false, nullable=false, length=128))
public class Tag<T extends Tag<T>>
extends AbstractOwnedPersistent
implements AutoScalingMetadata.AutoScalingTagMetadata {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_resource_id", nullable=false)
    private String resourceId;
    @Column(name="metadata_tag_value", nullable=false, length=256)
    private String value;
    @Column(name="metadata_propagate_at_launch", nullable=false)
    private Boolean propagateAtLaunch;
    @Transient
    @Nonnull
    private Function<? super T, String> resourceIdFunction = Functions.constant(null);
    @Transient
    @Nullable
    private String resourceType;

    protected Tag() {
    }

    protected Tag(@Nullable String resourceType, @Nonnull Function<? super T, String> resourceIdFunction) {
        this.resourceType = resourceType;
        this.resourceIdFunction = resourceIdFunction;
    }

    public Tag(@Nullable String resourceType, @Nonnull Function<? super T, String> resourceIdFunction, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value, @Nullable Boolean propagateAtLaunch) {
        this(resourceType, resourceIdFunction);
        this.setOwner(ownerFullName);
        this.setDisplayName(key);
        this.setValue(value);
        this.setPropagateAtLaunch(propagateAtLaunch);
    }

    protected String createUniqueName() {
        return this.getOwnerAccountNumber() + ":" + this.getResourceType() + ":" + this.getResourceId() + ":" + this.getKey();
    }

    public String getKey() {
        return this.getDisplayName();
    }

    public void setKey(String key) {
        this.setDisplayName(key);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    public Boolean getPropagateAtLaunch() {
        return this.propagateAtLaunch;
    }

    public void setPropagateAtLaunch(Boolean propagateAtLaunch) {
        this.propagateAtLaunch = propagateAtLaunch;
    }

    @Nullable
    public String getResourceId() {
        return this.resourceId != null ? this.resourceId : this.extractResourceId();
    }

    @Nullable
    public String getResourceType() {
        return this.resourceType;
    }

    public static Tag withOwner(@Nonnull OwnerFullName ownerFullName) {
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new Tag(null, Functions.constant(null), ownerFullName, null, null, null);
    }

    protected void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    private String extractResourceId() {
        return (String)this.resourceIdFunction.apply((Object)this);
    }

    @PrePersist
    @PreUpdate
    private void generatedFieldUpdate() {
        this.setResourceId(this.extractResourceId());
    }
}

