/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.tags;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.tags.Tag;
import com.eucalyptus.autoscaling.tags.TagSupport;
import com.eucalyptus.autoscaling.tags.Tags;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_autoscaling")
@Table(name="metadata_tags_groups")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="auto-scaling-group")
public class AutoScalingGroupTag
extends Tag<AutoScalingGroupTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private AutoScalingGroup group;

    protected AutoScalingGroupTag() {
        super("auto-scaling-group", ResourceIdFunction.INSTANCE);
    }

    public AutoScalingGroupTag(@Nonnull AutoScalingGroup group, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value, @Nullable Boolean propagateAtLaunch) {
        super("auto-scaling-group", ResourceIdFunction.INSTANCE, ownerFullName, key, value, propagateAtLaunch);
        this.setGroup(group);
        this.setResourceId(this.getResourceId());
    }

    public AutoScalingGroup getGroup() {
        return this.group;
    }

    public void setGroup(AutoScalingGroup group) {
        this.group = group;
    }

    @Nonnull
    public static Tag named(@Nonnull AutoScalingGroup group, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return AutoScalingGroupTag.namedWithValue(group, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull AutoScalingGroup group, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)group), (Object)"auto-scaling-group");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new AutoScalingGroupTag(group, ownerFullName, key, value, null);
    }

    @Nonnull
    public static AutoScalingGroupTag createUnassigned() {
        return new AutoScalingGroupTag();
    }

    public static class AutoScalingGroupTagSupport
    extends TagSupport {
        public AutoScalingGroupTagSupport() {
            super(AutoScalingGroup.class, "auto-scaling-group", "displayName", "group");
        }

        @Override
        public Tag createOrUpdate(AutoScalingMetadata metadata, OwnerFullName ownerFullName, String key, String value, Boolean propagateAtLaunch) {
            return Tags.createOrUpdate(new AutoScalingGroupTag((AutoScalingGroup)metadata, ownerFullName, key, value, propagateAtLaunch));
        }

        @Override
        public Tag example(@Nonnull AutoScalingMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return AutoScalingGroupTag.namedWithValue((AutoScalingGroup)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new AutoScalingGroupTag(), ownerFullName);
        }

        public AutoScalingGroup lookup(OwnerFullName owner, String identifier) throws TransactionException {
            return (AutoScalingGroup)((Object)Entities.uniqueResult((Object)((Object)AutoScalingGroup.named(owner, identifier))));
        }
    }

    private static enum ResourceIdFunction implements Function<AutoScalingGroupTag, String>
    {
        INSTANCE{

            public String apply(AutoScalingGroupTag autoScalingGroupTag) {
                return autoScalingGroupTag.getGroup().getAutoScalingGroupName();
            }
        };

    }
}

