/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.policy;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.util.RestrictedTypes;
import net.sf.json.JSONException;

abstract class AutoScalingNumberQuotaKeySupport<T extends AutoScalingMetadata>
extends QuotaKey {
    private final String key;
    private final String action;
    private final Class<T> metadataClass;

    AutoScalingNumberQuotaKeySupport(String key, String action, Class<T> metadataClass) {
        this.key = key;
        this.action = action;
        this.metadataClass = metadataClass;
    }

    public final void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)this.key);
    }

    public final boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"autoscaling", (String)this.action).equals(action);
    }

    public final String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        switch (scope) {
            case ACCOUNT: {
                return Long.toString((Long)RestrictedTypes.quantityMetricFunction(this.metadataClass).apply((Object)AccountFullName.getInstance((String)id, (String[])new String[0])) + 1L);
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                return Long.toString((Long)RestrictedTypes.quantityMetricFunction(this.metadataClass).apply((Object)UserFullName.getInstance((String)id, (String[])new String[0])) + 1L);
            }
        }
        throw new AuthException("Invalid scope");
    }
}

