/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.policies;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.policies.AdjustmentType;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_autoscaling")
@Table(name="metadata_scaling_policies")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ScalingPolicy
extends AbstractOwnedPersistent
implements AutoScalingMetadata.ScalingPolicyMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_group_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private AutoScalingGroup group;
    @Column(name="metadata_auto_scaling_group_name", nullable=false)
    private String autoScalingGroupName;
    @Column(name="metadata_scaling_adjustment", nullable=false)
    private Integer scalingAdjustment;
    @Column(name="metadata_min_adjustment_step")
    private Integer minAdjustmentStep;
    @Column(name="metadata_cooldown")
    private Integer cooldown;
    @Column(name="metadata_adjustment_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AdjustmentType adjustmentType;

    protected ScalingPolicy() {
    }

    protected ScalingPolicy(OwnerFullName owner) {
        super(owner);
    }

    protected ScalingPolicy(OwnerFullName owner, AutoScalingGroup group, String displayName) {
        super(owner, displayName);
        this.setGroup(group);
    }

    public String getPolicyName() {
        return this.getDisplayName();
    }

    public AutoScalingGroup getGroup() {
        return this.group;
    }

    public void setGroup(AutoScalingGroup group) {
        this.group = group;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public Integer getScalingAdjustment() {
        return this.scalingAdjustment;
    }

    public void setScalingAdjustment(Integer scalingAdjustment) {
        this.scalingAdjustment = scalingAdjustment;
    }

    public Integer getMinAdjustmentStep() {
        return this.minAdjustmentStep;
    }

    public void setMinAdjustmentStep(Integer minAdjustmentStep) {
        this.minAdjustmentStep = minAdjustmentStep;
    }

    public Integer getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(Integer cooldown) {
        this.cooldown = cooldown;
    }

    public AdjustmentType getAdjustmentType() {
        return this.adjustmentType;
    }

    public void setAdjustmentType(AdjustmentType adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public String getArn() {
        return String.format("arn:aws:autoscaling::%1s:scalingPolicy:%2s:autoScalingGroupName/%3s:policyName/%4s", this.getOwnerAccountNumber(), this.getNaturalId(), this.group == null ? "" : this.group.getAutoScalingGroupName(), this.getPolicyName());
    }

    public static ScalingPolicy withOwner(OwnerFullName ownerFullName) {
        return new ScalingPolicy(ownerFullName);
    }

    public static ScalingPolicy named(OwnerFullName ownerFullName, String autoScalingGroupName, String policyName) {
        ScalingPolicy example = ScalingPolicy.withOwner(ownerFullName);
        example.setAutoScalingGroupName(autoScalingGroupName);
        example.setDisplayName(policyName);
        return example;
    }

    public static ScalingPolicy withId(String id) {
        ScalingPolicy example = new ScalingPolicy();
        example.setId(id);
        return example;
    }

    public static ScalingPolicy withUuid(String uuid) {
        ScalingPolicy example = new ScalingPolicy();
        example.setNaturalId(uuid);
        return example;
    }

    public static ScalingPolicy create(OwnerFullName ownerFullName, AutoScalingGroup autoScalingGroup, String name, AdjustmentType adjustmentType, Integer scalingAdjustment) {
        ScalingPolicy scalingPolicy = new ScalingPolicy(ownerFullName, autoScalingGroup, name);
        scalingPolicy.setAdjustmentType(adjustmentType);
        scalingPolicy.setScalingAdjustment(scalingAdjustment);
        return scalingPolicy;
    }

    protected String createUniqueName() {
        return this.getOwnerAccountNumber() != null && this.getGroup() != null && this.getDisplayName() != null ? this.getOwnerAccountNumber() + ":" + this.getGroup().getDisplayName() + ":" + this.getDisplayName() : null;
    }

    @PrePersist
    @PreUpdate
    private void preUpdate() {
        this.autoScalingGroupName = (String)AutoScalingMetadatas.toDisplayName().apply((Object)this.group);
    }

    protected static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        private final OwnerFullName ownerFullName;
        private final AutoScalingGroup autoScalingGroup;
        private final String name;
        private final AdjustmentType adjustmentType;
        private final Integer scalingAdjustment;
        private Integer cooldown;
        private Integer minAdjustmentStep;

        BaseBuilder(OwnerFullName ownerFullName, AutoScalingGroup autoScalingGroup, String name, AdjustmentType adjustmentType, Integer scalingAdjustment) {
            this.ownerFullName = ownerFullName;
            this.autoScalingGroup = autoScalingGroup;
            this.name = name;
            this.adjustmentType = adjustmentType;
            this.scalingAdjustment = scalingAdjustment;
        }

        protected abstract T builder();

        public T withCooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this.builder();
        }

        public T withMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this.builder();
        }

        protected ScalingPolicy build() {
            ScalingPolicy policy = ScalingPolicy.create(this.ownerFullName, this.autoScalingGroup, this.name, this.adjustmentType, this.scalingAdjustment);
            policy.setCooldown(this.cooldown);
            policy.setMinAdjustmentStep(this.minAdjustmentStep);
            return policy;
        }
    }
}

