/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.policies;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.common.backend.msgs.ScalingPolicyType;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.autoscaling.policies.AdjustmentType;
import com.eucalyptus.autoscaling.policies.ScalingPolicy;
import com.eucalyptus.autoscaling.policies.ScalingPolicyView;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import javax.persistence.EntityTransaction;

public abstract class ScalingPolicies {
    public abstract <T> List<T> list(OwnerFullName var1, Predicate<? super ScalingPolicy> var2, Function<? super ScalingPolicy, T> var3) throws AutoScalingMetadataException;

    public abstract <T> T lookup(OwnerFullName var1, String var2, String var3, Function<? super ScalingPolicy, T> var4) throws AutoScalingMetadataException;

    public abstract ScalingPolicy update(OwnerFullName var1, String var2, String var3, Callback<ScalingPolicy> var4) throws AutoScalingMetadataException;

    public abstract boolean delete(AutoScalingMetadata.ScalingPolicyMetadata var1) throws AutoScalingMetadataException;

    public abstract ScalingPolicy save(ScalingPolicy var1) throws AutoScalingMetadataException;

    public final PersistingBuilder create(OwnerFullName ownerFullName, AutoScalingGroup autoScalingGroup, String policyName, AdjustmentType adjustmentType, Integer scalingAdjustment) {
        return new PersistingBuilder(this, ownerFullName, autoScalingGroup, policyName, adjustmentType, scalingAdjustment);
    }

    public static Function<ScalingPolicy, String> toGroupName() {
        return ScalingPolicyProperties.GROUP_NAME;
    }

    public static Function<ScalingPolicy, String> toGroupUuid() {
        return ScalingPolicyProperties.GROUP_UUID;
    }

    private static enum ScalingPolicyProperties implements Function<ScalingPolicy, String>
    {
        GROUP_NAME{

            public String apply(ScalingPolicy scalingPolicy) {
                return (String)AutoScalingMetadatas.toDisplayName().apply((Object)scalingPolicy.getGroup());
            }
        }
        ,
        GROUP_UUID{

            public String apply(ScalingPolicy scalingPolicy) {
                return scalingPolicy.getGroup() == null ? null : scalingPolicy.getGroup().getNaturalId();
            }
        };

    }

    @RestrictedTypes.QuantityMetricFunction(value=AutoScalingMetadata.ScalingPolicyMetadata.class)
    public static enum CountScalingPolicies implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long apply(OwnerFullName input) {
            EntityTransaction db = Entities.get(ScalingPolicy.class);
            try {
                Long l = Entities.count((Object)((Object)ScalingPolicy.withOwner(input)));
                return l;
            }
            finally {
                db.rollback();
            }
        }
    }

    @TypeMapper
    public static enum ScalingPolicyTransform implements Function<ScalingPolicy, ScalingPolicyType>
    {
        INSTANCE;


        public ScalingPolicyType apply(ScalingPolicy policy) {
            ScalingPolicyType type = new ScalingPolicyType();
            type.setPolicyARN(policy.getArn());
            type.setPolicyName(policy.getPolicyName());
            if (policy.getGroup() != null) {
                type.setAutoScalingGroupName(policy.getGroup().getAutoScalingGroupName());
            }
            type.setAdjustmentType(Strings.toString((Object)((Object)policy.getAdjustmentType())));
            type.setScalingAdjustment(policy.getScalingAdjustment());
            type.setMinAdjustmentStep(policy.getMinAdjustmentStep());
            type.setCooldown(policy.getCooldown());
            return type;
        }
    }

    @TypeMapper
    public static enum ScalingPolicyViewTransform implements Function<ScalingPolicy, ScalingPolicyView>
    {
        INSTANCE;


        public ScalingPolicyView apply(ScalingPolicy scalingPolicy) {
            return new ScalingPolicyView(scalingPolicy);
        }
    }

    public static class PersistingBuilder
    extends ScalingPolicy.BaseBuilder<PersistingBuilder> {
        private final ScalingPolicies scalingPolicies;

        PersistingBuilder(ScalingPolicies scalingPolicies, OwnerFullName ownerFullName, AutoScalingGroup autoScalingGroup, String name, AdjustmentType adjustmentType, Integer scalingAdjustment) {
            super(ownerFullName, autoScalingGroup, name, adjustmentType, scalingAdjustment);
            this.scalingPolicies = scalingPolicies;
        }

        @Override
        protected PersistingBuilder builder() {
            return this;
        }

        public ScalingPolicy persist() throws AutoScalingMetadataException {
            return this.scalingPolicies.save(this.build());
        }
    }
}

