/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.policies;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingResourceName;
import com.eucalyptus.autoscaling.metadata.AbstractOwnedPersistentsWithResourceNameSupport;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.autoscaling.policies.ScalingPolicies;
import com.eucalyptus.autoscaling.policies.ScalingPolicy;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;

@ComponentNamed
public class PersistenceScalingPolicies
extends ScalingPolicies {
    private final PersistenceSupport persistenceSupport = new PersistenceSupport();

    @Override
    public <T> List<T> list(OwnerFullName ownerFullName, Predicate<? super ScalingPolicy> filter, Function<? super ScalingPolicy, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.list(ownerFullName, filter, transform);
    }

    @Override
    public <T> T lookup(OwnerFullName ownerFullName, String autoScalingGroupName, String policyName, Function<? super ScalingPolicy, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.lookup(ownerFullName, autoScalingGroupName, policyName, transform);
    }

    @Override
    public ScalingPolicy update(OwnerFullName ownerFullName, String autoScalingGroupName, String policyName, Callback<ScalingPolicy> policyUpdateCallback) throws AutoScalingMetadataException {
        return this.persistenceSupport.update(ownerFullName, autoScalingGroupName, policyName, policyUpdateCallback);
    }

    @Override
    public boolean delete(AutoScalingMetadata.ScalingPolicyMetadata scalingPolicy) throws AutoScalingMetadataException {
        return this.persistenceSupport.delete((AutoScalingMetadata)scalingPolicy);
    }

    @Override
    public ScalingPolicy save(ScalingPolicy scalingPolicy) throws AutoScalingMetadataException {
        return (ScalingPolicy)this.persistenceSupport.save((AbstractPersistent)scalingPolicy);
    }

    private static class PersistenceSupport
    extends AbstractOwnedPersistentsWithResourceNameSupport<ScalingPolicy> {
        private PersistenceSupport() {
            super(AutoScalingResourceName.Type.scalingPolicy);
        }

        protected ScalingPolicy exampleWithOwner(OwnerFullName ownerFullName) {
            return ScalingPolicy.withOwner(ownerFullName);
        }

        protected ScalingPolicy exampleWithName(OwnerFullName ownerFullName, String name) {
            throw new IllegalStateException("Unscoped name not supported.");
        }

        @Override
        protected ScalingPolicy exampleWithName(OwnerFullName ownerFullName, String scope, String name) {
            return ScalingPolicy.named(ownerFullName, scope, name);
        }

        @Override
        protected ScalingPolicy exampleWithUuid(String uuid) {
            return ScalingPolicy.withUuid(uuid);
        }
    }
}

