/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.policies;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.util.OwnerFullName;

public enum AdjustmentType implements AutoScalingMetadata.AdjustmentTypeMetadata
{
    ChangeInCapacity{

        @Override
        public int adjustCapacity(int currentCapacity, int adjustmentStep, int minAdjustment) {
            return currentCapacity + adjustmentStep;
        }
    }
    ,
    ExactCapacity{

        @Override
        public int adjustCapacity(int currentCapacity, int adjustmentStep, int minAdjustment) {
            return adjustmentStep;
        }
    }
    ,
    PercentChangeInCapacity{

        @Override
        public int adjustCapacity(int currentCapacity, int adjustmentStep, int minAdjustment) {
            double multiplier = (double)Math.abs(adjustmentStep) / 100.0;
            int adjustment = Math.max((int)Math.floor((double)currentCapacity * multiplier), Math.max(Math.abs(minAdjustment), 1));
            return currentCapacity + adjustment * (adjustmentStep < 0 ? -1 : 1);
        }
    };


    public String getDisplayName() {
        return this.name();
    }

    public OwnerFullName getOwner() {
        return Principals.systemFullName();
    }

    public final int adjustCapacity(int currentCapacity, int adjustmentStep, int minAdjustment, int minSize, int maxSize) {
        int adjusted = this.adjustCapacity(currentCapacity, adjustmentStep, minAdjustment);
        adjusted = Math.min(adjusted, maxSize);
        adjusted = Math.max(adjusted, minSize);
        return adjusted;
    }

    public abstract int adjustCapacity(int var1, int var2, int var3);
}

