/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.metadata;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingResourceName;
import com.eucalyptus.autoscaling.metadata.AbstractOwnedPersistents;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;

public abstract class AbstractOwnedPersistentsWithResourceNameSupport<AOP extends AbstractOwnedPersistent>
extends AbstractOwnedPersistents<AOP> {
    private final AutoScalingResourceName.Type type;
    @Nullable
    private final AutoScalingResourceName.Type scopeType;

    protected AbstractOwnedPersistentsWithResourceNameSupport(AutoScalingResourceName.Type type) {
        this(type, null);
    }

    protected AbstractOwnedPersistentsWithResourceNameSupport(AutoScalingResourceName.Type type, @Nullable AutoScalingResourceName.Type scopeType) {
        super(type.describe());
        this.type = type;
        this.scopeType = scopeType;
    }

    public final <T> T lookup(OwnerFullName ownerFullName, String nameOrArn, Function<? super AOP, T> transform) throws AutoScalingMetadataException {
        return this.lookup(ownerFullName, null, nameOrArn, transform);
    }

    public final <T> T lookup(OwnerFullName ownerFullName, @Nullable String scopeNameOrArn, String nameOrArn, Function<? super AOP, T> transform) throws AutoScalingMetadataException {
        if (AutoScalingResourceName.isResourceName().apply((Object)nameOrArn)) {
            return this.lookupByUuid(AutoScalingResourceName.parse((String)nameOrArn, (AutoScalingResourceName.Type)this.type).getUuid(), Predicates.alwaysTrue(), transform);
        }
        String scopeName = this.getNameFromScopeNameOrArn(scopeNameOrArn);
        return this.lookupByName(ownerFullName, scopeName, nameOrArn, transform);
    }

    public AOP update(OwnerFullName ownerFullName, String nameOrArn, Callback<AOP> updateCallback) throws AutoScalingMetadataException {
        return this.update(ownerFullName, null, nameOrArn, updateCallback);
    }

    public AOP update(OwnerFullName ownerFullName, @Nullable String scopeNameOrArn, String nameOrArn, Callback<AOP> updateCallback) throws AutoScalingMetadataException {
        AOP example;
        if (AutoScalingResourceName.isResourceName().apply((Object)nameOrArn)) {
            example = this.exampleWithUuid(AutoScalingResourceName.parse((String)nameOrArn, (AutoScalingResourceName.Type)this.type).getUuid());
        } else {
            String scopeName = this.getNameFromScopeNameOrArn(scopeNameOrArn);
            example = this.exampleWithName(ownerFullName, scopeName, nameOrArn);
        }
        return (AOP)((AbstractOwnedPersistent)this.updateByExample((AbstractPersistent)example, ownerFullName, nameOrArn, (Callback)updateCallback));
    }

    protected AOP exampleWithName(OwnerFullName ownerFullName, String scope, String name) {
        return (AOP)((AbstractOwnedPersistent)this.exampleWithName(ownerFullName, name));
    }

    protected <T> T lookupByUuid(String uuid, Predicate<? super AOP> filter, Function<? super AOP, T> transform) throws AutoScalingMetadataException {
        return (T)this.lookupByExample((AbstractPersistent)this.exampleWithUuid(uuid), null, uuid, (Predicate)filter, (Function)transform);
    }

    protected <T> T lookupByName(OwnerFullName ownerFullName, String scope, String name, Function<? super AOP, T> transform) throws AutoScalingMetadataException {
        return (T)this.lookupByExample((AbstractPersistent)this.exampleWithName(ownerFullName, scope, name), ownerFullName, name, Predicates.alwaysTrue(), (Function)transform);
    }

    public boolean delete(AutoScalingMetadata metadata) throws AutoScalingMetadataException {
        try {
            return !this.withRetries().deleteByExample(metadata instanceof AutoScalingMetadata.AutoScalingMetadataWithResourceName ? this.exampleWithUuid(AutoScalingResourceName.parse((String)((AutoScalingMetadata.AutoScalingMetadataWithResourceName)metadata).getArn(), (AutoScalingResourceName.Type)this.type).getUuid()) : (AbstractOwnedPersistent)this.exampleWithName((OwnerFullName)AccountFullName.getInstance((String)metadata.getOwner().getAccountNumber(), (String[])new String[0]), metadata.getDisplayName())).isEmpty();
        }
        catch (Exception e) {
            throw new AutoScalingMetadataException("Error deleting " + this.typeDescription + " '" + this.describe((RestrictedType)metadata) + "'", e);
        }
    }

    protected final String describe(RestrictedType metadata) {
        if (metadata instanceof AutoScalingMetadata.AutoScalingMetadataWithResourceName) {
            return ((AutoScalingMetadata.AutoScalingMetadataWithResourceName)metadata).getArn();
        }
        return super.describe(metadata);
    }

    protected abstract AOP exampleWithUuid(String var1);

    private String getNameFromScopeNameOrArn(String scopeNameOrArn) {
        String scopeName = scopeNameOrArn != null && this.scopeType != null && AutoScalingResourceName.isResourceName().apply((Object)scopeNameOrArn) ? AutoScalingResourceName.parse((String)scopeNameOrArn, (AutoScalingResourceName.Type)this.type).getName(this.scopeType) : scopeNameOrArn;
        return scopeName;
    }
}

