/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.instances;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.instances.AutoScalingInstances;
import com.eucalyptus.autoscaling.instances.ConfigurationState;
import com.eucalyptus.autoscaling.instances.HealthStatus;
import com.eucalyptus.autoscaling.instances.LifecycleState;
import com.eucalyptus.autoscaling.metadata.AbstractOwnedPersistents;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataNotFoundException;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceAutoScalingInstances
extends AutoScalingInstances {
    private final Logger logger = Logger.getLogger(PersistenceAutoScalingInstances.class);
    private PersistenceSupport persistenceSupport = new PersistenceSupport();

    @Override
    public <T> List<T> list(OwnerFullName ownerFullName, Predicate<? super AutoScalingInstance> filter, Function<? super AutoScalingInstance, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.list(ownerFullName, filter, transform);
    }

    @Override
    public <T> List<T> listByGroup(OwnerFullName ownerFullName, String groupName, Function<? super AutoScalingInstance, T> transform) throws AutoScalingMetadataException {
        AutoScalingInstance example = AutoScalingInstance.withOwner(ownerFullName);
        example.setAutoScalingGroupName(groupName);
        return this.persistenceSupport.listByExample((AbstractPersistent)example, Predicates.alwaysTrue(), transform);
    }

    @Override
    public <T> List<T> listByGroup(AutoScalingMetadata.AutoScalingGroupMetadata group, Predicate<? super AutoScalingInstance> filter, Function<? super AutoScalingInstance, T> transform) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        return this.persistenceSupport.listByExample((AbstractPersistent)example, filter, transform);
    }

    @Override
    public <T> List<T> listByState(LifecycleState lifecycleState, ConfigurationState configurationState, Function<? super AutoScalingInstance, T> transform) throws AutoScalingMetadataException {
        AutoScalingInstance example = AutoScalingInstance.withStates(lifecycleState, configurationState);
        return this.persistenceSupport.listByExample((AbstractPersistent)example, Predicates.and((Predicate)lifecycleState, (Predicate)configurationState), transform);
    }

    @Override
    public <T> List<T> listUnhealthyByGroup(AutoScalingMetadata.AutoScalingGroupMetadata group, Function<? super AutoScalingInstance, T> transform) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        example.setHealthStatus(HealthStatus.Unhealthy);
        return this.persistenceSupport.listByExample((AbstractPersistent)example, Predicates.alwaysTrue(), transform);
    }

    @Override
    public <T> T lookup(OwnerFullName ownerFullName, String instanceId, Function<? super AutoScalingInstance, T> transform) throws AutoScalingMetadataException {
        return (T)this.persistenceSupport.lookupByExample((AbstractPersistent)this.persistenceSupport.exampleWithName(ownerFullName, instanceId), ownerFullName, instanceId, Predicates.alwaysTrue(), transform);
    }

    @Override
    public void update(OwnerFullName ownerFullName, String instanceId, Callback<AutoScalingInstance> instanceUpdateCallback) throws AutoScalingMetadataException {
        this.persistenceSupport.updateByExample((AbstractPersistent)this.persistenceSupport.exampleWithName(ownerFullName, instanceId), ownerFullName, instanceId, instanceUpdateCallback);
    }

    @Override
    public void markMissingInstancesUnhealthy(AutoScalingMetadata.AutoScalingGroupMetadata group, Collection<String> instanceIds) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        example.setHealthStatus(HealthStatus.Healthy);
        List instancesToMark = this.persistenceSupport.listByExample((AbstractPersistent)example, LifecycleState.InService, (Criterion)(instanceIds.isEmpty() ? Restrictions.conjunction() : Restrictions.not((Criterion)Property.forName((String)"displayName").in(instanceIds))), Collections.emptyMap(), Functions.identity());
        for (AutoScalingInstance instance : instancesToMark) {
            try {
                this.persistenceSupport.updateByExample((AbstractPersistent)AutoScalingInstance.withUuid(instance.getNaturalId()), group.getOwner(), instance.getInstanceId(), (Callback)new Callback<AutoScalingInstance>(){

                    public void fire(AutoScalingInstance instance) {
                        if (instance.healthStatusGracePeriodExpired()) {
                            PersistenceAutoScalingInstances.this.logger.info((Object)("Marking instance unhealthy: " + instance.getInstanceId()));
                            instance.setHealthStatus(HealthStatus.Unhealthy);
                        } else {
                            PersistenceAutoScalingInstances.this.logger.debug((Object)("Instance not healthy but within grace period: " + instance.getInstanceId()));
                        }
                    }
                });
            }
            catch (AutoScalingMetadataNotFoundException autoScalingMetadataNotFoundException) {}
        }
    }

    @Override
    public void markExpiredPendingUnhealthy(AutoScalingMetadata.AutoScalingGroupMetadata group, Collection<String> instanceIds, final long maxAge) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        example.setHealthStatus(HealthStatus.Healthy);
        List instancesToMark = instanceIds.isEmpty() ? Collections.emptyList() : this.persistenceSupport.listByExample((AbstractPersistent)example, LifecycleState.Pending, Property.forName((String)"displayName").in(instanceIds), Collections.emptyMap(), Functions.identity());
        for (AutoScalingInstance instance : instancesToMark) {
            try {
                this.persistenceSupport.updateByExample((AbstractPersistent)AutoScalingInstance.withUuid(instance.getNaturalId()), group.getOwner(), instance.getInstanceId(), (Callback)new Callback<AutoScalingInstance>(){

                    public void fire(AutoScalingInstance instance) {
                        if (instance.getCreationTimestamp().getTime() < maxAge) {
                            PersistenceAutoScalingInstances.this.logger.info((Object)("Marking pending instance unhealthy: " + instance.getInstanceId()));
                            instance.setHealthStatus(HealthStatus.Unhealthy);
                        } else {
                            PersistenceAutoScalingInstances.this.logger.debug((Object)("Not marking pending instance unhealthy (within timeout): " + instance.getInstanceId()));
                        }
                    }
                });
            }
            catch (AutoScalingMetadataNotFoundException autoScalingMetadataNotFoundException) {}
        }
    }

    @Override
    public Set<String> verifyInstanceIds(String accountNumber, Collection<String> instanceIds) throws AutoScalingMetadataException {
        HashSet verifiedInstanceIds = Sets.newHashSet();
        if (!instanceIds.isEmpty()) {
            AutoScalingInstance example = AutoScalingInstance.withOwner(accountNumber);
            Criterion idCriterion = Property.forName((String)"displayName").in(instanceIds);
            Iterables.addAll((Collection)verifiedInstanceIds, (Iterable)this.persistenceSupport.listByExample((AbstractPersistent)example, Predicates.alwaysTrue(), idCriterion, Collections.emptyMap(), AutoScalingInstances.instanceId()));
        }
        return verifiedInstanceIds;
    }

    @Override
    public void transitionState(AutoScalingMetadata.AutoScalingGroupMetadata group, LifecycleState from, LifecycleState to, Collection<String> instanceIds) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        example.setLifecycleState(from);
        this.updateInstances(example, from, from.transitionTo(to), instanceIds);
    }

    @Override
    public void transitionConfigurationState(AutoScalingMetadata.AutoScalingGroupMetadata group, ConfigurationState from, ConfigurationState to, Collection<String> instanceIds) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        example.setConfigurationState(from);
        this.updateInstances(example, from, from.transitionTo(to), instanceIds);
    }

    @Override
    public int registrationFailure(AutoScalingMetadata.AutoScalingGroupMetadata group, Collection<String> instanceIds) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        final HashMap failureCountMap = Maps.newHashMap();
        this.updateInstances(example, (Predicate<? super AutoScalingInstance>)Predicates.alwaysTrue(), (Predicate<? super AutoScalingInstance>)new Predicate<AutoScalingInstance>(){

            public boolean apply(AutoScalingInstance instance) {
                failureCountMap.put(instance.getInstanceId(), instance.incrementRegistrationAttempts());
                return true;
            }
        }, instanceIds);
        return (Integer)CollectionUtils.reduce(failureCountMap.values(), (Object)Integer.MAX_VALUE, (Function)CollectionUtils.min());
    }

    @Override
    public boolean delete(AutoScalingMetadata.AutoScalingInstanceMetadata autoScalingInstance) throws AutoScalingMetadataException {
        return this.persistenceSupport.delete((RestrictedType)autoScalingInstance);
    }

    @Override
    public boolean deleteByGroup(AutoScalingMetadata.AutoScalingGroupMetadata group) throws AutoScalingMetadataException {
        AutoScalingInstance example = this.exampleForGroup(group);
        return !this.persistenceSupport.deleteByExample((AbstractPersistent)example).isEmpty();
    }

    @Override
    public AutoScalingInstance save(AutoScalingInstance autoScalingInstance) throws AutoScalingMetadataException {
        return (AutoScalingInstance)this.persistenceSupport.save((AbstractPersistent)autoScalingInstance);
    }

    private AutoScalingInstance exampleForGroup(AutoScalingMetadata.AutoScalingGroupMetadata group) {
        AutoScalingInstance example = AutoScalingInstance.withOwner(group.getOwner());
        example.clearUserIdentity();
        example.setAutoScalingGroupName(group.getDisplayName());
        return example;
    }

    private void updateInstances(final AutoScalingInstance fromExample, final Predicate<? super AutoScalingInstance> fromPredicate, final Predicate<? super AutoScalingInstance> updatePredicate, final Collection<String> instanceIds) throws AutoScalingMetadataException {
        AbstractOwnedPersistents.WorkCallback<Void> updateCallback = new AbstractOwnedPersistents.WorkCallback<Void>(){

            @Override
            public Void doWork() throws AutoScalingMetadataException {
                List instances = PersistenceAutoScalingInstances.this.persistenceSupport.listByExample((AbstractPersistent)fromExample, fromPredicate, Property.forName((String)"displayName").in(instanceIds), Collections.emptyMap(), Functions.identity());
                CollectionUtils.each((Iterable)instances, (Predicate)updatePredicate);
                return null;
            }
        };
        this.persistenceSupport.transactionWithRetry(AutoScalingInstance.class, updateCallback);
    }

    private static class PersistenceSupport
    extends AbstractOwnedPersistents<AutoScalingInstance> {
        private PersistenceSupport() {
            super("auto scaling instance");
        }

        protected AutoScalingInstance exampleWithOwner(OwnerFullName ownerFullName) {
            return AutoScalingInstance.withOwner(ownerFullName);
        }

        protected AutoScalingInstance exampleWithName(OwnerFullName ownerFullName, String name) {
            return AutoScalingInstance.named(ownerFullName, name);
        }
    }
}

