/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.instances;

import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceCoreView;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public enum LifecycleState implements Predicate<AutoScalingInstance>
{
    Pending,
    Quarantined,
    InService,
    Terminating,
    Terminated;


    public boolean apply(@Nullable AutoScalingInstance instance) {
        return instance != null && this == instance.getLifecycleState();
    }

    public Predicate<AutoScalingInstanceCoreView> forView() {
        return new Predicate<AutoScalingInstanceCoreView>(){

            public boolean apply(@Nullable AutoScalingInstanceCoreView instance) {
                return instance != null && LifecycleState.this == instance.getLifecycleState();
            }
        };
    }

    public Predicate<AutoScalingInstance> transitionTo(LifecycleState to) {
        return new LifecycleStateTransition(this, to);
    }

    private static final class LifecycleStateTransition
    implements Predicate<AutoScalingInstance> {
        private final LifecycleState from;
        private final LifecycleState to;

        private LifecycleStateTransition(LifecycleState from, LifecycleState to) {
            this.from = from;
            this.to = to;
        }

        public boolean apply(AutoScalingInstance instance) {
            boolean transitioned = false;
            if (this.from.apply(instance)) {
                instance.setLifecycleState(this.to);
                transitioned = true;
            }
            return transitioned;
        }
    }
}

